/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.preferences;

import com.google.common.base.CharMatcher;
import javafx.application.Application;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextFormatter;
import javax.inject.Inject;
import org.cryptomator.common.LicenseHolder;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.common.settings.UiTheme;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.preferences.PreferencesScoped;

@PreferencesScoped
public class SupporterCertificateController
implements FxController {
    private static final String SUPPORTER_URI = "https://store.cryptomator.org/desktop";
    private final Application application;
    private final LicenseHolder licenseHolder;
    private final Settings settings;
    public TextArea supporterCertificateField;

    @Inject
    SupporterCertificateController(Application application, LicenseHolder licenseHolder, Settings settings) {
        this.application = application;
        this.licenseHolder = licenseHolder;
        this.settings = settings;
    }

    @FXML
    public void initialize() {
        this.supporterCertificateField.setText((String)this.licenseHolder.getLicenseKey().orElse(null));
        this.supporterCertificateField.textProperty().addListener(this::registrationKeyChanged);
        this.supporterCertificateField.setTextFormatter(new TextFormatter(this::removeWhitespaces));
    }

    private TextFormatter.Change removeWhitespaces(TextFormatter.Change change) {
        if (change.isContentChange()) {
            String strippedText = CharMatcher.whitespace().removeFrom((CharSequence)change.getText());
            change.setText(strippedText);
        }
        return change;
    }

    private void registrationKeyChanged(ObservableValue<? extends String> observable, String oldValue, String newValue) {
        this.licenseHolder.validateAndStoreLicense(newValue);
        if (!this.licenseHolder.isValidLicense()) {
            this.settings.theme.set((Object)UiTheme.LIGHT);
        }
    }

    @FXML
    public void getSupporterCertificate() {
        this.application.getHostServices().showDocument(SUPPORTER_URI);
    }

    public LicenseHolder getLicenseHolder() {
        return this.licenseHolder;
    }
}

