/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.migration;

import dagger.Lazy;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.ContentDisplay;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.common.Passphrase;
import org.cryptomator.common.keychain.KeychainManager;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultState;
import org.cryptomator.cryptofs.FileNameTooLongException;
import org.cryptomator.cryptofs.common.FileSystemCapabilityChecker;
import org.cryptomator.cryptofs.migration.Migrators;
import org.cryptomator.cryptofs.migration.api.MigrationContinuationListener;
import org.cryptomator.cryptofs.migration.api.MigrationProgressListener;
import org.cryptomator.cryptolib.api.InvalidPassphraseException;
import org.cryptomator.integrations.keychain.KeychainAccessException;
import org.cryptomator.ui.common.Animations;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.common.Tasks;
import org.cryptomator.ui.controls.NiceSecurePasswordField;
import org.cryptomator.ui.fxapp.FxApplicationWindows;
import org.cryptomator.ui.migration.MigrationScoped;
import org.cryptomator.ui.migration.MigrationWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MigrationScoped
public class MigrationRunController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationRunController.class);
    private static final long MIGRATION_PROGRESS_UPDATE_MILLIS = 50L;
    private final Stage window;
    private final Vault vault;
    private final ExecutorService executor;
    private final ScheduledExecutorService scheduler;
    private final KeychainManager keychain;
    private final ObjectProperty<FileSystemCapabilityChecker.Capability> missingCapability;
    private final FxApplicationWindows appWindows;
    private final Lazy<Scene> startScene;
    private final Lazy<Scene> successScene;
    private final Lazy<Scene> impossibleScene;
    private final ObjectBinding<ContentDisplay> migrateButtonContentDisplay;
    private final Lazy<Scene> capabilityErrorScene;
    private final BooleanProperty migrationButtonDisabled;
    private final DoubleProperty migrationProgress;
    private volatile double volatileMigrationProgress = -1.0;
    public NiceSecurePasswordField passwordField;

    @Inject
    public MigrationRunController(@MigrationWindow Stage window, @MigrationWindow Vault vault, ExecutorService executor, ScheduledExecutorService scheduler, KeychainManager keychain, @Named(value="capabilityErrorCause") ObjectProperty<FileSystemCapabilityChecker.Capability> missingCapability, @FxmlScene(value=FxmlFile.MIGRATION_START) Lazy<Scene> startScene, @FxmlScene(value=FxmlFile.MIGRATION_SUCCESS) Lazy<Scene> successScene, @FxmlScene(value=FxmlFile.MIGRATION_CAPABILITY_ERROR) Lazy<Scene> capabilityErrorScene, @FxmlScene(value=FxmlFile.MIGRATION_IMPOSSIBLE) Lazy<Scene> impossibleScene, FxApplicationWindows appWindows) {
        this.window = window;
        this.vault = vault;
        this.executor = executor;
        this.scheduler = scheduler;
        this.keychain = keychain;
        this.missingCapability = missingCapability;
        this.appWindows = appWindows;
        this.startScene = startScene;
        this.successScene = successScene;
        this.migrateButtonContentDisplay = Bindings.when((ObservableBooleanValue)vault.processingProperty()).then((Object)ContentDisplay.LEFT).otherwise((Object)ContentDisplay.TEXT_ONLY);
        this.capabilityErrorScene = capabilityErrorScene;
        this.migrationButtonDisabled = new SimpleBooleanProperty();
        this.migrationProgress = new SimpleDoubleProperty(this.volatileMigrationProgress);
        this.impossibleScene = impossibleScene;
    }

    public void initialize() {
        if (this.keychain.isSupported()) {
            this.loadStoredPassword();
        }
        this.migrationButtonDisabled.bind((ObservableValue)ObjectExpression.objectExpression((ObservableObjectValue)this.vault.stateProperty()).isNotEqualTo((Object)VaultState.Value.NEEDS_MIGRATION).or((ObservableBooleanValue)this.passwordField.textProperty().isEmpty()));
        this.window.setOnHiding(event -> this.passwordField.wipe());
    }

    @FXML
    public void back() {
        this.window.setScene((Scene)this.startScene.get());
    }

    @FXML
    public void migrate() {
        LOG.info("Migrating vault {}", (Object)this.vault.getPath());
        Passphrase password = this.passwordField.getCharacters();
        this.vault.stateProperty().transition(VaultState.Value.NEEDS_MIGRATION, VaultState.Value.PROCESSING);
        this.passwordField.setDisable(true);
        ScheduledFuture<?> progressSyncTask = this.scheduler.scheduleAtFixedRate(() -> Platform.runLater(() -> this.migrationProgress.set(this.volatileMigrationProgress)), 0L, 50L, TimeUnit.MILLISECONDS);
        Tasks.create(() -> {
            Migrators migrators = Migrators.get();
            migrators.migrate(this.vault.getPath(), "vault.cryptomator", "masterkey.cryptomator", password, this::migrationProgressChanged, this::migrationRequiresInput);
            return migrators.needsMigration(this.vault.getPath(), "vault.cryptomator", "masterkey.cryptomator");
        }).onSuccess(needsAnotherMigration -> {
            if (needsAnotherMigration.booleanValue()) {
                LOG.info("Migration of '{}' succeeded, but another migration is required.", (Object)this.vault.getDisplayName());
                this.vault.stateProperty().transition(VaultState.Value.PROCESSING, VaultState.Value.NEEDS_MIGRATION);
            } else {
                LOG.info("Migration of '{}' succeeded.", (Object)this.vault.getDisplayName());
                this.vault.stateProperty().transition(VaultState.Value.PROCESSING, VaultState.Value.LOCKED);
                this.passwordField.wipe();
                this.window.setScene((Scene)this.successScene.get());
            }
        }).onError(InvalidPassphraseException.class, e -> {
            Animations.createShakeWindowAnimation((Window)this.window).play();
            this.passwordField.setDisable(false);
            this.passwordField.selectAll();
            this.passwordField.requestFocus();
            this.vault.stateProperty().transition(VaultState.Value.PROCESSING, VaultState.Value.NEEDS_MIGRATION);
        }).onError(FileSystemCapabilityChecker.MissingCapabilityException.class, e -> {
            LOG.error("Underlying file system not supported.", (Throwable)e);
            this.vault.stateProperty().transition(VaultState.Value.PROCESSING, VaultState.Value.NEEDS_MIGRATION);
            this.missingCapability.set((Object)e.getMissingCapability());
            this.window.setScene((Scene)this.capabilityErrorScene.get());
        }).onError(FileNameTooLongException.class, e -> {
            LOG.error("Migration failed because the underlying file system does not support long filenames.", (Throwable)e);
            this.vault.stateProperty().transition(VaultState.Value.PROCESSING, VaultState.Value.NEEDS_MIGRATION);
            this.appWindows.showErrorWindow((Throwable)e, this.window, (Scene)this.startScene.get());
            this.window.setScene((Scene)this.impossibleScene.get());
        }).onError(Exception.class, e -> {
            LOG.error("Migration failed for technical reasons.", (Throwable)e);
            this.vault.stateProperty().transition(VaultState.Value.PROCESSING, VaultState.Value.NEEDS_MIGRATION);
            this.appWindows.showErrorWindow((Throwable)e, this.window, (Scene)this.startScene.get());
        }).andFinally(() -> {
            this.passwordField.setDisable(false);
            progressSyncTask.cancel(true);
        }).runOnce(this.executor);
    }

    private void migrationProgressChanged(MigrationProgressListener.ProgressState state, double progress) {
        this.volatileMigrationProgress = switch (state) {
            default -> throw new MatchException(null, null);
            case MigrationProgressListener.ProgressState.INITIALIZING -> -1.0;
            case MigrationProgressListener.ProgressState.MIGRATING -> progress;
            case MigrationProgressListener.ProgressState.FINALIZING -> 1.0;
        };
    }

    private MigrationContinuationListener.ContinuationResult migrationRequiresInput(MigrationContinuationListener.ContinuationEvent event) {
        return MigrationContinuationListener.ContinuationResult.PROCEED;
    }

    private void loadStoredPassword() {
        assert (this.keychain.isSupported());
        char[] storedPw = null;
        try {
            storedPw = this.keychain.loadPassphrase(this.vault.getId());
            if (storedPw != null) {
                this.passwordField.setPassword(storedPw);
                this.passwordField.selectRange(storedPw.length, storedPw.length);
            }
        }
        catch (KeychainAccessException e) {
            LOG.error("Failed to load entry from system keychain.", (Throwable)e);
        }
        finally {
            if (storedPw != null) {
                Arrays.fill(storedPw, ' ');
            }
        }
    }

    public Vault getVault() {
        return this.vault;
    }

    public BooleanProperty migrationButtonDisabledProperty() {
        return this.migrationButtonDisabled;
    }

    public boolean isMigrationButtonDisabled() {
        return this.migrationButtonDisabled.get();
    }

    public ObjectBinding<ContentDisplay> migrateButtonContentDisplayProperty() {
        return this.migrateButtonContentDisplay;
    }

    public ContentDisplay getMigrateButtonContentDisplay() {
        return (ContentDisplay)this.migrateButtonContentDisplay.get();
    }

    public ReadOnlyDoubleProperty migrationProgressProperty() {
        return this.migrationProgress;
    }

    public double getMigrationProgress() {
        return this.migrationProgress.get();
    }
}

