/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.mainwindow;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.tobiasdiez.easybind.EasyBind;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.TransferMode;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.integrations.mount.Mountpoint;
import org.cryptomator.integrations.revealpath.RevealFailedException;
import org.cryptomator.integrations.revealpath.RevealPathService;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.VaultService;
import org.cryptomator.ui.fxapp.FxApplicationWindows;
import org.cryptomator.ui.mainwindow.MainWindow;
import org.cryptomator.ui.mainwindow.MainWindowScoped;
import org.cryptomator.ui.stats.VaultStatisticsComponent;
import org.cryptomator.ui.wrongfilealert.WrongFileAlertComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MainWindowScoped
public class VaultDetailUnlockedController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(VaultDetailUnlockedController.class);
    private static final String ACTIVE_CLASS = "active";
    private final ReadOnlyObjectProperty<Vault> vault;
    private final FxApplicationWindows appWindows;
    private final VaultService vaultService;
    private final WrongFileAlertComponent.Builder wrongFileAlert;
    private final Stage mainWindow;
    private final Optional<RevealPathService> revealPathService;
    private final ResourceBundle resourceBundle;
    private final LoadingCache<Vault, VaultStatisticsComponent> vaultStats;
    private final VaultStatisticsComponent.Builder vaultStatsBuilder;
    private final ObservableValue<Boolean> accessibleViaPath;
    private final ObservableValue<Boolean> accessibleViaUri;
    private final ObservableValue<String> mountPoint;
    private final BooleanProperty draggingOver = new SimpleBooleanProperty();
    private final BooleanProperty ciphertextPathsCopied = new SimpleBooleanProperty();
    public Button dropZone;

    @Inject
    public VaultDetailUnlockedController(ObjectProperty<Vault> vault, FxApplicationWindows appWindows, VaultService vaultService, VaultStatisticsComponent.Builder vaultStatsBuilder, WrongFileAlertComponent.Builder wrongFileAlert, @MainWindow Stage mainWindow, Optional<RevealPathService> revealPathService, ResourceBundle resourceBundle) {
        this.vault = vault;
        this.appWindows = appWindows;
        this.vaultService = vaultService;
        this.wrongFileAlert = wrongFileAlert;
        this.mainWindow = mainWindow;
        this.revealPathService = revealPathService;
        this.resourceBundle = resourceBundle;
        this.vaultStats = CacheBuilder.newBuilder().weakValues().build(CacheLoader.from(this::buildVaultStats));
        this.vaultStatsBuilder = vaultStatsBuilder;
        ObservableValue mp = vault.flatMap(Vault::mountPointProperty);
        this.accessibleViaPath = mp.map(m -> m instanceof Mountpoint.WithPath).orElse((Object)false);
        this.accessibleViaUri = mp.map(m -> m instanceof Mountpoint.WithUri).orElse((Object)false);
        this.mountPoint = mp.map(m -> {
            if (m instanceof Mountpoint.WithPath) {
                Mountpoint.WithPath mwp = (Mountpoint.WithPath)m;
                return mwp.path().toString();
            }
            return m.uri().toASCIIString();
        });
    }

    public void initialize() {
        this.dropZone.setOnDragEntered(this::handleDragEvent);
        this.dropZone.setOnDragOver(this::handleDragEvent);
        this.dropZone.setOnDragDropped(this::handleDragEvent);
        this.dropZone.setOnDragExited(this::handleDragEvent);
        EasyBind.includeWhen((Collection)this.dropZone.getStyleClass(), (Object)ACTIVE_CLASS, (ObservableValue)this.draggingOver);
    }

    private void handleDragEvent(DragEvent event) {
        if (DragEvent.DRAG_OVER.equals(event.getEventType()) && event.getGestureSource() == null && event.getDragboard().hasFiles()) {
            if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_MAC) {
                event.acceptTransferModes(new TransferMode[]{TransferMode.LINK});
            } else {
                event.acceptTransferModes(TransferMode.ANY);
            }
            this.draggingOver.set(true);
        } else if (DragEvent.DRAG_DROPPED.equals(event.getEventType()) && event.getGestureSource() == null && event.getDragboard().hasFiles()) {
            List<Path> ciphertextPaths = event.getDragboard().getFiles().stream().map(File::toPath).map(this::getCiphertextPath).flatMap(Optional::stream).toList();
            if (ciphertextPaths.isEmpty()) {
                this.wrongFileAlert.build().showWrongFileAlertWindow();
            } else {
                this.revealOrCopyPaths(ciphertextPaths);
            }
            event.setDropCompleted(!ciphertextPaths.isEmpty());
            event.consume();
        } else if (DragEvent.DRAG_EXITED.equals(event.getEventType())) {
            this.draggingOver.set(false);
        }
    }

    private VaultStatisticsComponent buildVaultStats(Vault vault) {
        return this.vaultStatsBuilder.vault(vault).build();
    }

    @FXML
    public void revealAccessLocation() {
        this.vaultService.reveal((Vault)this.vault.get());
    }

    @FXML
    public void copyMountUri() {
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString((String)this.mountPoint.getValue());
        Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
    }

    @FXML
    public void lock() {
        this.appWindows.startLockWorkflow((Vault)this.vault.get(), this.mainWindow);
    }

    @FXML
    public void showVaultStatistics() {
        ((VaultStatisticsComponent)this.vaultStats.getUnchecked((Object)((Vault)this.vault.get()))).showVaultStatisticsWindow();
    }

    @FXML
    public void chooseFileAndReveal() {
        Preconditions.checkState((boolean)((Boolean)this.accessibleViaPath.getValue()));
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(this.resourceBundle.getString("main.vaultDetail.filePickerTitle"));
        fileChooser.setInitialDirectory(Path.of((String)this.mountPoint.getValue(), new String[0]).toFile());
        File cleartextFile = fileChooser.showOpenDialog((Window)this.mainWindow);
        if (cleartextFile != null) {
            List<Path> ciphertextPaths = this.getCiphertextPath(cleartextFile.toPath()).stream().toList();
            this.revealOrCopyPaths(ciphertextPaths);
        }
    }

    private boolean startsWithVaultAccessPoint(Path path) {
        return path.startsWith(Path.of((String)this.mountPoint.getValue(), new String[0]));
    }

    private Optional<Path> getCiphertextPath(Path path) {
        if (!this.startsWithVaultAccessPoint(path)) {
            LOG.debug("Path does not start with access point of selected vault: {}", (Object)path);
            return Optional.empty();
        }
        try {
            return Optional.of(((Vault)this.vault.get()).getCiphertextPath(path));
        }
        catch (IOException e) {
            LOG.warn("Unable to get ciphertext path from path: {}", (Object)path, (Object)e);
            return Optional.empty();
        }
    }

    private void revealOrCopyPaths(List<Path> paths) {
        this.revealPathService.ifPresentOrElse(svc -> this.revealPaths((RevealPathService)svc, paths), () -> {
            LOG.warn("No service provider to reveal files found.");
            this.copyPathsToClipboard(paths);
        });
    }

    private void revealPaths(RevealPathService service, List<Path> paths) {
        paths.forEach(path -> {
            try {
                LOG.debug("Revealing {}", path);
                service.reveal(path);
            }
            catch (RevealFailedException e) {
                LOG.error("Revealing ciphertext file failed.", (Throwable)e);
            }
        });
    }

    private void copyPathsToClipboard(List<Path> paths) {
        StringBuilder clipboardString = new StringBuilder();
        paths.forEach(p -> clipboardString.append(p.toString()).append("\n"));
        Clipboard.getSystemClipboard().setContent(Map.of(DataFormat.PLAIN_TEXT, clipboardString.toString()));
        this.ciphertextPathsCopied.setValue(Boolean.valueOf(true));
        CompletableFuture.delayedExecutor(2L, TimeUnit.SECONDS, Platform::runLater).execute(() -> this.ciphertextPathsCopied.set(false));
    }

    public ReadOnlyObjectProperty<Vault> vaultProperty() {
        return this.vault;
    }

    public Vault getVault() {
        return (Vault)this.vault.get();
    }

    public ObservableValue<Boolean> accessibleViaPathProperty() {
        return this.accessibleViaPath;
    }

    public boolean isAccessibleViaPath() {
        return (Boolean)this.accessibleViaPath.getValue();
    }

    public ObservableValue<Boolean> accessibleViaUriProperty() {
        return this.accessibleViaUri;
    }

    public boolean isAccessibleViaUri() {
        return (Boolean)this.accessibleViaUri.getValue();
    }

    public ObservableValue<String> mountPointProperty() {
        return this.mountPoint;
    }

    public String getMountPoint() {
        return (String)this.mountPoint.getValue();
    }

    public BooleanProperty ciphertextPathsCopiedProperty() {
        return this.ciphertextPathsCopied;
    }

    public boolean isCiphertextPathsCopied() {
        return this.ciphertextPathsCopied.get();
    }
}

