/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.lock;

import dagger.Lazy;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultState;
import org.cryptomator.integrations.mount.UnmountFailedException;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.fxapp.FxApplicationWindows;
import org.cryptomator.ui.lock.LockWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockWorkflow
extends Task<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(LockWorkflow.class);
    private final Stage lockWindow;
    private final Vault vault;
    private final AtomicReference<CompletableFuture<Boolean>> forceRetryDecision;
    private final Lazy<Scene> lockForcedScene;
    private final Lazy<Scene> lockFailedScene;
    private final FxApplicationWindows appWindows;

    @Inject
    public LockWorkflow(@LockWindow Stage lockWindow, @LockWindow Vault vault, AtomicReference<CompletableFuture<Boolean>> forceRetryDecision, @FxmlScene(value=FxmlFile.LOCK_FORCED) Lazy<Scene> lockForcedScene, @FxmlScene(value=FxmlFile.LOCK_FAILED) Lazy<Scene> lockFailedScene, FxApplicationWindows appWindows) {
        this.lockWindow = lockWindow;
        this.vault = vault;
        this.forceRetryDecision = forceRetryDecision;
        this.lockForcedScene = lockForcedScene;
        this.lockFailedScene = lockFailedScene;
        this.appWindows = appWindows;
    }

    protected Void call() throws InterruptedException, ExecutionException, IOException {
        this.lock(false);
        return null;
    }

    private void lock(boolean forced) throws InterruptedException, ExecutionException, IOException {
        try {
            this.vault.lock(forced);
        }
        catch (UnmountFailedException e) {
            LOG.info("Locking {} failed (forced: {}).", new Object[]{this.vault.getDisplayName(), forced, e});
            this.retryOrCancel();
        }
    }

    private void retryOrCancel() throws ExecutionException, InterruptedException, IOException {
        try {
            boolean forced = this.askWhetherToUseTheForce().get();
            this.lock(forced);
        }
        catch (CancellationException e) {
            this.cancel(false);
        }
    }

    private CompletableFuture<Boolean> askWhetherToUseTheForce() {
        CompletableFuture<Boolean> decision = new CompletableFuture<Boolean>();
        this.forceRetryDecision.set(decision);
        Platform.runLater(() -> {
            this.lockWindow.setScene((Scene)this.lockForcedScene.get());
            this.lockWindow.show();
            Window owner = this.lockWindow.getOwner();
            if (owner != null) {
                this.lockWindow.setX(owner.getX() + (owner.getWidth() - this.lockWindow.getWidth()) / 2.0);
                this.lockWindow.setY(owner.getY() + (owner.getHeight() - this.lockWindow.getHeight()) / 2.0);
            } else {
                this.lockWindow.centerOnScreen();
            }
        });
        return decision;
    }

    protected void succeeded() {
        LOG.info("Lock of {} succeeded.", (Object)this.vault.getDisplayName());
        this.vault.stateProperty().transition(VaultState.Value.PROCESSING, VaultState.Value.LOCKED);
    }

    protected void failed() {
        Throwable throwable = super.getException();
        LOG.warn("Lock of {} failed.", (Object)this.vault.getDisplayName(), (Object)throwable);
        this.vault.stateProperty().transition(VaultState.Value.PROCESSING, VaultState.Value.UNLOCKED);
        if (throwable instanceof UnmountFailedException) {
            this.lockWindow.setScene((Scene)this.lockFailedScene.get());
            this.lockWindow.show();
        } else {
            this.appWindows.showErrorWindow(throwable, this.lockWindow, null);
        }
    }

    protected void cancelled() {
        LOG.debug("Lock of {} canceled.", (Object)this.vault.getDisplayName());
        this.vault.stateProperty().transition(VaultState.Value.PROCESSING, VaultState.Value.UNLOCKED);
    }
}

