/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.lock;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Named;
import javax.inject.Provider;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.DefaultSceneFactory;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxControllerKey;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlLoaderFactory;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.common.StageFactory;
import org.cryptomator.ui.lock.LockFailedController;
import org.cryptomator.ui.lock.LockForcedController;
import org.cryptomator.ui.lock.LockScoped;
import org.cryptomator.ui.lock.LockWindow;
import org.jetbrains.annotations.Nullable;

@Module
abstract class LockModule {
    LockModule() {
    }

    @Provides
    @LockScoped
    static AtomicReference<CompletableFuture<Boolean>> provideForceRetryDecisionRef() {
        return new AtomicReference<CompletableFuture<Boolean>>();
    }

    @Provides
    @LockWindow
    @LockScoped
    static FxmlLoaderFactory provideFxmlLoaderFactory(Map<Class<? extends FxController>, Provider<FxController>> factories, DefaultSceneFactory sceneFactory, ResourceBundle resourceBundle) {
        return new FxmlLoaderFactory(factories, sceneFactory, resourceBundle);
    }

    @Provides
    @LockWindow
    @LockScoped
    static Stage provideWindow(StageFactory factory, @LockWindow Vault vault, @Named(value="lockWindowOwner") @Nullable Stage owner) {
        Stage stage = factory.create();
        stage.setTitle(vault.getDisplayName());
        stage.setResizable(false);
        if (owner != null) {
            stage.initOwner((Window)owner);
            stage.initModality(Modality.WINDOW_MODAL);
        } else {
            stage.initModality(Modality.APPLICATION_MODAL);
        }
        return stage;
    }

    @Provides
    @FxmlScene(value=FxmlFile.LOCK_FORCED)
    @LockScoped
    static Scene provideForceLockScene(@LockWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.LOCK_FORCED);
    }

    @Provides
    @FxmlScene(value=FxmlFile.LOCK_FAILED)
    @LockScoped
    static Scene provideLockFailedScene(@LockWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.LOCK_FAILED);
    }

    @Binds
    @IntoMap
    @FxControllerKey(value=LockForcedController.class)
    abstract FxController bindLockForcedController(LockForcedController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=LockFailedController.class)
    abstract FxController bindLockFailedController(LockFailedController var1);
}

