/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.keyloading.hub;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import com.nimbusds.jose.JWEObject;
import dagger.Lazy;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.lang.runtime.TemplateRuntime;
import java.net.InetAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.common.settings.DeviceKey;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.common.P384KeyPair;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.keyloading.KeyLoading;
import org.cryptomator.ui.keyloading.KeyLoadingScoped;
import org.cryptomator.ui.keyloading.hub.DeviceAlreadyExistsException;
import org.cryptomator.ui.keyloading.hub.HubConfig;
import org.cryptomator.ui.keyloading.hub.JWEHelper;
import org.cryptomator.ui.keyloading.hub.ReceivedKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KeyLoadingScoped
public class RegisterDeviceController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterDeviceController.class);
    private static final ObjectMapper JSON = new ObjectMapper().setDefaultLeniency(Boolean.valueOf(true));
    private static final Duration REQ_TIMEOUT = Duration.ofSeconds(10L);
    private final Stage window;
    private final HubConfig hubConfig;
    private final String bearerToken;
    private final Lazy<Scene> registerSuccessScene;
    private final Lazy<Scene> registerFailedScene;
    private final Lazy<Scene> deviceAlreadyExistsScene;
    private final String deviceId;
    private final P384KeyPair deviceKeyPair;
    private final CompletableFuture<ReceivedKey> result;
    private final HttpClient httpClient;
    private final BooleanProperty invalidSetupCode = new SimpleBooleanProperty(false);
    private final BooleanProperty workInProgress = new SimpleBooleanProperty(false);
    public TextField setupCodeField;
    public TextField deviceNameField;
    public Button registerBtn;

    @Inject
    public RegisterDeviceController(@KeyLoading Stage window, ExecutorService executor, HubConfig hubConfig, @Named(value="deviceId") String deviceId, DeviceKey deviceKey, CompletableFuture<ReceivedKey> result, @Named(value="bearerToken") AtomicReference<String> bearerToken, @FxmlScene(value=FxmlFile.HUB_REGISTER_SUCCESS) Lazy<Scene> registerSuccessScene, @FxmlScene(value=FxmlFile.HUB_REGISTER_FAILED) Lazy<Scene> registerFailedScene, @FxmlScene(value=FxmlFile.HUB_REGISTER_DEVICE_ALREADY_EXISTS) Lazy<Scene> deviceAlreadyExistsScene) {
        this.window = window;
        this.hubConfig = hubConfig;
        this.deviceId = deviceId;
        this.deviceKeyPair = Objects.requireNonNull(deviceKey.get());
        this.result = result;
        this.bearerToken = Objects.requireNonNull(bearerToken.get());
        this.registerSuccessScene = registerSuccessScene;
        this.registerFailedScene = registerFailedScene;
        this.deviceAlreadyExistsScene = deviceAlreadyExistsScene;
        this.window.addEventHandler(WindowEvent.WINDOW_HIDING, this::windowClosed);
        this.httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).executor(executor).build();
    }

    public void initialize() {
        this.deviceNameField.setText(this.determineHostname());
        this.deviceNameField.disableProperty().bind((ObservableValue)this.workInProgress);
        this.setupCodeField.textProperty().addListener(observable -> this.invalidSetupCode.set(false));
        this.setupCodeField.disableProperty().bind((ObservableValue)this.workInProgress);
        BooleanBinding missingSetupCode = this.setupCodeField.textProperty().isEmpty();
        BooleanBinding missingDeviceName = this.deviceNameField.textProperty().isEmpty();
        this.registerBtn.disableProperty().bind((ObservableValue)this.workInProgress.or((ObservableBooleanValue)missingSetupCode).or((ObservableBooleanValue)missingDeviceName));
        this.registerBtn.contentDisplayProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.workInProgress).then((Object)ContentDisplay.LEFT).otherwise((Object)ContentDisplay.TEXT_ONLY));
    }

    private String determineHostname() {
        try {
            String hostName = InetAddress.getLocalHost().getHostName();
            return Objects.requireNonNullElse(hostName, "");
        }
        catch (IOException e) {
            return "";
        }
    }

    @FXML
    public void register() {
        this.workInProgress.set(true);
        HttpRequest userReq = HttpRequest.newBuilder(this.hubConfig.URIs.API.process((StringTemplate)((Object)TemplateRuntime.newStringTemplate("process", new String[]{"users/me"})))).GET().timeout(REQ_TIMEOUT).header("Authorization", "Bearer " + this.bearerToken).header("Content-Type", "application/json").build();
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.httpClient.sendAsync(userReq, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8)).thenApply(response -> {
            if (response.statusCode() == 200) {
                UserDto dto = this.fromJson((String)response.body());
                return Objects.requireNonNull(dto, "null or empty response body");
            }
            throw new RuntimeException("Server answered with unexpected status code " + response.statusCode());
        })).thenApply(user -> {
            try {
                assert (user.privateKey != null && user.publicKey != null);
                ECPublicKey userPublicKey = JWEHelper.decodeECPublicKey(Base64.getDecoder().decode(user.publicKey));
                this.migrateLegacyDevices(userPublicKey);
                ECPrivateKey userKey = JWEHelper.decryptUserKey(JWEObject.parse((String)user.privateKey), this.setupCodeField.getText());
                return JWEHelper.encryptUserKey(userKey, this.deviceKeyPair.getPublic());
            }
            catch (ParseException | JWEHelper.KeyDecodeFailedException e) {
                throw new RuntimeException("Server answered with unparsable user key", (Throwable)e);
            }
        })).thenCompose(jwe -> {
            String now = Instant.now().toString();
            CreateDeviceDto dto = new CreateDeviceDto(this.deviceId, this.deviceNameField.getText(), BaseEncoding.base64().encode(this.deviceKeyPair.getPublic().getEncoded()), "DESKTOP", jwe.serialize(), now);
            String json = this.toJson(dto);
            URI deviceUri = this.hubConfig.URIs.API.process((StringTemplate)((Object)TemplateRuntime.newStringTemplate("process", new String[]{"devices/", ""}, (String)this.deviceId)));
            HttpRequest putDeviceReq = HttpRequest.newBuilder(deviceUri).PUT(HttpRequest.BodyPublishers.ofString(json, StandardCharsets.UTF_8)).timeout(REQ_TIMEOUT).header("Authorization", "Bearer " + this.bearerToken).header("Content-Type", "application/json").build();
            return this.httpClient.sendAsync(putDeviceReq, HttpResponse.BodyHandlers.discarding());
        })).whenCompleteAsync((response, throwable) -> {
            if (response != null) {
                this.handleRegisterDeviceResponse((HttpResponse<Void>)response);
            } else {
                this.setupFailed((Throwable)throwable);
            }
            this.workInProgress.set(false);
        }, Platform::runLater);
    }

    private void migrateLegacyDevices(ECPublicKey userPublicKey) {
        try {
            URI getUri = this.hubConfig.URIs.API.process((StringTemplate)((Object)TemplateRuntime.newStringTemplate("process", new String[]{"devices/", "/legacy-access-tokens"}, (String)this.deviceId)));
            HttpRequest getReq = HttpRequest.newBuilder(getUri).GET().timeout(REQ_TIMEOUT).header("Authorization", "Bearer " + this.bearerToken).build();
            HttpResponse<String> getRes = this.httpClient.send(getReq, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            if (getRes.statusCode() != 200) {
                LOG.debug("GET {} resulted in status code {}. Skipping migration.", (Object)getUri, (Object)getRes.statusCode());
                return;
            }
            Map legacyAccessTokens = (Map)JSON.readerForMapOf(String.class).readValue(getRes.body());
            if (legacyAccessTokens.isEmpty()) {
                return;
            }
            Map<String, String> newAccessTokens = legacyAccessTokens.entrySet().stream().mapMulti((entry, consumer) -> {
                try (Masterkey vaultKey = JWEHelper.decryptVaultKey(JWEObject.parse((String)((String)entry.getValue())), this.deviceKeyPair.getPrivate());){
                    String newAccessToken = JWEHelper.encryptVaultKey(vaultKey, userPublicKey).serialize();
                    consumer.accept(Map.entry((String)entry.getKey(), newAccessToken));
                }
                catch (ParseException | JWEHelper.InvalidJweKeyException e) {
                    LOG.warn("Failed to decrypt legacy access token for vault {}. Skipping migration.", entry.getKey());
                }
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            URI postUri = this.hubConfig.URIs.API.process((StringTemplate)((Object)TemplateRuntime.newStringTemplate("process", new String[]{"users/me/access-tokens"})));
            String postBody = JSON.writer().writeValueAsString(newAccessTokens);
            HttpRequest postReq = HttpRequest.newBuilder(postUri).POST(HttpRequest.BodyPublishers.ofString(postBody)).timeout(REQ_TIMEOUT).header("Authorization", "Bearer " + this.bearerToken).build();
            HttpResponse<String> postRes = this.httpClient.send(postReq, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            if (postRes.statusCode() != 200) {
                throw new IOException("Unexpected response from POST " + String.valueOf(postUri) + ": " + postRes.statusCode());
            }
        }
        catch (IOException e) {
            LOG.error("Legacy Device Migration failed.", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedIOException(new InterruptedIOException("Legacy Device Migration interrupted"));
        }
    }

    private UserDto fromJson(String json) {
        try {
            return (UserDto)JSON.reader().readValue(json, UserDto.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to deserialize DTO", e);
        }
    }

    private String toJson(CreateDeviceDto dto) {
        try {
            return JSON.writer().writeValueAsString((Object)dto);
        }
        catch (JacksonException e) {
            throw new IllegalStateException("Failed to serialize DTO", e);
        }
    }

    private void handleRegisterDeviceResponse(HttpResponse<Void> response) {
        if (response.statusCode() == 201) {
            LOG.debug("Device registration for hub instance {} successful.", (Object)this.hubConfig.authSuccessUrl);
            this.window.setScene((Scene)this.registerSuccessScene.get());
        } else if (response.statusCode() == 409) {
            this.setupFailed((Throwable)((Object)new DeviceAlreadyExistsException()));
        } else {
            this.setupFailed(new IllegalStateException("Unexpected http status code " + response.statusCode()));
        }
    }

    private void setupFailed(Throwable cause) {
        Throwable throwable = cause;
        Objects.requireNonNull(throwable);
        Throwable throwable2 = throwable;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CompletionException.class, DeviceAlreadyExistsException.class}, (Object)throwable2, n)) {
                case 0: {
                    CompletionException e = (CompletionException)throwable2;
                    if (!(e.getCause() instanceof JWEHelper.InvalidJweKeyException)) {
                        n = 1;
                        continue block4;
                    }
                    this.invalidSetupCode.set(true);
                    break block4;
                }
                case 1: {
                    DeviceAlreadyExistsException e = (DeviceAlreadyExistsException)((Object)throwable2);
                    LOG.debug("Device already registered in hub instance {} for different user", (Object)this.hubConfig.authSuccessUrl);
                    this.window.setScene((Scene)this.deviceAlreadyExistsScene.get());
                    break block4;
                }
                default: {
                    LOG.warn("Device setup failed.", cause);
                    this.window.setScene((Scene)this.registerFailedScene.get());
                    break block4;
                }
            }
            break;
        }
    }

    @FXML
    public void close() {
        this.window.close();
    }

    private void windowClosed(WindowEvent windowEvent) {
        this.result.cancel(true);
    }

    public BooleanProperty invalidSetupCodeProperty() {
        return this.invalidSetupCode;
    }

    public boolean isInvalidSetupCode() {
        return this.invalidSetupCode.get();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private record UserDto(String id, String name, String publicKey, String privateKey, String setupCode) {
    }

    private record CreateDeviceDto(@JsonProperty(required=true) String id, @JsonProperty(required=true) String name, @JsonProperty(required=true) String publicKey, @JsonProperty(required=true, defaultValue="DESKTOP") String type, @JsonProperty(required=true) String userPrivateKey, @JsonProperty(required=true) String creationTime) {
    }
}

