/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.keyloading.hub;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.nimbusds.jose.JWEObject;
import dagger.Lazy;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.runtime.TemplateRuntime;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.keyloading.KeyLoading;
import org.cryptomator.ui.keyloading.KeyLoadingScoped;
import org.cryptomator.ui.keyloading.hub.HubConfig;
import org.cryptomator.ui.keyloading.hub.ReceivedKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KeyLoadingScoped
public class ReceiveKeyController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(ReceiveKeyController.class);
    private static final String SCHEME_PREFIX = "hub+";
    private static final ObjectMapper JSON = new ObjectMapper().setDefaultLeniency(Boolean.valueOf(true));
    private static final Duration REQ_TIMEOUT = Duration.ofSeconds(10L);
    private final Stage window;
    private final HubConfig hubConfig;
    private final String vaultId;
    private final String deviceId;
    private final String bearerToken;
    private final CompletableFuture<ReceivedKey> result;
    private final Lazy<Scene> registerDeviceScene;
    private final Lazy<Scene> legacyRegisterDeviceScene;
    private final Lazy<Scene> unauthorizedScene;
    private final Lazy<Scene> accountInitializationScene;
    private final Lazy<Scene> invalidLicenseScene;
    private final HttpClient httpClient;

    @Inject
    public ReceiveKeyController(@KeyLoading Vault vault, ExecutorService executor, @KeyLoading Stage window, HubConfig hubConfig, @Named(value="deviceId") String deviceId, @Named(value="bearerToken") AtomicReference<String> tokenRef, CompletableFuture<ReceivedKey> result, @FxmlScene(value=FxmlFile.HUB_REGISTER_DEVICE) Lazy<Scene> registerDeviceScene, @FxmlScene(value=FxmlFile.HUB_LEGACY_REGISTER_DEVICE) Lazy<Scene> legacyRegisterDeviceScene, @FxmlScene(value=FxmlFile.HUB_UNAUTHORIZED_DEVICE) Lazy<Scene> unauthorizedScene, @FxmlScene(value=FxmlFile.HUB_REQUIRE_ACCOUNT_INIT) Lazy<Scene> accountInitializationScene, @FxmlScene(value=FxmlFile.HUB_INVALID_LICENSE) Lazy<Scene> invalidLicenseScene) {
        this.window = window;
        this.hubConfig = hubConfig;
        this.vaultId = ReceiveKeyController.extractVaultId(vault.getVaultConfigCache().getUnchecked().getKeyId());
        this.deviceId = deviceId;
        this.bearerToken = Objects.requireNonNull(tokenRef.get());
        this.result = result;
        this.registerDeviceScene = registerDeviceScene;
        this.legacyRegisterDeviceScene = legacyRegisterDeviceScene;
        this.unauthorizedScene = unauthorizedScene;
        this.accountInitializationScene = accountInitializationScene;
        this.invalidLicenseScene = invalidLicenseScene;
        this.window.addEventHandler(WindowEvent.WINDOW_HIDING, this::windowClosed);
        this.httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).executor(executor).build();
    }

    @FXML
    public void initialize() {
        this.receiveKey();
    }

    public void receiveKey() {
        this.requestApiConfig();
    }

    private void requestApiConfig() {
        URI configUri = this.hubConfig.URIs.API.process((StringTemplate)((Object)TemplateRuntime.newStringTemplate("process", new String[]{"config"})));
        HttpRequest request = HttpRequest.newBuilder(configUri).GET().timeout(REQ_TIMEOUT).build();
        ((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.US_ASCII)).thenAcceptAsync(this::receivedApiConfig, Platform::runLater)).exceptionally(this::retrievalFailed);
    }

    private void receivedApiConfig(HttpResponse<String> response) {
        LOG.debug("GET {} -> Status Code {}", (Object)response.request().uri(), (Object)response.statusCode());
        Preconditions.checkState((response.statusCode() == 200 ? 1 : 0) != 0, (Object)("Unexpected response " + response.statusCode()));
        try {
            ConfigDto config = (ConfigDto)JSON.reader().readValue(response.body(), ConfigDto.class);
            if (config.apiLevel >= 1) {
                this.requestDeviceData();
            } else {
                this.requestLegacyAccessToken();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void requestDeviceData() {
        URI deviceUri = this.hubConfig.URIs.API.process((StringTemplate)((Object)TemplateRuntime.newStringTemplate("process", new String[]{"devices/", ""}, (String)this.deviceId)));
        HttpRequest request = HttpRequest.newBuilder(deviceUri).header("Authorization", "Bearer " + this.bearerToken).GET().timeout(REQ_TIMEOUT).build();
        ((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8)).thenAcceptAsync(this::receivedDeviceData)).exceptionally(this::retrievalFailed);
    }

    private void receivedDeviceData(HttpResponse<String> response) {
        LOG.debug("GET {} -> Status Code {}", (Object)response.request().uri(), (Object)response.statusCode());
        try {
            switch (response.statusCode()) {
                case 200: {
                    DeviceDto device = (DeviceDto)JSON.reader().readValue(response.body(), DeviceDto.class);
                    this.requestVaultMasterkey(device.userPrivateKey);
                    break;
                }
                case 404: {
                    Platform.runLater(this::needsDeviceRegistration);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected response " + response.statusCode());
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void needsDeviceRegistration() {
        this.window.setScene((Scene)this.registerDeviceScene.get());
    }

    private void requestVaultMasterkey(String encryptedUserKey) {
        URI vaultKeyUri = this.hubConfig.URIs.API.process((StringTemplate)((Object)TemplateRuntime.newStringTemplate("process", new String[]{"vaults/", "/access-token"}, (String)this.vaultId)));
        HttpRequest request = HttpRequest.newBuilder(vaultKeyUri).header("Authorization", "Bearer " + this.bearerToken).GET().timeout(REQ_TIMEOUT).build();
        ((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.US_ASCII)).thenAcceptAsync(response -> this.receivedVaultMasterkey(encryptedUserKey, (HttpResponse<String>)response), Platform::runLater)).exceptionally(this::retrievalFailed);
    }

    private void receivedVaultMasterkey(String encryptedUserKey, HttpResponse<String> response) {
        LOG.debug("GET {} -> Status Code {}", (Object)response.request().uri(), (Object)response.statusCode());
        switch (response.statusCode()) {
            case 200: {
                this.receivedBothEncryptedKeys(response.body(), encryptedUserKey);
                break;
            }
            case 402: {
                this.licenseExceeded();
                break;
            }
            case 403: 
            case 410: {
                this.accessNotGranted();
                break;
            }
            case 449: {
                this.accountInitializationRequired();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected response " + response.statusCode());
            }
        }
    }

    private void receivedBothEncryptedKeys(String encryptedVaultKey, String encryptedUserKey) {
        try {
            JWEObject vaultKeyJwe = JWEObject.parse((String)encryptedVaultKey);
            JWEObject userKeyJwe = JWEObject.parse((String)encryptedUserKey);
            this.result.complete(ReceivedKey.vaultKeyAndUserKey(vaultKeyJwe, userKeyJwe));
            this.window.close();
        }
        catch (ParseException e) {
            this.retrievalFailed(e);
        }
    }

    @Deprecated
    private void requestLegacyAccessToken() {
        URI legacyAccessTokenUri = this.hubConfig.URIs.API.process((StringTemplate)((Object)TemplateRuntime.newStringTemplate("process", new String[]{"vaults/", "/keys/", ""}, (String)this.vaultId, this.deviceId)));
        HttpRequest request = HttpRequest.newBuilder(legacyAccessTokenUri).header("Authorization", "Bearer " + this.bearerToken).GET().timeout(REQ_TIMEOUT).build();
        ((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.US_ASCII)).thenAcceptAsync(this::receivedLegacyAccessTokenResponse, Platform::runLater)).exceptionally(this::retrievalFailed);
    }

    @Deprecated
    private void receivedLegacyAccessTokenResponse(HttpResponse<String> response) {
        try {
            switch (response.statusCode()) {
                case 200: {
                    this.receivedLegacyAccessTokenSuccess(response.body());
                    break;
                }
                case 402: {
                    this.licenseExceeded();
                    break;
                }
                case 403: 
                case 410: {
                    this.accessNotGranted();
                    break;
                }
                case 404: {
                    this.needsLegacyDeviceRegistration();
                    break;
                }
                default: {
                    throw new IOException("Unexpected response " + response.statusCode());
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Deprecated
    private void receivedLegacyAccessTokenSuccess(String rawToken) throws IOException {
        try {
            JWEObject token = JWEObject.parse((String)rawToken);
            this.result.complete(ReceivedKey.legacyDeviceKey(token));
            this.window.close();
        }
        catch (ParseException e) {
            throw new IOException("Failed to parse JWE", e);
        }
    }

    private void licenseExceeded() {
        this.window.setScene((Scene)this.invalidLicenseScene.get());
    }

    @Deprecated
    private void needsLegacyDeviceRegistration() {
        this.window.setScene((Scene)this.legacyRegisterDeviceScene.get());
    }

    private void accessNotGranted() {
        this.window.setScene((Scene)this.unauthorizedScene.get());
    }

    private void accountInitializationRequired() {
        this.window.setScene((Scene)this.accountInitializationScene.get());
    }

    private Void retrievalFailed(Throwable cause) {
        this.result.completeExceptionally(cause);
        return null;
    }

    @FXML
    public void cancel() {
        this.window.close();
    }

    private void windowClosed(WindowEvent windowEvent) {
        this.result.cancel(true);
    }

    private static URI appendPath(URI base, String path) {
        try {
            String newPath = base.getPath() + path;
            return new URI(base.getScheme(), base.getAuthority(), newPath, base.getQuery(), base.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Can't append '" + path + "' to URI: " + String.valueOf(base), e);
        }
    }

    private static String extractVaultId(URI vaultKeyUri) {
        assert (vaultKeyUri.getScheme().startsWith(SCHEME_PREFIX));
        String path = vaultKeyUri.getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private record ConfigDto(@JsonProperty(value="apiLevel") int apiLevel) {
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private record DeviceDto(@JsonProperty(value="userPrivateKey", required=true) String userPrivateKey) {
    }
}

