/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.fxapp;

import java.net.URL;
import java.util.Optional;
import javafx.application.Application;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javax.inject.Inject;
import org.cryptomator.common.LicenseHolder;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.common.settings.UiTheme;
import org.cryptomator.integrations.uiappearance.Theme;
import org.cryptomator.integrations.uiappearance.UiAppearanceException;
import org.cryptomator.integrations.uiappearance.UiAppearanceListener;
import org.cryptomator.integrations.uiappearance.UiAppearanceProvider;
import org.cryptomator.ui.fxapp.FxApplicationScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxApplicationScoped
public class FxApplicationStyle {
    private static final Logger LOG = LoggerFactory.getLogger(FxApplicationStyle.class);
    private final Settings settings;
    private final Optional<UiAppearanceProvider> appearanceProvider;
    private final LicenseHolder licenseHolder;
    private final UiAppearanceListener systemInterfaceThemeListener = this::systemInterfaceThemeChanged;
    private final ObjectProperty<Theme> appliedTheme = new SimpleObjectProperty((Object)Theme.LIGHT);

    @Inject
    public FxApplicationStyle(Settings settings, Optional<UiAppearanceProvider> appearanceProvider, LicenseHolder licenseHolder) {
        this.settings = settings;
        this.appearanceProvider = appearanceProvider;
        this.licenseHolder = licenseHolder;
    }

    public void initialize() {
        this.settings.theme.addListener(this::appThemeChanged);
        this.loadSelectedStyleSheet((UiTheme)((Object)this.settings.theme.get()));
    }

    private void appThemeChanged(ObservableValue<? extends UiTheme> observable, UiTheme oldValue, UiTheme newValue) {
        if (this.appearanceProvider.isPresent() && oldValue == UiTheme.AUTOMATIC && newValue != UiTheme.AUTOMATIC) {
            try {
                this.appearanceProvider.get().removeListener(this.systemInterfaceThemeListener);
            }
            catch (UiAppearanceException e) {
                LOG.error("Failed to disable automatic theme switching.");
            }
        }
        this.loadSelectedStyleSheet(newValue);
    }

    private void loadSelectedStyleSheet(UiTheme desiredTheme) {
        UiTheme theme = this.licenseHolder.isValidLicense() ? desiredTheme : UiTheme.LIGHT;
        switch (theme) {
            case LIGHT: {
                this.applyLightTheme();
                break;
            }
            case DARK: {
                this.applyDarkTheme();
                break;
            }
            case AUTOMATIC: {
                this.appearanceProvider.ifPresent(provider -> {
                    try {
                        provider.addListener(this.systemInterfaceThemeListener);
                    }
                    catch (UiAppearanceException e) {
                        LOG.error("Failed to enable automatic theme switching.");
                    }
                });
                this.applySystemTheme();
            }
        }
    }

    private void systemInterfaceThemeChanged(Theme theme) {
        switch (theme) {
            case LIGHT: {
                this.applyLightTheme();
                break;
            }
            case DARK: {
                this.applyDarkTheme();
            }
        }
    }

    private void applySystemTheme() {
        if (this.appearanceProvider.isPresent()) {
            this.systemInterfaceThemeChanged(this.appearanceProvider.get().getSystemTheme());
        } else {
            LOG.warn("No UiAppearanceProvider present, assuming LIGHT theme...");
            this.applyLightTheme();
        }
    }

    private void applyLightTheme() {
        URL stylesheet = Optional.ofNullable(this.getClass().getResource("/css/light_theme.bss")).orElse(this.getClass().getResource("/css/light_theme.css"));
        if (stylesheet == null) {
            LOG.warn("Failed to load light_theme stylesheet");
        } else {
            Application.setUserAgentStylesheet((String)stylesheet.toString());
            this.appearanceProvider.ifPresent(provider -> provider.adjustToTheme(Theme.LIGHT));
            this.appliedTheme.set((Object)Theme.LIGHT);
        }
    }

    private void applyDarkTheme() {
        URL stylesheet = Optional.ofNullable(this.getClass().getResource("/css/dark_theme.bss")).orElse(this.getClass().getResource("/css/dark_theme.css"));
        if (stylesheet == null) {
            LOG.warn("Failed to load dark_theme stylesheet");
        } else {
            Application.setUserAgentStylesheet((String)stylesheet.toString());
            this.appearanceProvider.ifPresent(provider -> provider.adjustToTheme(Theme.DARK));
            this.appliedTheme.set((Object)Theme.DARK);
        }
    }

    public ObjectProperty<Theme> appliedThemeProperty() {
        return this.appliedTheme;
    }
}

