/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.fxapp;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import javax.inject.Inject;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultListManager;
import org.cryptomator.ui.fxapp.FxApplicationScoped;
import org.cryptomator.ui.fxapp.FxApplicationWindows;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxApplicationScoped
public class AutoUnlocker {
    private static final Logger LOG = LoggerFactory.getLogger(AutoUnlocker.class);
    private final ObservableList<Vault> vaults;
    private final FxApplicationWindows appWindows;
    private final ScheduledExecutorService scheduler;
    private ScheduledFuture<?> unlockMissingFuture;
    private ScheduledFuture<?> timeoutFuture;

    @Inject
    public AutoUnlocker(ObservableList<Vault> vaults, FxApplicationWindows appWindows, ScheduledExecutorService scheduler) {
        this.vaults = vaults;
        this.appWindows = appWindows;
        this.scheduler = scheduler;
    }

    public void tryUnlockForTimespan(int timespan, TimeUnit timeUnit) {
        Predicate<Vault> shouldAutoUnlock = v -> v.getVaultSettings().unlockAfterStartup.get();
        this.unlockSequentially(this.vaults.stream().filter(shouldAutoUnlock)).thenRun(() -> this.startUnlockMissing(timespan, timeUnit));
    }

    private CompletionStage<Void> unlockSequentially(Stream<Vault> vaultStream) {
        return vaultStream.filter(Vault::isLocked).reduce(CompletableFuture.completedFuture(null), (prevUnlock, nextVault) -> prevUnlock.thenCompose(unused -> this.appWindows.startUnlockWorkflow((Vault)nextVault, null)), (prevUnlock, nextUnlock) -> nextUnlock.exceptionally(e -> null));
    }

    private void startUnlockMissing(int timespan, TimeUnit timeUnit) {
        if (this.getMissingAutoUnlockVaults().findAny().isPresent()) {
            LOG.info("Found MISSING vaults, starting periodic check");
            this.unlockMissingFuture = this.scheduler.scheduleWithFixedDelay(this::unlockMissing, 0L, 1L, TimeUnit.SECONDS);
            this.timeoutFuture = this.scheduler.schedule(this::timeout, (long)timespan, timeUnit);
        }
    }

    private void unlockMissing() {
        List<Vault> missingAutoUnlockVaults = this.getMissingAutoUnlockVaults().toList();
        missingAutoUnlockVaults.forEach(VaultListManager::redetermineVaultState);
        this.unlockSequentially(missingAutoUnlockVaults.stream()).thenRun(this::stopUnlockMissing);
    }

    private void stopUnlockMissing() {
        if (this.getMissingAutoUnlockVaults().findAny().isEmpty()) {
            LOG.info("No more MISSING vaults, stopping periodic check");
            this.unlockMissingFuture.cancel(false);
            this.timeoutFuture.cancel(false);
        }
    }

    private void timeout() {
        LOG.info("MISSING vaults periodic check timed out");
        this.unlockMissingFuture.cancel(false);
    }

    private Stream<Vault> getMissingAutoUnlockVaults() {
        return this.vaults.stream().filter(Vault::isMissing).filter(v -> v.getVaultSettings().unlockAfterStartup.get());
    }
}

