/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.convertvault;

import com.google.common.base.Preconditions;
import dagger.Lazy;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.cryptomator.common.Constants;
import org.cryptomator.common.Passphrase;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.cryptofs.VaultConfig;
import org.cryptomator.cryptofs.VaultVersionMismatchException;
import org.cryptomator.cryptofs.common.BackupHelper;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.api.MasterkeyLoadingFailedException;
import org.cryptomator.cryptolib.common.MasterkeyFileAccess;
import org.cryptomator.ui.changepassword.NewPasswordController;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.convertvault.ConvertVaultWindow;
import org.cryptomator.ui.fxapp.FxApplicationWindows;
import org.cryptomator.ui.recoverykey.RecoveryKeyFactory;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HubToPasswordConvertController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(HubToPasswordConvertController.class);
    private final Stage window;
    private final Lazy<Scene> successScene;
    private final FxApplicationWindows applicationWindows;
    private final Vault vault;
    private final StringProperty recoveryKey;
    private final RecoveryKeyFactory recoveryKeyFactory;
    private final MasterkeyFileAccess masterkeyFileAccess;
    private final ExecutorService backgroundExecutorService;
    private final ResourceBundle resourceBundle;
    private final BooleanProperty conversionStarted;
    @FXML
    NewPasswordController newPasswordController;
    public Button convertBtn;

    @Inject
    public HubToPasswordConvertController(@ConvertVaultWindow Stage window, @FxmlScene(value=FxmlFile.CONVERTVAULT_HUBTOPASSWORD_SUCCESS) Lazy<Scene> successScene, FxApplicationWindows applicationWindows, @ConvertVaultWindow Vault vault, @ConvertVaultWindow StringProperty recoveryKey, RecoveryKeyFactory recoveryKeyFactory, MasterkeyFileAccess masterkeyFileAccess, ExecutorService backgroundExecutorService, ResourceBundle resourceBundle) {
        this.window = window;
        this.successScene = successScene;
        this.applicationWindows = applicationWindows;
        this.vault = vault;
        this.recoveryKey = recoveryKey;
        this.recoveryKeyFactory = recoveryKeyFactory;
        this.masterkeyFileAccess = masterkeyFileAccess;
        this.backgroundExecutorService = backgroundExecutorService;
        this.resourceBundle = resourceBundle;
        this.conversionStarted = new SimpleBooleanProperty(false);
    }

    @FXML
    public void initialize() {
        this.convertBtn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.newPasswordController.isGoodPassword() || this.conversionStarted.get(), (Observable[])new Observable[]{this.newPasswordController.goodPasswordProperty(), this.conversionStarted}));
        this.convertBtn.contentDisplayProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> this.conversionStarted.getValue() != false ? ContentDisplay.LEFT : ContentDisplay.TEXT_ONLY, (Observable[])new Observable[]{this.conversionStarted}));
        this.convertBtn.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> this.resourceBundle.getString("convertVault.convert.convertBtn." + (this.conversionStarted.get() ? "processing" : "before")), (Observable[])new Observable[]{this.conversionStarted}));
    }

    @FXML
    public void close() {
        this.window.close();
    }

    @FXML
    public void convert() {
        Preconditions.checkState((boolean)this.newPasswordController.isGoodPassword());
        LOG.info("Converting access method of vault {} from hub to password", (Object)this.vault.getPath());
        ((CompletableFuture)CompletableFuture.runAsync(() -> this.conversionStarted.setValue(Boolean.valueOf(true)), Platform::runLater).thenRunAsync(this::convertInternal, this.backgroundExecutorService)).whenCompleteAsync((result, exception) -> {
            if (exception == null) {
                LOG.info("Conversion of vault {} succeeded.", (Object)this.vault.getPath());
                this.window.setScene((Scene)this.successScene.get());
            } else {
                LOG.error("Conversion of vault {} failed.", (Object)this.vault.getPath(), exception);
                this.applicationWindows.showErrorWindow((Throwable)exception, this.window, null);
            }
        }, Platform::runLater);
    }

    @VisibleForTesting
    void convertInternal() throws CompletionException, IllegalArgumentException {
        Passphrase passphrase = this.newPasswordController.getNewPassword();
        Path vaultPath = this.vault.getPath();
        try {
            this.recoveryKeyFactory.newMasterkeyFileWithPassphrase(vaultPath, (String)this.recoveryKey.get(), passphrase);
            LOG.debug("Successfully created masterkey file for vault {}", (Object)vaultPath);
            Path passwordConfigPath = vaultPath.resolve("passwordBased.vault.cryptomator.tmp");
            passwordConfigPath = this.createPasswordConfig(passwordConfigPath, vaultPath.resolve("masterkey.cryptomator"), passphrase);
            Path hubConfigPath = vaultPath.resolve("vault.cryptomator");
            this.backupHubConfig(hubConfigPath);
            Files.move(passwordConfigPath, hubConfigPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (MasterkeyLoadingFailedException e) {
            throw new CompletionException(new IOException("Vault conversion failed", e));
        }
        catch (IOException e) {
            throw new CompletionException("Vault conversion failed", e);
        }
        finally {
            passphrase.destroy();
        }
    }

    @VisibleForTesting
    void backupHubConfig(Path hubConfigPath) throws IOException {
        byte[] hubConfigBytes = Files.readAllBytes(hubConfigPath);
        Path backupPath = hubConfigPath.resolveSibling("vault.cryptomator" + BackupHelper.generateFileIdSuffix((byte[])hubConfigBytes) + ".bkup");
        Files.copy(hubConfigPath, backupPath, StandardCopyOption.REPLACE_EXISTING);
        LOG.debug("Successfully created hub config backup {}", (Object)backupPath.getFileName());
    }

    @VisibleForTesting
    Path createPasswordConfig(Path passwordConfigPath, Path masterkeyFile, Passphrase passphrase) throws IOException, MasterkeyLoadingFailedException {
        VaultConfig.UnverifiedVaultConfig unverifiedVaultConfig = this.vault.getVaultConfigCache().get();
        try (Masterkey masterkey = this.masterkeyFileAccess.load(masterkeyFile, (CharSequence)passphrase);){
            VaultConfig hubConfig = unverifiedVaultConfig.verify(masterkey.getEncoded(), unverifiedVaultConfig.allegedVaultVersion());
            VaultConfig passwordConfig = VaultConfig.createNew().cipherCombo(hubConfig.getCipherCombo()).shorteningThreshold(hubConfig.getShorteningThreshold()).build();
            if (passwordConfig.getVaultVersion() != hubConfig.getVaultVersion()) {
                throw new VaultVersionMismatchException("Only vaults of version " + passwordConfig.getVaultVersion() + " can be converted.");
            }
            String token = passwordConfig.toToken(Constants.DEFAULT_KEY_ID.toString(), masterkey.getEncoded());
            Files.writeString(passwordConfigPath, (CharSequence)token, StandardCharsets.US_ASCII, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
            LOG.debug("Successfully created password config {}", (Object)passwordConfigPath);
            Path path = passwordConfigPath;
            return path;
        }
    }
}

