/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.common;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.concurrent.ScheduledService;
import javafx.concurrent.Task;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tasks {
    private static final Logger LOG = LoggerFactory.getLogger(Tasks.class);

    public static <T> TaskBuilder<T> create(Callable<T> callable) {
        return new TaskBuilder<T>(callable);
    }

    public static TaskBuilder<Void> create(VoidCallable callable) {
        return Tasks.create(() -> {
            callable.call();
            return null;
        });
    }

    public static class TaskBuilder<T> {
        private final Callable<T> callable;
        private Consumer<T> successHandler = x -> {};
        private List<ErrorHandler<?>> errorHandlers = new ArrayList();
        private Runnable finallyHandler = () -> {};

        TaskBuilder(Callable<T> callable) {
            this.callable = callable;
        }

        public TaskBuilder<T> onSuccess(Runnable successHandler) {
            this.successHandler = x -> successHandler.run();
            return this;
        }

        public TaskBuilder<T> onSuccess(Consumer<T> successHandler) {
            this.successHandler = successHandler;
            return this;
        }

        public <E extends Throwable> TaskBuilder<T> onError(Class<E> type, Consumer<E> exceptionHandler) {
            this.errorHandlers.add(new ErrorHandler<E>(type, exceptionHandler));
            return this;
        }

        public TaskBuilder<T> andFinally(Runnable finallyHandler) {
            this.finallyHandler = finallyHandler;
            return this;
        }

        private Task<T> build() {
            return new TaskImpl<T>(this.callable, this.successHandler, this.errorHandlers, this.finallyHandler);
        }

        public Task<T> runOnce(ExecutorService executor) {
            Task<T> task = this.build();
            executor.submit((Runnable)task);
            return task;
        }

        public Task<T> scheduleOnce(ScheduledExecutorService scheduler, long delay, TimeUnit unit) {
            Task<T> task = this.build();
            scheduler.schedule((Runnable)task, delay, unit);
            return task;
        }

        public ScheduledService<T> schedulePeriodically(ExecutorService executor, Duration initialDelay, Duration period) {
            RestartingService service = new RestartingService(this::build);
            service.setExecutor(executor);
            service.setDelay(initialDelay);
            service.setPeriod(period);
            Platform.runLater(() -> service.start());
            return service;
        }
    }

    public static interface VoidCallable {
        public void call() throws Exception;
    }

    private static class RestartingService<T>
    extends ScheduledService<T> {
        private final Supplier<Task<T>> taskFactory;

        RestartingService(Supplier<Task<T>> taskFactory) {
            this.taskFactory = taskFactory;
            this.setOnFailed(event -> LOG.error("Failed to execute service", this.getException()));
        }

        protected Task<T> createTask() {
            return this.taskFactory.get();
        }
    }

    private static class TaskImpl<T>
    extends Task<T> {
        private final Callable<T> callable;
        private final Consumer<T> successHandler;
        private List<ErrorHandler<?>> errorHandlers;
        private final Runnable finallyHandler;

        TaskImpl(Callable<T> callable, Consumer<T> successHandler, List<ErrorHandler<?>> errorHandlers, Runnable finallyHandler) {
            this.callable = callable;
            this.successHandler = successHandler;
            this.errorHandlers = errorHandlers;
            this.finallyHandler = finallyHandler;
        }

        protected T call() throws Exception {
            return this.callable.call();
        }

        protected void succeeded() {
            try {
                this.successHandler.accept(this.getValue());
            }
            finally {
                this.finallyHandler.run();
            }
        }

        protected void failed() {
            try {
                Throwable exception = this.getException();
                this.errorHandlers.stream().filter(handler -> handler.handles(exception)).findFirst().ifPresentOrElse(exceptionHandler -> exceptionHandler.handle(exception), () -> LOG.error("Unhandled exception", exception));
            }
            finally {
                this.finallyHandler.run();
            }
        }
    }

    private static class ErrorHandler<ErrorType extends Throwable> {
        private final Class<ErrorType> type;
        private final Consumer<ErrorType> errorHandler;

        public ErrorHandler(Class<ErrorType> type, Consumer<ErrorType> errorHandler) {
            this.type = type;
            this.errorHandler = errorHandler;
        }

        public boolean handles(Throwable error) {
            return this.type.isInstance(error);
        }

        public void handle(Throwable error) throws ClassCastException {
            Throwable typedError = (Throwable)this.type.cast(error);
            this.errorHandler.accept(typedError);
        }
    }
}

