/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.addvaultwizard;

import dagger.Lazy;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultListManager;
import org.cryptomator.integrations.uiappearance.Theme;
import org.cryptomator.ui.addvaultwizard.AddVaultWizardScoped;
import org.cryptomator.ui.addvaultwizard.AddVaultWizardWindow;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.fxapp.FxApplicationStyle;
import org.cryptomator.ui.fxapp.FxApplicationWindows;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AddVaultWizardScoped
public class ChooseExistingVaultController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(ChooseExistingVaultController.class);
    private final Stage window;
    private final Lazy<Scene> successScene;
    private final FxApplicationWindows appWindows;
    private final ObjectProperty<Path> vaultPath;
    private final ObjectProperty<Vault> vault;
    private final VaultListManager vaultListManager;
    private final ResourceBundle resourceBundle;
    private final ObservableValue<Image> screenshot;

    @Inject
    ChooseExistingVaultController(@AddVaultWizardWindow Stage window, @FxmlScene(value=FxmlFile.ADDVAULT_SUCCESS) Lazy<Scene> successScene, FxApplicationWindows appWindows, ObjectProperty<Path> vaultPath, @AddVaultWizardWindow ObjectProperty<Vault> vault, VaultListManager vaultListManager, ResourceBundle resourceBundle, FxApplicationStyle applicationStyle) {
        this.window = window;
        this.successScene = successScene;
        this.appWindows = appWindows;
        this.vaultPath = vaultPath;
        this.vault = vault;
        this.vaultListManager = vaultListManager;
        this.resourceBundle = resourceBundle;
        this.screenshot = applicationStyle.appliedThemeProperty().map(this::selectScreenshot);
    }

    private Image selectScreenshot(Theme theme) {
        String imageResourcePath;
        if (SystemUtils.IS_OS_MAC) {
            imageResourcePath = switch (theme) {
                default -> throw new MatchException(null, null);
                case Theme.LIGHT -> "/img/select-masterkey-mac.png";
                case Theme.DARK -> "/img/select-masterkey-mac-dark.png";
            };
        } else {
            imageResourcePath = "/img/select-masterkey-win.png";
        }
        return new Image(Objects.requireNonNull(this.getClass().getResource(imageResourcePath)).toString());
    }

    @FXML
    public void chooseFileAndNext() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(this.resourceBundle.getString("addvaultwizard.existing.filePickerTitle"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(this.resourceBundle.getString("addvaultwizard.existing.filePickerMimeDesc"), new String[]{"*.cryptomator"}));
        File masterkeyFile = fileChooser.showOpenDialog((Window)this.window);
        if (masterkeyFile != null) {
            this.vaultPath.setValue((Object)masterkeyFile.toPath().toAbsolutePath().getParent());
            try {
                Vault newVault = this.vaultListManager.add((Path)this.vaultPath.get());
                this.vault.set((Object)newVault);
                this.window.setScene((Scene)this.successScene.get());
            }
            catch (IOException e) {
                LOG.error("Failed to open existing vault.", (Throwable)e);
                this.appWindows.showErrorWindow(e, this.window, this.window.getScene());
            }
        }
    }

    public ObservableValue<Image> screenshotProperty() {
        return this.screenshot;
    }

    public Image getScreenshot() {
        return (Image)this.screenshot.getValue();
    }
}

