/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.mount;

import com.google.common.collect.Sets;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.SystemUtils;

@Singleton
public final class WindowsDriveLetters {
    private static final Set<Path> A_TO_Z;

    @Inject
    public WindowsDriveLetters() {
    }

    public Set<Path> getAll() {
        return A_TO_Z;
    }

    public Set<Path> getOccupied() {
        if (!SystemUtils.IS_OS_WINDOWS) {
            return Set.of();
        }
        Iterable<Path> rootDirs = FileSystems.getDefault().getRootDirectories();
        return StreamSupport.stream(rootDirs.spliterator(), false).collect(Collectors.toUnmodifiableSet());
    }

    public Set<Path> getAvailable() {
        return Sets.difference(this.getAll(), this.getOccupied());
    }

    public Optional<Path> getFirstDesiredAvailable() {
        Set<Path> availableDriveLetters = this.getAvailable();
        Optional<Path> optString = availableDriveLetters.stream().filter(this::notAOrB).findFirst();
        return optString.or(() -> availableDriveLetters.stream().findFirst());
    }

    private boolean notAOrB(Path driveLetter) {
        return !Path.of("A:\\", new String[0]).equals(driveLetter) && !Path.of("B:\\", new String[0]).equals(driveLetter);
    }

    static {
        TreeSet sortedSet = new TreeSet();
        IntStream.rangeClosed(65, 90).mapToObj(i -> Path.of((char)i + ":\\", new String[0])).forEach(sortedSet::add);
        A_TO_Z = Collections.unmodifiableSet(sortedSet);
    }
}

