/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.locationpresets;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.cryptomator.common.locationpresets.LocationPreset;
import org.cryptomator.common.locationpresets.LocationPresetsProvider;
import org.cryptomator.integrations.common.CheckAvailability;
import org.cryptomator.integrations.common.OperatingSystem;

@OperatingSystem(value=OperatingSystem.Value.WINDOWS)
@CheckAvailability
public final class DropboxWindowsLocationPresetsProvider
implements LocationPresetsProvider {
    private static final Path LOCATION = LocationPresetsProvider.resolveLocation("~/Dropbox");

    @CheckAvailability
    public static boolean isPresent() {
        return Files.isDirectory(LOCATION, new LinkOption[0]);
    }

    @Override
    public Stream<LocationPreset> getLocations() {
        return Stream.of(new LocationPreset("Dropbox", LOCATION));
    }
}

