/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common;

import com.google.common.util.concurrent.Runnables;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ShutdownHook
extends Thread {
    private static final int PRIO_VERY_LAST = Integer.MIN_VALUE;
    public static final int PRIO_LAST = -2147483647;
    public static final int PRIO_DEFAULT = 0;
    public static final int PRIO_FIRST = Integer.MAX_VALUE;
    private static final Logger LOG = LoggerFactory.getLogger(ShutdownHook.class);
    private static final OrderedTask POISON = new OrderedTask(Integer.MIN_VALUE, Runnables.doNothing());
    private final Queue<OrderedTask> tasks = new PriorityBlockingQueue<OrderedTask>();

    @Inject
    ShutdownHook() {
        super(null, null, "ShutdownTasks", 0L);
        Runtime.getRuntime().addShutdownHook(this);
        LOG.debug("Registered shutdown hook.");
    }

    @Override
    public void run() {
        Runnable task;
        LOG.debug("Running graceful shutdown tasks...");
        this.tasks.add(POISON);
        while ((task = (Runnable)this.tasks.remove()) != POISON) {
            try {
                task.run();
            }
            catch (RuntimeException e) {
                LOG.error("Exception while shutting down.", (Throwable)e);
            }
        }
    }

    public void runOnShutdown(Runnable task) {
        this.runOnShutdown(0, task);
    }

    public void runOnShutdown(int priority, Runnable task) {
        this.tasks.add(new OrderedTask(priority, task));
    }

    private static class OrderedTask
    implements Comparable<OrderedTask>,
    Runnable {
        private final int priority;
        private final Runnable task;

        public OrderedTask(int priority, Runnable task) {
            this.priority = priority;
            this.task = task;
        }

        @Override
        public int compareTo(OrderedTask other) {
            if (this.priority > other.priority) {
                return -1;
            }
            if (this.priority < other.priority) {
                return 1;
            }
            return 0;
        }

        @Override
        public void run() {
            this.task.run();
        }
    }
}

