/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.VisibleForTesting;

public class ErrorCode {
    private static final int A_PRIME = 31;
    private static final int SEED = -559038737;
    public static final String DELIM = ":";
    private static final int LATEST_FRAME = 1;
    private static final int ALL_FRAMES = Integer.MAX_VALUE;
    private final Throwable throwable;
    private final Throwable rootCause;
    private final int rootCauseSpecificFrames;

    private ErrorCode(Throwable throwable, Throwable rootCause, int rootCauseSpecificFrames) {
        this.throwable = Objects.requireNonNull(throwable);
        this.rootCause = Objects.requireNonNull(rootCause);
        this.rootCauseSpecificFrames = rootCauseSpecificFrames;
    }

    public String methodCode() {
        return this.format(this.traceCode(this.rootCause, 1));
    }

    public String rootCauseCode() {
        return this.format(this.traceCode(this.rootCause, this.rootCauseSpecificFrames));
    }

    public String throwableCode() {
        return this.format(this.traceCode(this.throwable, Integer.MAX_VALUE));
    }

    public String toString() {
        return this.methodCode() + DELIM + this.rootCauseCode() + DELIM + this.throwableCode();
    }

    public static ErrorCode of(Throwable throwable) {
        List causalChain = Throwables.getCausalChain((Throwable)throwable);
        if (causalChain.size() > 1) {
            Throwable rootCause = (Throwable)causalChain.get(causalChain.size() - 1);
            Throwable parentOfRootCause = (Throwable)causalChain.get(causalChain.size() - 2);
            int rootSpecificFrames = ErrorCode.countTopmostFrames(rootCause.getStackTrace(), parentOfRootCause.getStackTrace());
            return new ErrorCode(throwable, rootCause, rootSpecificFrames);
        }
        return new ErrorCode(throwable, throwable, Integer.MAX_VALUE);
    }

    private String format(int value) {
        value = value & 0xFFFFF ^ value >>> 20;
        return Strings.padStart((String)Integer.toString(value, 32).toUpperCase(Locale.ROOT), (int)4, (char)'0');
    }

    private int traceCode(Throwable e, int frameCount) {
        int result = -559038737;
        if (e.getCause() != null) {
            result = this.traceCode(e.getCause(), frameCount);
        }
        result = result * 31 + e.getClass().getName().hashCode();
        StackTraceElement[] stack = e.getStackTrace();
        for (int i = 0; i < Math.min(stack.length, frameCount); ++i) {
            result = result * 31 + stack[i].getClassName().hashCode();
            result = result * 31 + stack[i].getMethodName().hashCode();
        }
        return result;
    }

    @VisibleForTesting
    static int countTopmostFrames(StackTraceElement[] allFrames, StackTraceElement[] bottomFrames) {
        if (allFrames.length < bottomFrames.length) {
            return allFrames.length;
        }
        return allFrames.length - ErrorCode.commonSuffixLength(allFrames, bottomFrames);
    }

    @VisibleForTesting
    static <T> int commonSuffixLength(T[] set, T[] subset) {
        Preconditions.checkArgument((set.length >= subset.length ? 1 : 0) != 0);
        Iterator iterator = ErrorCode.reverseStream(subset).iterator();
        return (int)ErrorCode.reverseStream(set).takeWhile(item -> iterator.hasNext() && iterator.next().equals(item)).count();
    }

    private static <T> Stream<T> reverseStream(T[] array) {
        return IntStream.rangeClosed(1, array.length).mapToObj(i -> array[array.length - i]);
    }
}

