/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common;

import dagger.Module;
import dagger.Provides;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Named;
import javax.inject.Singleton;
import org.cryptomator.common.CatchingExecutors;
import org.cryptomator.common.Constants;
import org.cryptomator.common.Environment;
import org.cryptomator.common.SemVerComparator;
import org.cryptomator.common.ShutdownHook;
import org.cryptomator.common.keychain.KeychainModule;
import org.cryptomator.common.mount.MountModule;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.common.settings.SettingsProvider;
import org.cryptomator.common.vaults.VaultComponent;
import org.cryptomator.common.vaults.VaultListModule;
import org.cryptomator.cryptolib.common.MasterkeyFileAccess;
import org.cryptomator.integrations.revealpath.RevealPathService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Module(subcomponents={VaultComponent.class}, includes={VaultListModule.class, KeychainModule.class, MountModule.class})
public abstract class CommonsModule {
    private static final Logger LOG = LoggerFactory.getLogger(CommonsModule.class);
    private static final int NUM_SCHEDULER_THREADS = 2;
    private static final int NUM_CORE_BG_THREADS = 6;
    private static final long BG_THREAD_KEEPALIVE_SECONDS = 60L;

    @Provides
    @Singleton
    static Environment provideEnvironment() {
        return Environment.getInstance();
    }

    @Provides
    @Singleton
    @Named(value="licensePublicKey")
    static String provideLicensePublicKey() {
        return "MIGbMBAGByqGSM49AgEGBSuBBAAjA4GGAAQB7NfnqiZbg2KTmoflmZ71PbXru7oWfmnV2yv3eDjlDfGruBrqz9TtXBZV/eYWt31xu1osIqaT12lKBvZ511aaAkIBeOEVgwcBIlJr6kUw7NKzeJt7r2rrsOyQoOG2nWc/Of/NBqA3mIZRHk5Aq1YupFdD26QEr0DzRyj4ixPIt38CQB8=";
    }

    @Provides
    @Singleton
    static SecureRandom provideCSPRNG() {
        try {
            return SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("A strong algorithm must exist in every Java platform.", e);
        }
    }

    @Provides
    @Singleton
    static MasterkeyFileAccess provideMasterkeyFileAccess(SecureRandom csprng) {
        return new MasterkeyFileAccess(Constants.PEPPER, csprng);
    }

    @Provides
    @Singleton
    @Named(value="SemVer")
    static Comparator<String> providesSemVerComparator() {
        return new SemVerComparator();
    }

    @Provides
    @Singleton
    static Optional<RevealPathService> provideRevealPathService() {
        return RevealPathService.get().findFirst();
    }

    @Provides
    @Singleton
    static Settings provideSettings(SettingsProvider settingsProvider) {
        return settingsProvider.get();
    }

    @Provides
    @Singleton
    static ScheduledExecutorService provideScheduledExecutorService(ShutdownHook shutdownHook) {
        AtomicInteger threadNumber = new AtomicInteger(1);
        CatchingExecutors.CatchingScheduledThreadPoolExecutor executorService = new CatchingExecutors.CatchingScheduledThreadPoolExecutor(2, r -> {
            String name = String.format("App Scheduled Executor %02d", threadNumber.getAndIncrement());
            Thread t = new Thread(r);
            t.setName(name);
            t.setUncaughtExceptionHandler(CommonsModule::handleUncaughtExceptionInBackgroundThread);
            t.setDaemon(true);
            LOG.debug("Starting {}", (Object)t.getName());
            return t;
        });
        shutdownHook.runOnShutdown(executorService::shutdown);
        return executorService;
    }

    @Provides
    @Singleton
    static ExecutorService provideExecutorService(ShutdownHook shutdownHook) {
        AtomicInteger threadNumber = new AtomicInteger(1);
        CatchingExecutors.CatchingThreadPoolExecutor executorService = new CatchingExecutors.CatchingThreadPoolExecutor(6, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), r -> {
            String name = String.format("App Background Thread %03d", threadNumber.getAndIncrement());
            Thread t = new Thread(r);
            t.setName(name);
            t.setUncaughtExceptionHandler(CommonsModule::handleUncaughtExceptionInBackgroundThread);
            t.setDaemon(true);
            LOG.debug("Starting {}", (Object)t.getName());
            return t;
        });
        shutdownHook.runOnShutdown(executorService::shutdown);
        return executorService;
    }

    private static void handleUncaughtExceptionInBackgroundThread(Thread thread, Throwable throwable) {
        LOG.error("Uncaught exception in " + thread.getName(), throwable);
    }
}

