/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common;

import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.concurrent.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CatchingExecutors {
    private static final Logger LOG = LoggerFactory.getLogger(CatchingExecutors.class);

    private CatchingExecutors() {
    }

    private static void afterExecuteInternal(Runnable runnable, Throwable throwable) {
        if (throwable != null) {
            CatchingExecutors.callHandler(Thread.currentThread(), throwable);
        } else if (runnable instanceof Task) {
            Task t = (Task)runnable;
            CatchingExecutors.afterExecuteTask(t);
        } else if (runnable instanceof Future) {
            Future f = (Future)((Object)runnable);
            CatchingExecutors.afterExecuteFuture(f);
        }
    }

    private static void callHandler(Thread thread, Throwable throwable) {
        Objects.requireNonNullElseGet(thread.getUncaughtExceptionHandler(), CatchingExecutors::fallbackHandler).uncaughtException(thread, throwable);
    }

    private static Thread.UncaughtExceptionHandler fallbackHandler() {
        return (thread, throwable) -> LOG.error("FALLBACK: Uncaught exception in " + thread.getName(), throwable);
    }

    private static void afterExecuteTask(Task<?> task) {
        Thread caller = Thread.currentThread();
        Platform.runLater(() -> {
            if (task.getOnFailed() == null) {
                CatchingExecutors.callHandler(caller, task.getException());
            }
        });
    }

    private static void afterExecuteFuture(Future<?> future) {
        if (future instanceof ScheduledFuture && !future.isDone()) {
            return;
        }
        try {
            future.get();
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException ee) {
            CatchingExecutors.callHandler(Thread.currentThread(), ee.getCause());
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    public static class CatchingThreadPoolExecutor
    extends ThreadPoolExecutor {
        public CatchingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            super.afterExecute(runnable, throwable);
            CatchingExecutors.afterExecuteInternal(runnable, throwable);
        }
    }

    public static class CatchingScheduledThreadPoolExecutor
    extends ScheduledThreadPoolExecutor {
        public CatchingScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
            super(corePoolSize, threadFactory);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            Runnable oneShot = () -> this.execute(command);
            return super.scheduleAtFixedRate(oneShot, initialDelay, period, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            Runnable oneShot = () -> this.execute(command);
            return super.scheduleWithFixedDelay(oneShot, initialDelay, delay, unit);
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            super.afterExecute(runnable, throwable);
            CatchingExecutors.afterExecuteInternal(runnable, throwable);
        }
    }
}

