/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.piccolo2d.PCamera;
import org.piccolo2d.PInputManager;
import org.piccolo2d.PNode;
import org.piccolo2d.activities.PActivity;
import org.piccolo2d.activities.PActivityScheduler;
import org.piccolo2d.util.PDebug;
import org.piccolo2d.util.PNodeFilter;

public class PRoot
extends PNode {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_INPUT_SOURCES = "inputSources";
    public static final int PROPERTY_CODE_INPUT_SOURCES = 16384;
    public static final String PROPERTY_INTERACTING_CHANGED = "INTERACTING_CHANGED_NOTIFICATION";
    public static final int PROPERTY_CODE_INTERACTING_CHANGED = 8192;
    protected transient boolean processingInputs;
    protected transient boolean processInputsScheduled;
    private transient int interacting;
    private transient PInputManager defaultInputManager;
    private final transient List inputSources = new ArrayList();
    private transient long globalTime = System.currentTimeMillis();
    private final PActivityScheduler activityScheduler = new PActivityScheduler(this);

    public boolean addActivity(PActivity activity) {
        this.getActivityScheduler().addActivity(activity);
        return true;
    }

    public PActivityScheduler getActivityScheduler() {
        return this.activityScheduler;
    }

    public void waitForActivities() {
        CameraWithCanvasFilter cameraWithCanvas = new CameraWithCanvasFilter();
        while (this.activityScheduler.getActivitiesReference().size() > 0) {
            this.processInputs();
            for (PCamera each : this.getAllNodes(cameraWithCanvas, null)) {
                each.getComponent().paintImmediately();
            }
        }
    }

    public PRoot getRoot() {
        return this;
    }

    public PInputManager getDefaultInputManager() {
        if (this.defaultInputManager == null) {
            this.defaultInputManager = new PInputManager();
            this.addInputSource(this.defaultInputManager);
        }
        return this.defaultInputManager;
    }

    public boolean getInteracting() {
        return this.interacting > 0;
    }

    public void setInteracting(boolean isInteracting) {
        boolean wasInteracting = this.getInteracting();
        this.interacting = isInteracting ? ++this.interacting : --this.interacting;
        if (!isInteracting && !this.getInteracting()) {
            for (int i = 0; i < this.getChildrenCount(); ++i) {
                PNode child = this.getChild(i);
                if (!(child instanceof PCamera)) continue;
                child.repaint();
            }
        }
        if (wasInteracting != isInteracting) {
            this.firePropertyChange(8192, PROPERTY_INTERACTING_CHANGED, wasInteracting, isInteracting);
        }
    }

    public void addInputSource(InputSource inputSource) {
        this.inputSources.add(inputSource);
        this.firePropertyChange(16384, PROPERTY_INPUT_SOURCES, null, this.inputSources);
    }

    public void removeInputSource(InputSource inputSource) {
        if (this.inputSources.remove(inputSource)) {
            this.firePropertyChange(16384, PROPERTY_INPUT_SOURCES, null, this.inputSources);
        }
    }

    public Timer createTimer(int delay, ActionListener listener) {
        return new Timer(delay, listener);
    }

    public long getGlobalTime() {
        return this.globalTime;
    }

    public void processInputs() {
        PDebug.startProcessingInput();
        this.processingInputs = true;
        this.globalTime = System.currentTimeMillis();
        if (this.inputSources.size() > 0) {
            for (InputSource each : this.inputSources) {
                each.processInput();
            }
        }
        this.activityScheduler.processActivities(this.globalTime);
        this.validateFullBounds();
        this.validateFullPaint();
        this.processingInputs = false;
        PDebug.endProcessingInput();
    }

    public void setFullBoundsInvalid(boolean fullLayoutInvalid) {
        super.setFullBoundsInvalid(fullLayoutInvalid);
        this.scheduleProcessInputsIfNeeded();
    }

    public void setChildBoundsInvalid(boolean childLayoutInvalid) {
        super.setChildBoundsInvalid(childLayoutInvalid);
        this.scheduleProcessInputsIfNeeded();
    }

    public void setPaintInvalid(boolean paintInvalid) {
        super.setPaintInvalid(paintInvalid);
        this.scheduleProcessInputsIfNeeded();
    }

    public void setChildPaintInvalid(boolean childPaintInvalid) {
        super.setChildPaintInvalid(childPaintInvalid);
        this.scheduleProcessInputsIfNeeded();
    }

    public void scheduleProcessInputsIfNeeded() {
        if (!SwingUtilities.isEventDispatchThread()) {
            return;
        }
        PDebug.scheduleProcessInputs();
        if (!this.processInputsScheduled && !this.processingInputs && (this.getFullBoundsInvalid() || this.getChildBoundsInvalid() || this.getPaintInvalid() || this.getChildPaintInvalid())) {
            this.processInputsScheduled = true;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PRoot.this.processInputs();
                    PRoot.this.processInputsScheduled = false;
                }
            });
        }
    }

    public static interface InputSource {
        public void processInput();
    }

    private static final class CameraWithCanvasFilter
    implements PNodeFilter {
        private CameraWithCanvasFilter() {
        }

        public boolean accept(PNode aNode) {
            return aNode instanceof PCamera && ((PCamera)aNode).getComponent() != null;
        }

        public boolean acceptChildrenOf(PNode aNode) {
            return true;
        }
    }
}

