/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.cert.crmf.bc;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.gradle.internal.impldep.org.bouncycastle.asn1.crmf.EncryptedValue;
import org.gradle.internal.impldep.org.bouncycastle.cert.crmf.CRMFException;
import org.gradle.internal.impldep.org.bouncycastle.cert.crmf.EncryptedValueBuilder;
import org.gradle.internal.impldep.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.gradle.internal.impldep.org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import org.gradle.internal.impldep.org.bouncycastle.operator.KeyWrapper;
import org.gradle.internal.impldep.org.bouncycastle.operator.OutputEncryptor;

public class BcEncryptedValueBuilder
extends EncryptedValueBuilder {
    public BcEncryptedValueBuilder(KeyWrapper keyWrapper, OutputEncryptor outputEncryptor) {
        super(keyWrapper, outputEncryptor);
    }

    public EncryptedValue build(X509Certificate x509Certificate) throws CertificateEncodingException, CRMFException {
        return this.build(new JcaX509CertificateHolder(x509Certificate));
    }

    public EncryptedValue build(AsymmetricKeyParameter asymmetricKeyParameter) throws CRMFException, IOException {
        return this.build(PrivateKeyInfoFactory.createPrivateKeyInfo(asymmetricKeyParameter));
    }
}

