/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.apache.bzip2;

import java.io.IOException;
import java.io.OutputStream;
import org.gradle.internal.impldep.org.bouncycastle.apache.bzip2.BZip2Constants;
import org.gradle.internal.impldep.org.bouncycastle.apache.bzip2.CRC;

public class CBZip2OutputStream
extends OutputStream
implements BZip2Constants {
    protected static final int SETMASK = 0x200000;
    protected static final int CLEARMASK = -2097153;
    protected static final int GREATER_ICOST = 15;
    protected static final int LESSER_ICOST = 0;
    protected static final int SMALL_THRESH = 20;
    protected static final int DEPTH_THRESH = 10;
    protected static final int QSORT_STACK_SIZE = 1000;
    private boolean finished;
    int last;
    int origPtr;
    int blockSize100k;
    boolean blockRandomised;
    int bytesOut;
    int bsBuff;
    int bsLive;
    CRC mCrc = new CRC();
    private boolean[] inUse = new boolean[256];
    private int nInUse;
    private char[] seqToUnseq = new char[256];
    private char[] unseqToSeq = new char[256];
    private char[] selector = new char[18002];
    private char[] selectorMtf = new char[18002];
    private char[] block = null;
    private int[] quadrant = null;
    private int[] zptr = null;
    private short[] szptr;
    private int[] ftab = null;
    private int nMTF;
    private int[] mtfFreq = new int[258];
    private int workFactor;
    private int workDone;
    private int workLimit;
    private boolean firstAttempt;
    private int nBlocksRandomised;
    private int currentChar = -1;
    private int runLength = 0;
    boolean closed = false;
    private int blockCRC;
    private int combinedCRC;
    private int allowableBlockSize;
    private OutputStream bsStream;
    private int[] incs = new int[]{1, 4, 13, 40, 121, 364, 1093, 3280, 9841, 29524, 88573, 265720, 797161, 2391484};

    private static void panic() {
        System.out.println("panic");
    }

    private void makeMaps() {
        this.nInUse = 0;
        for (int i = 0; i < 256; ++i) {
            if (!this.inUse[i]) continue;
            this.seqToUnseq[this.nInUse] = (char)i;
            this.unseqToSeq[i] = (char)this.nInUse;
            ++this.nInUse;
        }
    }

    protected static void hbMakeCodeLengths(char[] cArray, int[] nArray, int n, int n2) {
        int n3;
        int[] nArray2 = new int[260];
        int[] nArray3 = new int[516];
        int[] nArray4 = new int[516];
        for (n3 = 0; n3 < n; ++n3) {
            nArray3[n3 + 1] = (nArray[n3] == 0 ? 1 : nArray[n3]) << 8;
        }
        block1: while (true) {
            int n4;
            int n5;
            int n6;
            int n7 = n;
            int n8 = 0;
            nArray2[0] = 0;
            nArray3[0] = 0;
            nArray4[0] = -2;
            for (n3 = 1; n3 <= n; ++n3) {
                nArray4[n3] = -1;
                nArray2[++n8] = n3;
                n6 = n8;
                n5 = nArray2[n6];
                while (nArray3[n5] < nArray3[nArray2[n6 >> 1]]) {
                    nArray2[n6] = nArray2[n6 >> 1];
                    n6 >>= 1;
                }
                nArray2[n6] = n5;
            }
            if (n8 >= 260) {
                CBZip2OutputStream.panic();
            }
            while (n8 > 1) {
                int n9 = nArray2[1];
                nArray2[1] = nArray2[n8];
                --n8;
                n6 = 0;
                n5 = 0;
                int n10 = 0;
                n6 = 1;
                n10 = nArray2[n6];
                while ((n5 = n6 << 1) <= n8) {
                    if (n5 < n8 && nArray3[nArray2[n5 + 1]] < nArray3[nArray2[n5]]) {
                        ++n5;
                    }
                    if (nArray3[n10] < nArray3[nArray2[n5]]) break;
                    nArray2[n6] = nArray2[n5];
                    n6 = n5;
                }
                nArray2[n6] = n10;
                int n11 = nArray2[1];
                nArray2[1] = nArray2[n8];
                --n8;
                n6 = 0;
                n5 = 0;
                n10 = 0;
                n6 = 1;
                n10 = nArray2[n6];
                while ((n5 = n6 << 1) <= n8) {
                    if (n5 < n8 && nArray3[nArray2[n5 + 1]] < nArray3[nArray2[n5]]) {
                        ++n5;
                    }
                    if (nArray3[n10] < nArray3[nArray2[n5]]) break;
                    nArray2[n6] = nArray2[n5];
                    n6 = n5;
                }
                nArray2[n6] = n10;
                nArray4[n9] = nArray4[n11] = ++n7;
                nArray3[n7] = (nArray3[n9] & 0xFFFFFF00) + (nArray3[n11] & 0xFFFFFF00) | 1 + ((nArray3[n9] & 0xFF) > (nArray3[n11] & 0xFF) ? nArray3[n9] & 0xFF : nArray3[n11] & 0xFF);
                nArray4[n7] = -1;
                nArray2[++n8] = n7;
                n6 = 0;
                n5 = 0;
                n6 = n8;
                n5 = nArray2[n6];
                while (nArray3[n5] < nArray3[nArray2[n6 >> 1]]) {
                    nArray2[n6] = nArray2[n6 >> 1];
                    n6 >>= 1;
                }
                nArray2[n6] = n5;
            }
            if (n7 >= 516) {
                CBZip2OutputStream.panic();
            }
            boolean bl = false;
            for (n3 = 1; n3 <= n; ++n3) {
                n4 = 0;
                int n12 = n3;
                while (nArray4[n12] >= 0) {
                    n12 = nArray4[n12];
                    ++n4;
                }
                cArray[n3 - 1] = (char)n4;
                if (n4 <= n2) continue;
                bl = true;
            }
            if (!bl) break;
            n3 = 1;
            while (true) {
                if (n3 >= n) continue block1;
                n4 = nArray3[n3] >> 8;
                n4 = 1 + n4 / 2;
                nArray3[n3] = n4 << 8;
                ++n3;
            }
            break;
        }
    }

    public CBZip2OutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 9);
    }

    public CBZip2OutputStream(OutputStream outputStream, int n) throws IOException {
        outputStream.write(66);
        outputStream.write(90);
        this.bsSetStream(outputStream);
        this.workFactor = 50;
        if (n > 9) {
            n = 9;
        }
        if (n < 1) {
            n = 1;
        }
        this.blockSize100k = n;
        this.allocateCompressStructures();
        this.initialize();
        this.initBlock();
    }

    public void write(int n) throws IOException {
        int n2 = (256 + n) % 256;
        if (this.currentChar != -1) {
            if (this.currentChar == n2) {
                ++this.runLength;
                if (this.runLength > 254) {
                    this.writeRun();
                    this.currentChar = -1;
                    this.runLength = 0;
                }
            } else {
                this.writeRun();
                this.runLength = 1;
                this.currentChar = n2;
            }
        } else {
            this.currentChar = n2;
            ++this.runLength;
        }
    }

    private void writeRun() throws IOException {
        if (this.last < this.allowableBlockSize) {
            this.inUse[this.currentChar] = true;
            for (int i = 0; i < this.runLength; ++i) {
                this.mCrc.updateCRC((char)this.currentChar);
            }
            switch (this.runLength) {
                case 1: {
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    break;
                }
                case 2: {
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    break;
                }
                case 3: {
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    break;
                }
                default: {
                    this.inUse[this.runLength - 4] = true;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)(this.runLength - 4);
                    break;
                }
            }
        } else {
            this.endBlock();
            this.initBlock();
            this.writeRun();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.finish();
        this.closed = true;
        super.close();
        this.bsStream.close();
    }

    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        if (this.runLength > 0) {
            this.writeRun();
        }
        this.currentChar = -1;
        this.endBlock();
        this.endCompression();
        this.finished = true;
        this.flush();
    }

    public void flush() throws IOException {
        super.flush();
        this.bsStream.flush();
    }

    private void initialize() throws IOException {
        this.bytesOut = 0;
        this.nBlocksRandomised = 0;
        this.bsPutUChar(104);
        this.bsPutUChar(48 + this.blockSize100k);
        this.combinedCRC = 0;
    }

    private void initBlock() {
        this.mCrc.initialiseCRC();
        this.last = -1;
        for (int i = 0; i < 256; ++i) {
            this.inUse[i] = false;
        }
        this.allowableBlockSize = 100000 * this.blockSize100k - 20;
    }

    private void endBlock() throws IOException {
        this.blockCRC = this.mCrc.getFinalCRC();
        this.combinedCRC = this.combinedCRC << 1 | this.combinedCRC >>> 31;
        this.combinedCRC ^= this.blockCRC;
        this.doReversibleTransformation();
        this.bsPutUChar(49);
        this.bsPutUChar(65);
        this.bsPutUChar(89);
        this.bsPutUChar(38);
        this.bsPutUChar(83);
        this.bsPutUChar(89);
        this.bsPutint(this.blockCRC);
        if (this.blockRandomised) {
            this.bsW(1, 1);
            ++this.nBlocksRandomised;
        } else {
            this.bsW(1, 0);
        }
        this.moveToFrontCodeAndSend();
    }

    private void endCompression() throws IOException {
        this.bsPutUChar(23);
        this.bsPutUChar(114);
        this.bsPutUChar(69);
        this.bsPutUChar(56);
        this.bsPutUChar(80);
        this.bsPutUChar(144);
        this.bsPutint(this.combinedCRC);
        this.bsFinishedWithStream();
    }

    private void hbAssignCodes(int[] nArray, char[] cArray, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = n; i <= n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                if (cArray[j] != i) continue;
                nArray[j] = n4++;
            }
            n4 <<= 1;
        }
    }

    private void bsSetStream(OutputStream outputStream) {
        this.bsStream = outputStream;
        this.bsLive = 0;
        this.bsBuff = 0;
        this.bytesOut = 0;
    }

    private void bsFinishedWithStream() throws IOException {
        while (this.bsLive > 0) {
            int n = this.bsBuff >> 24;
            this.bsStream.write(n);
            this.bsBuff <<= 8;
            this.bsLive -= 8;
            ++this.bytesOut;
        }
    }

    private void bsW(int n, int n2) throws IOException {
        while (this.bsLive >= 8) {
            int n3 = this.bsBuff >> 24;
            this.bsStream.write(n3);
            this.bsBuff <<= 8;
            this.bsLive -= 8;
            ++this.bytesOut;
        }
        this.bsBuff |= n2 << 32 - this.bsLive - n;
        this.bsLive += n;
    }

    private void bsPutUChar(int n) throws IOException {
        this.bsW(8, n);
    }

    private void bsPutint(int n) throws IOException {
        this.bsW(8, n >> 24 & 0xFF);
        this.bsW(8, n >> 16 & 0xFF);
        this.bsW(8, n >> 8 & 0xFF);
        this.bsW(8, n & 0xFF);
    }

    private void bsPutIntVS(int n, int n2) throws IOException {
        this.bsW(n, n2);
    }

    private void sendMTFValues() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        char[][] cArray = new char[6][258];
        int n10 = 0;
        int n11 = this.nInUse + 2;
        for (n9 = 0; n9 < 6; ++n9) {
            for (n8 = 0; n8 < n11; ++n8) {
                cArray[n9][n8] = 15;
            }
        }
        if (this.nMTF <= 0) {
            CBZip2OutputStream.panic();
        }
        int n12 = this.nMTF < 200 ? 2 : (this.nMTF < 600 ? 3 : (this.nMTF < 1200 ? 4 : (this.nMTF < 2400 ? 5 : 6)));
        int n13 = n12;
        int n14 = this.nMTF;
        int n15 = 0;
        while (n13 > 0) {
            int n16 = n14 / n13;
            n7 = n15 - 1;
            for (n6 = 0; n6 < n16 && n7 < n11 - 1; n6 += this.mtfFreq[++n7]) {
            }
            if (n7 > n15 && n13 != n12 && n13 != 1 && (n12 - n13) % 2 == 1) {
                n6 -= this.mtfFreq[n7];
                --n7;
            }
            for (n8 = 0; n8 < n11; ++n8) {
                cArray[n13 - 1][n8] = n8 >= n15 && n8 <= n7 ? 0 : 15;
            }
            --n13;
            n15 = n7 + 1;
            n14 -= n6;
        }
        int[][] nArray = new int[6][258];
        int[] nArray2 = new int[6];
        short[] sArray = new short[6];
        for (int i = 0; i < 4; ++i) {
            for (n9 = 0; n9 < n12; ++n9) {
                nArray2[n9] = 0;
            }
            for (n9 = 0; n9 < n12; ++n9) {
                for (n8 = 0; n8 < n11; ++n8) {
                    nArray[n9][n8] = 0;
                }
            }
            n10 = 0;
            int n17 = 0;
            n15 = 0;
            while (n15 < this.nMTF) {
                n7 = n15 + 50 - 1;
                if (n7 >= this.nMTF) {
                    n7 = this.nMTF - 1;
                }
                for (n9 = 0; n9 < n12; ++n9) {
                    sArray[n9] = 0;
                }
                if (n12 == 6) {
                    int n18 = 0;
                    int n19 = 0;
                    n5 = 0;
                    n4 = 0;
                    n3 = 0;
                    n6 = 0;
                    for (n2 = n15; n2 <= n7; ++n2) {
                        short s = this.szptr[n2];
                        n6 = (short)(n6 + cArray[0][s]);
                        n3 = (short)(n3 + cArray[1][s]);
                        n4 = (short)(n4 + cArray[2][s]);
                        n5 = (short)(n5 + cArray[3][s]);
                        n19 = (short)(n19 + cArray[4][s]);
                        n18 = (short)(n18 + cArray[5][s]);
                    }
                    sArray[0] = n6;
                    sArray[1] = n3;
                    sArray[2] = n4;
                    sArray[3] = n5;
                    sArray[4] = n19;
                    sArray[5] = n18;
                } else {
                    for (n2 = n15; n2 <= n7; ++n2) {
                        n6 = this.szptr[n2];
                        for (n9 = 0; n9 < n12; ++n9) {
                            int n16 = n9;
                            sArray[n16] = (short)(sArray[n16] + cArray[n9][n6]);
                        }
                    }
                }
                short s = 999999999;
                int n21 = -1;
                for (n9 = 0; n9 < n12; ++n9) {
                    if (sArray[n9] >= s) continue;
                    s = sArray[n9];
                    n21 = n9;
                }
                n17 += s;
                int n18 = n21;
                nArray2[n18] = nArray2[n18] + 1;
                this.selector[n10] = (char)n21;
                ++n10;
                for (n2 = n15; n2 <= n7; ++n2) {
                    int[] nArray3 = nArray[n21];
                    short s2 = this.szptr[n2];
                    nArray3[s2] = nArray3[s2] + 1;
                }
                n15 = n7 + 1;
            }
            for (n9 = 0; n9 < n12; ++n9) {
                CBZip2OutputStream.hbMakeCodeLengths(cArray[n9], nArray[n9], n11, 20);
            }
        }
        nArray = null;
        nArray2 = null;
        sArray = null;
        if (n12 >= 8) {
            CBZip2OutputStream.panic();
        }
        if (n10 >= 32768 || n10 > 18002) {
            CBZip2OutputStream.panic();
        }
        Object object = new char[6];
        for (n2 = 0; n2 < n12; ++n2) {
            object[n2] = (char)n2;
        }
        for (n2 = 0; n2 < n10; ++n2) {
            n3 = this.selector[n2];
            n = 0;
            n5 = object[n];
            while (n3 != n5) {
                n4 = n5;
                n5 = object[++n];
                object[n] = n4;
            }
            object[0] = n5;
            this.selectorMtf[n2] = (char)n;
        }
        object = new int[6][258];
        for (n9 = 0; n9 < n12; ++n9) {
            char c = ' ';
            char c2 = '\u0000';
            for (n2 = 0; n2 < n11; ++n2) {
                if (cArray[n9][n2] > c2) {
                    c2 = cArray[n9][n2];
                }
                if (cArray[n9][n2] >= c) continue;
                c = cArray[n9][n2];
            }
            if (c2 > '\u0014') {
                CBZip2OutputStream.panic();
            }
            if (c < '\u0001') {
                CBZip2OutputStream.panic();
            }
            this.hbAssignCodes((int[])object[n9], cArray[n9], c, c2, n11);
        }
        boolean[] blArray = new boolean[16];
        for (n2 = 0; n2 < 16; ++n2) {
            blArray[n2] = false;
            for (n = 0; n < 16; ++n) {
                if (!this.inUse[n2 * 16 + n]) continue;
                blArray[n2] = true;
            }
        }
        for (n2 = 0; n2 < 16; ++n2) {
            if (blArray[n2]) {
                this.bsW(1, 1);
                continue;
            }
            this.bsW(1, 0);
        }
        for (n2 = 0; n2 < 16; ++n2) {
            if (!blArray[n2]) continue;
            for (n = 0; n < 16; ++n) {
                if (this.inUse[n2 * 16 + n]) {
                    this.bsW(1, 1);
                    continue;
                }
                this.bsW(1, 0);
            }
        }
        this.bsW(3, n12);
        this.bsW(15, n10);
        for (n2 = 0; n2 < n10; ++n2) {
            for (n = 0; n < this.selectorMtf[n2]; ++n) {
                this.bsW(1, 1);
            }
            this.bsW(1, 0);
        }
        for (n9 = 0; n9 < n12; ++n9) {
            int n23 = cArray[n9][0];
            this.bsW(5, n23);
            for (n2 = 0; n2 < n11; ++n2) {
                while (n23 < cArray[n9][n2]) {
                    this.bsW(2, 2);
                    ++n23;
                }
                while (n23 > cArray[n9][n2]) {
                    this.bsW(2, 3);
                    --n23;
                }
                this.bsW(1, 0);
            }
        }
        int n24 = 0;
        n15 = 0;
        while (n15 < this.nMTF) {
            n7 = n15 + 50 - 1;
            if (n7 >= this.nMTF) {
                n7 = this.nMTF - 1;
            }
            for (n2 = n15; n2 <= n7; ++n2) {
                this.bsW(cArray[this.selector[n24]][this.szptr[n2]], (int)object[this.selector[n24]][this.szptr[n2]]);
            }
            n15 = n7 + 1;
            ++n24;
        }
        if (n24 != n10) {
            CBZip2OutputStream.panic();
        }
    }

    private void moveToFrontCodeAndSend() throws IOException {
        this.bsPutIntVS(24, this.origPtr);
        this.generateMTFValues();
        this.sendMTFValues();
    }

    private void simpleSort(int n, int n2, int n3) {
        int n4 = n2 - n + 1;
        if (n4 < 2) {
            return;
        }
        int n5 = 0;
        while (this.incs[n5] < n4) {
            ++n5;
        }
        --n5;
        while (n5 >= 0) {
            int n6 = this.incs[n5];
            for (int i = n + n6; i <= n2; ++i) {
                int n7 = this.zptr[i];
                int n8 = i;
                while (this.fullGtU(this.zptr[n8 - n6] + n3, n7 + n3)) {
                    this.zptr[n8] = this.zptr[n8 - n6];
                    if ((n8 -= n6) > n + n6 - 1) continue;
                }
                this.zptr[n8] = n7;
                if (++i > n2) break;
                n7 = this.zptr[i];
                n8 = i;
                while (this.fullGtU(this.zptr[n8 - n6] + n3, n7 + n3)) {
                    this.zptr[n8] = this.zptr[n8 - n6];
                    if ((n8 -= n6) > n + n6 - 1) continue;
                }
                this.zptr[n8] = n7;
                if (++i > n2) break;
                n7 = this.zptr[i];
                n8 = i;
                while (this.fullGtU(this.zptr[n8 - n6] + n3, n7 + n3)) {
                    this.zptr[n8] = this.zptr[n8 - n6];
                    if ((n8 -= n6) > n + n6 - 1) continue;
                }
                this.zptr[n8] = n7;
                if (this.workDone <= this.workLimit || !this.firstAttempt) continue;
                return;
            }
            --n5;
        }
    }

    private void vswap(int n, int n2, int n3) {
        int n4 = 0;
        while (n3 > 0) {
            n4 = this.zptr[n];
            this.zptr[n] = this.zptr[n2];
            this.zptr[n2] = n4;
            ++n;
            ++n2;
            --n3;
        }
    }

    private char med3(char c, char c2, char c3) {
        char c4;
        if (c > c2) {
            c4 = c;
            c = c2;
            c2 = c4;
        }
        if (c2 > c3) {
            c4 = c2;
            c2 = c3;
            c3 = c4;
        }
        if (c > c2) {
            c2 = c;
        }
        return c2;
    }

    private void qSort3(int n, int n2, int n3) {
        int n4;
        StackElem[] stackElemArray = new StackElem[1000];
        for (n4 = 0; n4 < 1000; ++n4) {
            stackElemArray[n4] = new StackElem();
        }
        int n5 = 0;
        stackElemArray[n5].ll = n;
        stackElemArray[n5].hh = n2;
        stackElemArray[n5].dd = n3;
        ++n5;
        while (n5 > 0) {
            int n6;
            int n7;
            int n8;
            if (n5 >= 1000) {
                CBZip2OutputStream.panic();
            }
            int n9 = stackElemArray[--n5].ll;
            int n10 = stackElemArray[n5].hh;
            int n11 = stackElemArray[n5].dd;
            if (n10 - n9 < 20 || n11 > 10) {
                this.simpleSort(n9, n10, n11);
                if (this.workDone <= this.workLimit || !this.firstAttempt) continue;
                return;
            }
            char c = this.med3(this.block[this.zptr[n9] + n11 + 1], this.block[this.zptr[n10] + n11 + 1], this.block[this.zptr[n9 + n10 >> 1] + n11 + 1]);
            int n12 = n8 = n9;
            int n13 = n7 = n10;
            while (true) {
                if (n12 <= n13) {
                    n6 = this.block[this.zptr[n12] + n11 + 1] - c;
                    if (n6 == 0) {
                        n4 = 0;
                        n4 = this.zptr[n12];
                        this.zptr[n12] = this.zptr[n8];
                        this.zptr[n8] = n4;
                        ++n8;
                        ++n12;
                        continue;
                    }
                    if (n6 <= 0) {
                        ++n12;
                        continue;
                    }
                }
                while (n12 <= n13) {
                    n6 = this.block[this.zptr[n13] + n11 + 1] - c;
                    if (n6 == 0) {
                        n4 = 0;
                        n4 = this.zptr[n13];
                        this.zptr[n13] = this.zptr[n7];
                        this.zptr[n7] = n4;
                        --n7;
                        --n13;
                        continue;
                    }
                    if (n6 < 0) break;
                    --n13;
                }
                if (n12 > n13) break;
                n4 = 0;
                n4 = this.zptr[n12];
                this.zptr[n12] = this.zptr[n13];
                this.zptr[n13] = n4;
                ++n12;
                --n13;
            }
            if (n7 < n8) {
                stackElemArray[n5].ll = n9;
                stackElemArray[n5].hh = n10;
                stackElemArray[n5].dd = n11 + 1;
                ++n5;
                continue;
            }
            n6 = n8 - n9 < n12 - n8 ? n8 - n9 : n12 - n8;
            this.vswap(n9, n12 - n6, n6);
            int n14 = n10 - n7 < n7 - n13 ? n10 - n7 : n7 - n13;
            this.vswap(n12, n10 - n14 + 1, n14);
            n6 = n9 + n12 - n8 - 1;
            n14 = n10 - (n7 - n13) + 1;
            stackElemArray[n5].ll = n9;
            stackElemArray[n5].hh = n6;
            stackElemArray[n5].dd = n11;
            stackElemArray[++n5].ll = n6 + 1;
            stackElemArray[n5].hh = n14 - 1;
            stackElemArray[n5].dd = n11 + 1;
            stackElemArray[++n5].ll = n14;
            stackElemArray[n5].hh = n10;
            stackElemArray[n5].dd = n11;
            ++n5;
        }
    }

    private void mainSort() {
        int n;
        int[] nArray = new int[256];
        int[] nArray2 = new int[256];
        boolean[] blArray = new boolean[256];
        for (n = 0; n < 20; ++n) {
            this.block[this.last + n + 2] = this.block[n % (this.last + 1) + 1];
        }
        for (n = 0; n <= this.last + 20; ++n) {
            this.quadrant[n] = 0;
        }
        this.block[0] = this.block[this.last + 1];
        if (this.last < 4000) {
            for (n = 0; n <= this.last; ++n) {
                this.zptr[n] = n;
            }
            this.firstAttempt = false;
            this.workLimit = 0;
            this.workDone = 0;
            this.simpleSort(0, this.last, 0);
        } else {
            int n2;
            int n3;
            char c;
            int n4 = 0;
            for (n = 0; n <= 255; ++n) {
                blArray[n] = false;
            }
            for (n = 0; n <= 65536; ++n) {
                this.ftab[n] = 0;
            }
            char c2 = this.block[0];
            for (n = 0; n <= this.last; ++n) {
                c = this.block[n + 1];
                int n5 = (c2 << 8) + c;
                this.ftab[n5] = this.ftab[n5] + 1;
                c2 = c;
            }
            for (n = 1; n <= 65536; ++n) {
                int n6 = n;
                this.ftab[n6] = this.ftab[n6] + this.ftab[n - 1];
            }
            c2 = this.block[1];
            n = 0;
            while (n < this.last) {
                c = this.block[n + 2];
                n3 = (c2 << 8) + c;
                c2 = c;
                int n7 = n3;
                this.ftab[n7] = this.ftab[n7] - 1;
                this.zptr[this.ftab[n3]] = n++;
            }
            int n8 = n3 = (this.block[this.last + 1] << 8) + this.block[1];
            this.ftab[n8] = this.ftab[n8] - 1;
            this.zptr[this.ftab[n3]] = this.last;
            for (n = 0; n <= 255; ++n) {
                nArray[n] = n;
            }
            int n9 = 1;
            while ((n9 = 3 * n9 + 1) <= 256) {
            }
            do {
                for (n = n9 /= 3; n <= 255; ++n) {
                    n2 = nArray[n];
                    n3 = n;
                    while (this.ftab[nArray[n3 - n9] + 1 << 8] - this.ftab[nArray[n3 - n9] << 8] > this.ftab[n2 + 1 << 8] - this.ftab[n2 << 8]) {
                        nArray[n3] = nArray[n3 - n9];
                        if ((n3 -= n9) > n9 - 1) continue;
                    }
                    nArray[n3] = n2;
                }
            } while (n9 != 1);
            for (n = 0; n <= 255; ++n) {
                int n10 = nArray[n];
                for (n3 = 0; n3 <= 255; ++n3) {
                    int n11 = (n10 << 8) + n3;
                    if ((this.ftab[n11] & 0x200000) == 0x200000) continue;
                    n9 = (this.ftab[n11 + 1] & 0xFFDFFFFF) - 1;
                    n2 = this.ftab[n11] & 0xFFDFFFFF;
                    if (n9 > n2) {
                        this.qSort3(n2, n9, 2);
                        n4 += n9 - n2 + 1;
                        if (this.workDone > this.workLimit && this.firstAttempt) {
                            return;
                        }
                    }
                    int n12 = n11;
                    this.ftab[n12] = this.ftab[n12] | 0x200000;
                }
                blArray[n10] = true;
                if (n < 255) {
                    n2 = this.ftab[n10 << 8] & 0xFFDFFFFF;
                    n9 = (this.ftab[n10 + 1 << 8] & 0xFFDFFFFF) - n2;
                    int n13 = 0;
                    while (n9 >> n13 > 65534) {
                        ++n13;
                    }
                    for (n3 = 0; n3 < n9; ++n3) {
                        int n14;
                        int n15 = this.zptr[n2 + n3];
                        this.quadrant[n15] = n14 = n3 >> n13;
                        if (n15 >= 20) continue;
                        this.quadrant[n15 + this.last + 1] = n14;
                    }
                    if (n9 - 1 >> n13 > 65535) {
                        CBZip2OutputStream.panic();
                    }
                }
                for (n3 = 0; n3 <= 255; ++n3) {
                    nArray2[n3] = this.ftab[(n3 << 8) + n10] & 0xFFDFFFFF;
                }
                for (n3 = this.ftab[n10 << 8] & 0xFFDFFFFF; n3 < (this.ftab[n10 + 1 << 8] & 0xFFDFFFFF); ++n3) {
                    c2 = this.block[this.zptr[n3]];
                    if (blArray[c2]) continue;
                    this.zptr[nArray2[c2]] = this.zptr[n3] == 0 ? this.last : this.zptr[n3] - 1;
                    char c3 = c2;
                    nArray2[c3] = nArray2[c3] + 1;
                }
                for (n3 = 0; n3 <= 255; ++n3) {
                    int n16 = (n3 << 8) + n10;
                    this.ftab[n16] = this.ftab[n16] | 0x200000;
                }
            }
        }
    }

    private void randomiseBlock() {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < 256; ++n) {
            this.inUse[n] = false;
        }
        for (n = 0; n <= this.last; ++n) {
            if (n2 == 0) {
                n2 = (char)rNums[n3];
                if (++n3 == 512) {
                    n3 = 0;
                }
            }
            int n4 = n + 1;
            this.block[n4] = (char)(this.block[n4] ^ (--n2 == 1 ? (char)'\u0001' : '\u0000'));
            int n5 = n + 1;
            this.block[n5] = (char)(this.block[n5] & 0xFF);
            this.inUse[this.block[n + 1]] = true;
        }
    }

    private void doReversibleTransformation() {
        this.workLimit = this.workFactor * this.last;
        this.workDone = 0;
        this.blockRandomised = false;
        this.firstAttempt = true;
        this.mainSort();
        if (this.workDone > this.workLimit && this.firstAttempt) {
            this.randomiseBlock();
            this.workDone = 0;
            this.workLimit = 0;
            this.blockRandomised = true;
            this.firstAttempt = false;
            this.mainSort();
        }
        this.origPtr = -1;
        for (int i = 0; i <= this.last; ++i) {
            if (this.zptr[i] != 0) continue;
            this.origPtr = i;
            break;
        }
        if (this.origPtr == -1) {
            CBZip2OutputStream.panic();
        }
    }

    private boolean fullGtU(int n, int n2) {
        char c = this.block[n + 1];
        char c2 = this.block[n2 + 1];
        if (c != c2) {
            return c > c2;
        }
        if ((c = this.block[++n + 1]) != (c2 = this.block[++n2 + 1])) {
            return c > c2;
        }
        if ((c = this.block[++n + 1]) != (c2 = this.block[++n2 + 1])) {
            return c > c2;
        }
        if ((c = this.block[++n + 1]) != (c2 = this.block[++n2 + 1])) {
            return c > c2;
        }
        if ((c = this.block[++n + 1]) != (c2 = this.block[++n2 + 1])) {
            return c > c2;
        }
        if ((c = this.block[++n + 1]) != (c2 = this.block[++n2 + 1])) {
            return c > c2;
        }
        ++n;
        ++n2;
        int n3 = this.last + 1;
        do {
            if ((c = this.block[n + 1]) != (c2 = this.block[n2 + 1])) {
                return c > c2;
            }
            int n4 = this.quadrant[n];
            int n5 = this.quadrant[n2];
            if (n4 != n5) {
                return n4 > n5;
            }
            if ((c = this.block[++n + 1]) != (c2 = this.block[++n2 + 1])) {
                return c > c2;
            }
            n4 = this.quadrant[n];
            n5 = this.quadrant[n2];
            if (n4 != n5) {
                return n4 > n5;
            }
            if ((c = this.block[++n + 1]) != (c2 = this.block[++n2 + 1])) {
                return c > c2;
            }
            n4 = this.quadrant[n];
            n5 = this.quadrant[n2];
            if (n4 != n5) {
                return n4 > n5;
            }
            if ((c = this.block[++n + 1]) != (c2 = this.block[++n2 + 1])) {
                return c > c2;
            }
            n4 = this.quadrant[n];
            n5 = this.quadrant[n2];
            if (n4 != n5) {
                return n4 > n5;
            }
            ++n2;
            if (++n > this.last) {
                n -= this.last;
                --n;
            }
            if (n2 > this.last) {
                n2 -= this.last;
                --n2;
            }
            ++this.workDone;
        } while ((n3 -= 4) >= 0);
        return false;
    }

    private void allocateCompressStructures() {
        int n = 100000 * this.blockSize100k;
        this.block = new char[n + 1 + 20];
        this.quadrant = new int[n + 20];
        this.zptr = new int[n];
        this.ftab = new int[65537];
        if (this.block == null || this.quadrant == null || this.zptr == null || this.ftab == null) {
            // empty if block
        }
        this.szptr = new short[2 * n];
    }

    private void generateMTFValues() {
        int n;
        char[] cArray = new char[256];
        this.makeMaps();
        int n2 = this.nInUse + 1;
        for (n = 0; n <= n2; ++n) {
            this.mtfFreq[n] = 0;
        }
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < this.nInUse; ++n) {
            cArray[n] = (char)n;
        }
        for (n = 0; n <= this.last; ++n) {
            char c = this.unseqToSeq[this.block[this.zptr[n]]];
            int n5 = 0;
            char c2 = cArray[n5];
            while (c != c2) {
                char c3 = c2;
                c2 = cArray[++n5];
                cArray[n5] = c3;
            }
            cArray[0] = c2;
            if (n5 == 0) {
                ++n4;
                continue;
            }
            if (n4 > 0) {
                --n4;
                while (true) {
                    switch (n4 % 2) {
                        case 0: {
                            this.szptr[n3] = 0;
                            ++n3;
                            this.mtfFreq[0] = this.mtfFreq[0] + 1;
                            break;
                        }
                        case 1: {
                            this.szptr[n3] = 1;
                            ++n3;
                            this.mtfFreq[1] = this.mtfFreq[1] + 1;
                        }
                    }
                    if (n4 < 2) break;
                    n4 = (n4 - 2) / 2;
                }
                n4 = 0;
            }
            this.szptr[n3] = (short)(n5 + 1);
            ++n3;
            int n6 = n5 + 1;
            this.mtfFreq[n6] = this.mtfFreq[n6] + 1;
        }
        if (n4 > 0) {
            --n4;
            while (true) {
                switch (n4 % 2) {
                    case 0: {
                        this.szptr[n3] = 0;
                        ++n3;
                        this.mtfFreq[0] = this.mtfFreq[0] + 1;
                        break;
                    }
                    case 1: {
                        this.szptr[n3] = 1;
                        ++n3;
                        this.mtfFreq[1] = this.mtfFreq[1] + 1;
                    }
                }
                if (n4 < 2) break;
                n4 = (n4 - 2) / 2;
            }
        }
        this.szptr[n3] = (short)n2;
        int n7 = n2;
        this.mtfFreq[n7] = this.mtfFreq[n7] + 1;
        this.nMTF = ++n3;
    }

    private static class StackElem {
        int ll;
        int hh;
        int dd;

        private StackElem() {
        }
    }
}

