/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.apache.bzip2;

import java.io.IOException;
import java.io.InputStream;
import org.gradle.internal.impldep.org.bouncycastle.apache.bzip2.BZip2Constants;
import org.gradle.internal.impldep.org.bouncycastle.apache.bzip2.CRC;

public class CBZip2InputStream
extends InputStream
implements BZip2Constants {
    private int last;
    private int origPtr;
    private int blockSize100k;
    private boolean blockRandomised;
    private int bsBuff;
    private int bsLive;
    private CRC mCrc = new CRC();
    private boolean[] inUse = new boolean[256];
    private int nInUse;
    private char[] seqToUnseq = new char[256];
    private char[] unseqToSeq = new char[256];
    private char[] selector = new char[18002];
    private char[] selectorMtf = new char[18002];
    private int[] tt = null;
    private char[] ll8 = null;
    private int[] unzftab = new int[256];
    private int[][] limit = new int[6][258];
    private int[][] base = new int[6][258];
    private int[][] perm = new int[6][258];
    private int[] minLens = new int[6];
    private InputStream bsStream;
    private boolean streamEnd = false;
    private int currentChar = -1;
    private static final int START_BLOCK_STATE = 1;
    private static final int RAND_PART_A_STATE = 2;
    private static final int RAND_PART_B_STATE = 3;
    private static final int RAND_PART_C_STATE = 4;
    private static final int NO_RAND_PART_A_STATE = 5;
    private static final int NO_RAND_PART_B_STATE = 6;
    private static final int NO_RAND_PART_C_STATE = 7;
    private int currentState = 1;
    private int storedBlockCRC;
    private int storedCombinedCRC;
    private int computedBlockCRC;
    private int computedCombinedCRC;
    int i2;
    int count;
    int chPrev;
    int ch2;
    int i;
    int tPos;
    int rNToGo = 0;
    int rTPos = 0;
    int j2;
    char z;

    private static void cadvise() {
        System.out.println("CRC Error");
    }

    private static void compressedStreamEOF() {
        CBZip2InputStream.cadvise();
    }

    private void makeMaps() {
        this.nInUse = 0;
        for (int i = 0; i < 256; ++i) {
            if (!this.inUse[i]) continue;
            this.seqToUnseq[this.nInUse] = (char)i;
            this.unseqToSeq[i] = (char)this.nInUse;
            ++this.nInUse;
        }
    }

    public CBZip2InputStream(InputStream inputStream) throws IOException {
        this.bsSetStream(inputStream);
        this.initialize();
        this.initBlock();
        this.setupBlock();
    }

    public int read() {
        if (this.streamEnd) {
            return -1;
        }
        int n = this.currentChar;
        switch (this.currentState) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.setupRandPartB();
                break;
            }
            case 4: {
                this.setupRandPartC();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.setupNoRandPartB();
                break;
            }
            case 7: {
                this.setupNoRandPartC();
                break;
            }
        }
        return n;
    }

    private void initialize() throws IOException {
        char c = this.bsGetUChar();
        char c2 = this.bsGetUChar();
        if (c != 'B' && c2 != 'Z') {
            throw new IOException("Not a BZIP2 marked stream");
        }
        c = this.bsGetUChar();
        c2 = this.bsGetUChar();
        if (c != 'h' || c2 < '1' || c2 > '9') {
            this.bsFinishedWithStream();
            this.streamEnd = true;
            return;
        }
        this.setDecompressStructureSizes(c2 - 48);
        this.computedCombinedCRC = 0;
    }

    private void initBlock() {
        char c = this.bsGetUChar();
        char c2 = this.bsGetUChar();
        char c3 = this.bsGetUChar();
        char c4 = this.bsGetUChar();
        char c5 = this.bsGetUChar();
        char c6 = this.bsGetUChar();
        if (c == '\u0017' && c2 == 'r' && c3 == 'E' && c4 == '8' && c5 == 'P' && c6 == '\u0090') {
            this.complete();
            return;
        }
        if (c != '1' || c2 != 'A' || c3 != 'Y' || c4 != '&' || c5 != 'S' || c6 != 'Y') {
            CBZip2InputStream.badBlockHeader();
            this.streamEnd = true;
            return;
        }
        this.storedBlockCRC = this.bsGetInt32();
        this.blockRandomised = this.bsR(1) == 1;
        this.getAndMoveToFrontDecode();
        this.mCrc.initialiseCRC();
        this.currentState = 1;
    }

    private void endBlock() {
        this.computedBlockCRC = this.mCrc.getFinalCRC();
        if (this.storedBlockCRC != this.computedBlockCRC) {
            CBZip2InputStream.crcError();
        }
        this.computedCombinedCRC = this.computedCombinedCRC << 1 | this.computedCombinedCRC >>> 31;
        this.computedCombinedCRC ^= this.computedBlockCRC;
    }

    private void complete() {
        this.storedCombinedCRC = this.bsGetInt32();
        if (this.storedCombinedCRC != this.computedCombinedCRC) {
            CBZip2InputStream.crcError();
        }
        this.bsFinishedWithStream();
        this.streamEnd = true;
    }

    private static void blockOverrun() {
        CBZip2InputStream.cadvise();
    }

    private static void badBlockHeader() {
        CBZip2InputStream.cadvise();
    }

    private static void crcError() {
        CBZip2InputStream.cadvise();
    }

    private void bsFinishedWithStream() {
        try {
            if (this.bsStream != null && this.bsStream != System.in) {
                this.bsStream.close();
                this.bsStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void bsSetStream(InputStream inputStream) {
        this.bsStream = inputStream;
        this.bsLive = 0;
        this.bsBuff = 0;
    }

    private int bsR(int n) {
        while (this.bsLive < n) {
            char c = '\u0000';
            try {
                c = (char)this.bsStream.read();
            }
            catch (IOException iOException) {
                CBZip2InputStream.compressedStreamEOF();
            }
            if (c == '\uffffffff') {
                CBZip2InputStream.compressedStreamEOF();
            }
            char c2 = c;
            this.bsBuff = this.bsBuff << 8 | c2 & 0xFF;
            this.bsLive += 8;
        }
        int n2 = this.bsBuff >> this.bsLive - n & (1 << n) - 1;
        this.bsLive -= n;
        return n2;
    }

    private char bsGetUChar() {
        return (char)this.bsR(8);
    }

    private int bsGetint() {
        int n = 0;
        n = n << 8 | this.bsR(8);
        n = n << 8 | this.bsR(8);
        n = n << 8 | this.bsR(8);
        n = n << 8 | this.bsR(8);
        return n;
    }

    private int bsGetIntVS(int n) {
        return this.bsR(n);
    }

    private int bsGetInt32() {
        return this.bsGetint();
    }

    private void hbCreateDecodeTables(int[] nArray, int[] nArray2, int[] nArray3, char[] cArray, int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        for (n4 = n; n4 <= n2; ++n4) {
            for (int i = 0; i < n3; ++i) {
                if (cArray[i] != n4) continue;
                nArray3[n5] = i;
                ++n5;
            }
        }
        for (n4 = 0; n4 < 23; ++n4) {
            nArray2[n4] = 0;
        }
        for (n4 = 0; n4 < n3; ++n4) {
            int n6 = cArray[n4] + '\u0001';
            nArray2[n6] = nArray2[n6] + 1;
        }
        for (n4 = 1; n4 < 23; ++n4) {
            int n7 = n4;
            nArray2[n7] = nArray2[n7] + nArray2[n4 - 1];
        }
        for (n4 = 0; n4 < 23; ++n4) {
            nArray[n4] = 0;
        }
        int n8 = 0;
        for (n4 = n; n4 <= n2; ++n4) {
            nArray[n4] = (n8 += nArray2[n4 + 1] - nArray2[n4]) - 1;
            n8 <<= 1;
        }
        for (n4 = n + 1; n4 <= n2; ++n4) {
            nArray2[n4] = (nArray[n4 - 1] + 1 << 1) - nArray2[n4];
        }
    }

    private void recvDecodingTables() {
        int n;
        int n2;
        int n3;
        int n4;
        char[][] cArray = new char[6][258];
        boolean[] blArray = new boolean[16];
        for (n4 = 0; n4 < 16; ++n4) {
            blArray[n4] = this.bsR(1) == 1;
        }
        for (n4 = 0; n4 < 256; ++n4) {
            this.inUse[n4] = false;
        }
        for (n4 = 0; n4 < 16; ++n4) {
            if (!blArray[n4]) continue;
            for (n3 = 0; n3 < 16; ++n3) {
                if (this.bsR(1) != 1) continue;
                this.inUse[n4 * 16 + n3] = true;
            }
        }
        this.makeMaps();
        int n5 = this.nInUse + 2;
        int n6 = this.bsR(3);
        int n7 = this.bsR(15);
        for (n4 = 0; n4 < n7; ++n4) {
            n3 = 0;
            while (this.bsR(1) == 1) {
                ++n3;
            }
            this.selectorMtf[n4] = (char)n3;
        }
        char[] cArray2 = new char[6];
        for (n2 = 0; n2 < n6; n2 = (int)((char)(n2 + 1))) {
            cArray2[n2] = n2;
        }
        for (n4 = 0; n4 < n7; ++n4) {
            char c = cArray2[n2];
            for (n2 = this.selectorMtf[n4]; n2 > 0; n2 = (int)((char)(n2 - 1))) {
                cArray2[n2] = cArray2[n2 - 1];
            }
            cArray2[0] = c;
            this.selector[n4] = c;
        }
        for (n = 0; n < n6; ++n) {
            int n8 = this.bsR(5);
            for (n4 = 0; n4 < n5; ++n4) {
                while (this.bsR(1) == 1) {
                    if (this.bsR(1) == 0) {
                        ++n8;
                        continue;
                    }
                    --n8;
                }
                cArray[n][n4] = (char)n8;
            }
        }
        for (n = 0; n < n6; ++n) {
            int n9 = 32;
            char c = '\u0000';
            for (n4 = 0; n4 < n5; ++n4) {
                if (cArray[n][n4] > c) {
                    c = cArray[n][n4];
                }
                if (cArray[n][n4] >= n9) continue;
                n9 = cArray[n][n4];
            }
            this.hbCreateDecodeTables(this.limit[n], this.base[n], this.perm[n], cArray[n], n9, c, n5);
            this.minLens[n] = n9;
        }
    }

    private void getAndMoveToFrontDecode() {
        int n;
        int n2;
        int n3;
        int n4;
        char[] cArray = new char[256];
        int n5 = 100000 * this.blockSize100k;
        this.origPtr = this.bsGetIntVS(24);
        this.recvDecodingTables();
        int n6 = this.nInUse + 1;
        int n7 = -1;
        int n8 = 0;
        for (n4 = 0; n4 <= 255; ++n4) {
            this.unzftab[n4] = 0;
        }
        for (n4 = 0; n4 <= 255; ++n4) {
            cArray[n4] = (char)n4;
        }
        this.last = -1;
        if (n8 == 0) {
            ++n7;
            n8 = 50;
        }
        --n8;
        char c = this.selector[n7];
        int n9 = this.minLens[c];
        int n10 = this.bsR(n9);
        while (n10 > this.limit[c][n9]) {
            ++n9;
            while (this.bsLive < 1) {
                n3 = 0;
                try {
                    n3 = this.bsStream.read();
                }
                catch (IOException iOException) {
                    CBZip2InputStream.compressedStreamEOF();
                }
                if (n3 == -1) {
                    CBZip2InputStream.compressedStreamEOF();
                }
                n2 = n3;
                this.bsBuff = this.bsBuff << 8 | n2 & 0xFF;
                this.bsLive += 8;
            }
            n = this.bsBuff >> this.bsLive - 1 & 1;
            --this.bsLive;
            n10 = n10 << 1 | n;
        }
        int n11 = this.perm[c][n10 - this.base[c][n9]];
        while (n11 != n6) {
            int n12;
            if (n11 == 0 || n11 == 1) {
                n9 = -1;
                n10 = 1;
                do {
                    if (n11 == 0) {
                        n9 += 1 * n10;
                    } else if (n11 == 1) {
                        n9 += 2 * n10;
                    }
                    n10 *= 2;
                    if (n8 == 0) {
                        ++n7;
                        n8 = 50;
                    }
                    --n8;
                    n = this.selector[n7];
                    n2 = this.minLens[n];
                    n3 = this.bsR(n2);
                    while (n3 > this.limit[n][n2]) {
                        ++n2;
                        while (this.bsLive < 1) {
                            char c2 = '\u0000';
                            try {
                                c2 = (char)this.bsStream.read();
                            }
                            catch (IOException iOException) {
                                CBZip2InputStream.compressedStreamEOF();
                            }
                            if (c2 == '\uffffffff') {
                                CBZip2InputStream.compressedStreamEOF();
                            }
                            char c3 = c2;
                            this.bsBuff = this.bsBuff << 8 | c3 & 0xFF;
                            this.bsLive += 8;
                        }
                        int n13 = this.bsBuff >> this.bsLive - 1 & 1;
                        --this.bsLive;
                        n3 = n3 << 1 | n13;
                    }
                } while ((n11 = this.perm[n][n3 - this.base[n][n2]]) == 0 || n11 == 1);
                char c4 = c = this.seqToUnseq[cArray[0]];
                this.unzftab[c4] = this.unzftab[c4] + ++n9;
                while (n9 > 0) {
                    ++this.last;
                    this.ll8[this.last] = c;
                    --n9;
                }
                if (this.last < n5) continue;
                CBZip2InputStream.blockOverrun();
                continue;
            }
            ++this.last;
            if (this.last >= n5) {
                CBZip2InputStream.blockOverrun();
            }
            c = cArray[n11 - 1];
            char c5 = this.seqToUnseq[c];
            this.unzftab[c5] = this.unzftab[c5] + 1;
            this.ll8[this.last] = this.seqToUnseq[c];
            for (n12 = n11 - 1; n12 > 3; n12 -= 4) {
                cArray[n12] = cArray[n12 - 1];
                cArray[n12 - 1] = cArray[n12 - 2];
                cArray[n12 - 2] = cArray[n12 - 3];
                cArray[n12 - 3] = cArray[n12 - 4];
            }
            while (n12 > 0) {
                cArray[n12] = cArray[n12 - 1];
                --n12;
            }
            cArray[0] = c;
            if (n8 == 0) {
                ++n7;
                n8 = 50;
            }
            --n8;
            n9 = this.selector[n7];
            n10 = this.minLens[n9];
            n = this.bsR(n10);
            while (n > this.limit[n9][n10]) {
                ++n10;
                while (this.bsLive < 1) {
                    char c6 = '\u0000';
                    try {
                        c6 = (char)this.bsStream.read();
                    }
                    catch (IOException iOException) {
                        CBZip2InputStream.compressedStreamEOF();
                    }
                    n3 = c6;
                    this.bsBuff = this.bsBuff << 8 | n3 & 0xFF;
                    this.bsLive += 8;
                }
                n2 = this.bsBuff >> this.bsLive - 1 & 1;
                --this.bsLive;
                n = n << 1 | n2;
            }
            n11 = this.perm[n9][n - this.base[n9][n10]];
        }
    }

    private void setupBlock() {
        int[] nArray = new int[257];
        nArray[0] = 0;
        this.i = 1;
        while (this.i <= 256) {
            nArray[this.i] = this.unzftab[this.i - 1];
            ++this.i;
        }
        this.i = 1;
        while (this.i <= 256) {
            int n = this.i;
            nArray[n] = nArray[n] + nArray[this.i - 1];
            ++this.i;
        }
        this.i = 0;
        while (this.i <= this.last) {
            char c = this.ll8[this.i];
            this.tt[nArray[c]] = this.i++;
            char c2 = c;
            nArray[c2] = nArray[c2] + 1;
        }
        nArray = null;
        this.tPos = this.tt[this.origPtr];
        this.count = 0;
        this.i2 = 0;
        this.ch2 = 256;
        if (this.blockRandomised) {
            this.rNToGo = 0;
            this.rTPos = 0;
            this.setupRandPartA();
        } else {
            this.setupNoRandPartA();
        }
    }

    private void setupRandPartA() {
        if (this.i2 <= this.last) {
            this.chPrev = this.ch2;
            this.ch2 = this.ll8[this.tPos];
            this.tPos = this.tt[this.tPos];
            if (this.rNToGo == 0) {
                this.rNToGo = rNums[this.rTPos];
                ++this.rTPos;
                if (this.rTPos == 512) {
                    this.rTPos = 0;
                }
            }
            --this.rNToGo;
            this.ch2 ^= this.rNToGo == 1 ? 1 : 0;
            ++this.i2;
            this.currentChar = this.ch2;
            this.currentState = 3;
            this.mCrc.updateCRC(this.ch2);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupNoRandPartA() {
        if (this.i2 <= this.last) {
            this.chPrev = this.ch2;
            this.ch2 = this.ll8[this.tPos];
            this.tPos = this.tt[this.tPos];
            ++this.i2;
            this.currentChar = this.ch2;
            this.currentState = 6;
            this.mCrc.updateCRC(this.ch2);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupRandPartB() {
        if (this.ch2 != this.chPrev) {
            this.currentState = 2;
            this.count = 1;
            this.setupRandPartA();
        } else {
            ++this.count;
            if (this.count >= 4) {
                this.z = this.ll8[this.tPos];
                this.tPos = this.tt[this.tPos];
                if (this.rNToGo == 0) {
                    this.rNToGo = rNums[this.rTPos];
                    ++this.rTPos;
                    if (this.rTPos == 512) {
                        this.rTPos = 0;
                    }
                }
                --this.rNToGo;
                this.z = (char)(this.z ^ (this.rNToGo == 1 ? (char)'\u0001' : '\u0000'));
                this.j2 = 0;
                this.currentState = 4;
                this.setupRandPartC();
            } else {
                this.currentState = 2;
                this.setupRandPartA();
            }
        }
    }

    private void setupRandPartC() {
        if (this.j2 < this.z) {
            this.currentChar = this.ch2;
            this.mCrc.updateCRC(this.ch2);
            ++this.j2;
        } else {
            this.currentState = 2;
            ++this.i2;
            this.count = 0;
            this.setupRandPartA();
        }
    }

    private void setupNoRandPartB() {
        if (this.ch2 != this.chPrev) {
            this.currentState = 5;
            this.count = 1;
            this.setupNoRandPartA();
        } else {
            ++this.count;
            if (this.count >= 4) {
                this.z = this.ll8[this.tPos];
                this.tPos = this.tt[this.tPos];
                this.currentState = 7;
                this.j2 = 0;
                this.setupNoRandPartC();
            } else {
                this.currentState = 5;
                this.setupNoRandPartA();
            }
        }
    }

    private void setupNoRandPartC() {
        if (this.j2 < this.z) {
            this.currentChar = this.ch2;
            this.mCrc.updateCRC(this.ch2);
            ++this.j2;
        } else {
            this.currentState = 5;
            ++this.i2;
            this.count = 0;
            this.setupNoRandPartA();
        }
    }

    private void setDecompressStructureSizes(int n) {
        if (0 > n || n > 9 || 0 > this.blockSize100k || this.blockSize100k > 9) {
            // empty if block
        }
        this.blockSize100k = n;
        if (n == 0) {
            return;
        }
        int n2 = 100000 * n;
        this.ll8 = new char[n2];
        this.tt = new int[n2];
    }
}

