/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.partitions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.internal.impldep.com.amazonaws.annotation.SdkInternalApi;
import org.gradle.internal.impldep.com.amazonaws.partitions.PartitionRegionImpl;
import org.gradle.internal.impldep.com.amazonaws.partitions.model.Partition;
import org.gradle.internal.impldep.com.amazonaws.partitions.model.Region;
import org.gradle.internal.impldep.com.amazonaws.regions.AbstractRegionMetadataProvider;
import org.gradle.internal.impldep.com.amazonaws.util.ValidationUtils;

@SdkInternalApi
public class PartitionMetadataProvider
extends AbstractRegionMetadataProvider {
    private final Map<String, Partition> partitionMap = new HashMap<String, Partition>();
    private final Map<String, org.gradle.internal.impldep.com.amazonaws.regions.Region> regionCache = new ConcurrentHashMap<String, org.gradle.internal.impldep.com.amazonaws.regions.Region>();

    public PartitionMetadataProvider(List<Partition> partitions) {
        ValidationUtils.assertNotNull(partitions, "partitions");
        for (Partition p : partitions) {
            this.partitionMap.put(p.getPartition(), p);
        }
    }

    @Override
    public List<org.gradle.internal.impldep.com.amazonaws.regions.Region> getRegions() {
        ArrayList<org.gradle.internal.impldep.com.amazonaws.regions.Region> regions = new ArrayList<org.gradle.internal.impldep.com.amazonaws.regions.Region>();
        for (Partition p : this.partitionMap.values()) {
            for (Map.Entry<String, Region> entry : p.getRegions().entrySet()) {
                regions.add(new org.gradle.internal.impldep.com.amazonaws.regions.Region(new PartitionRegionImpl(entry.getKey(), p)));
            }
        }
        return Collections.unmodifiableList(regions);
    }

    @Override
    public org.gradle.internal.impldep.com.amazonaws.regions.Region getRegion(String regionName) {
        if (regionName == null) {
            return null;
        }
        org.gradle.internal.impldep.com.amazonaws.regions.Region regionFromCache = this.getRegionFromCache(regionName);
        if (regionFromCache != null) {
            return regionFromCache;
        }
        return this.createNewRegion(regionName);
    }

    private org.gradle.internal.impldep.com.amazonaws.regions.Region createNewRegion(String regionName) {
        for (Partition p : this.partitionMap.values()) {
            if (!p.hasRegion(regionName)) continue;
            return this.cacheRegion(new PartitionRegionImpl(regionName, p));
        }
        Partition awsPartition = this.partitionMap.get("aws");
        if (awsPartition != null) {
            return this.cacheRegion(new PartitionRegionImpl(regionName, awsPartition));
        }
        return null;
    }

    private org.gradle.internal.impldep.com.amazonaws.regions.Region getRegionFromCache(String regionName) {
        return this.regionCache.get(regionName);
    }

    private org.gradle.internal.impldep.com.amazonaws.regions.Region cacheRegion(PartitionRegionImpl regionImpl) {
        org.gradle.internal.impldep.com.amazonaws.regions.Region region = new org.gradle.internal.impldep.com.amazonaws.regions.Region(regionImpl);
        this.regionCache.put(region.getName(), region);
        return region;
    }

    @Override
    public List<org.gradle.internal.impldep.com.amazonaws.regions.Region> getRegionsForService(String serviceName) {
        List<org.gradle.internal.impldep.com.amazonaws.regions.Region> allRegions = this.getRegions();
        ArrayList<org.gradle.internal.impldep.com.amazonaws.regions.Region> serviceSupportedRegions = new ArrayList<org.gradle.internal.impldep.com.amazonaws.regions.Region>();
        for (org.gradle.internal.impldep.com.amazonaws.regions.Region r : allRegions) {
            if (!r.isServiceSupported(serviceName)) continue;
            serviceSupportedRegions.add(r);
        }
        return serviceSupportedRegions;
    }
}

