/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.setup.module;

import com.android.tools.idea.apk.ApkSetupContext;
import com.android.tools.idea.apk.setup.module.ApkModuleSetupStep;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.debugger.ui.breakpoints.JavaWildcardMethodBreakpointType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class BreakpointSetupStep
extends ApkModuleSetupStep {
    @NotNull
    private final BreakpointManagerSource myBreakpointManagerSource;

    public BreakpointSetupStep() {
        this(project -> XDebuggerManager.getInstance((Project)project).getBreakpointManager());
    }

    @VisibleForTesting
    BreakpointSetupStep(@NotNull BreakpointManagerSource breakpointManagerSource) {
        this.myBreakpointManagerSource = breakpointManagerSource;
    }

    @Override
    public void setUpModule(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ApkSetupContext context) {
        JavaWildcardMethodBreakpointType type = (JavaWildcardMethodBreakpointType)XDebuggerUtil.getInstance().findBreakpointType(JavaWildcardMethodBreakpointType.class);
        JavaMethodBreakpointProperties properties = new JavaMethodBreakpointProperties("*Activity", "onCreate");
        Project project = context.getModule().getProject();
        XBreakpointManager breakpointManager = this.myBreakpointManagerSource.getBreakpointManager(project);
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> application.runWriteAction(() -> breakpointManager.addBreakpoint((XBreakpointType)type, (XBreakpointProperties)properties)));
    }

    static interface BreakpointManagerSource {
        @NotNull
        public XBreakpointManager getBreakpointManager(@NotNull Project var1);
    }
}

