/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.reload;

import com.android.tools.idea.apk.ApkDebuggingUsageTracker;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.ApkImportPathProperty;
import com.android.tools.idea.apk.FileWatcherService;
import com.android.tools.idea.apk.LibraryUpdates;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.dex.DexFileDisassembler;
import com.android.tools.idea.apk.reload.ApkMessagesProvider;
import com.android.tools.idea.apk.reload.ApkReloadException;
import com.android.tools.idea.apk.reload.SdkReader;
import com.android.tools.idea.apk.reload.SdkUpdater;
import com.android.tools.idea.apk.reload.Util;
import com.android.tools.idea.apk.symbols.SourceFoldersUpdater;
import com.android.tools.idea.apk.viewer.ApkFileSystem;
import com.android.tools.idea.project.CustomProjectTypeImporter;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.ndk.BuildIdReader;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.PathUtil;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class ApkReloader {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    @NotNull
    private final CustomProjectTypeImporter.MainImporter myProjectImporter;
    @NotNull
    private final ApkMessagesProvider myMessagesProvider;
    @NotNull
    private final Supplier<? extends BuildIdReader> myBuildIdReaderFactory;
    @NotNull
    private final LocalFileSystem myLocalFileSystem;
    @NotNull
    private final IdeSdks myIdeSdks;
    @NotNull
    private final SdkUpdater mySdkUpdater;

    public ApkReloader(@NotNull Project project, @NotNull ProgressIndicator progressIndicator) {
        this(project, progressIndicator, CustomProjectTypeImporter.getMain(), new ApkMessagesProvider(project), () -> new BuildIdReader(), LocalFileSystem.getInstance(), IdeSdks.getInstance());
    }

    private ApkReloader(@NotNull Project project, @NotNull ProgressIndicator progressIndicator, @NotNull CustomProjectTypeImporter.MainImporter projectImporter, @NotNull ApkMessagesProvider apkMessagesProvider, @NotNull Supplier<? extends BuildIdReader> buildIdReaderFactory, @NotNull LocalFileSystem localFileSystem, @NotNull IdeSdks ideSdks) {
        this(project, progressIndicator, projectImporter, apkMessagesProvider, buildIdReaderFactory, localFileSystem, ideSdks, new SdkUpdater(project, ideSdks));
    }

    @VisibleForTesting
    ApkReloader(@NotNull Project project, @NotNull ProgressIndicator progressIndicator, @NotNull CustomProjectTypeImporter.MainImporter projectImporter, @NotNull ApkMessagesProvider apkMessagesProvider, @NotNull Supplier<? extends BuildIdReader> buildIdReaderFactory, @NotNull LocalFileSystem localFileSystem, @NotNull IdeSdks ideSdks, @NotNull SdkUpdater sdkUpdater) {
        this.myProject = project;
        this.myProgressIndicator = progressIndicator;
        this.myProjectImporter = projectImporter;
        this.myMessagesProvider = apkMessagesProvider;
        this.myBuildIdReaderFactory = buildIdReaderFactory;
        this.myLocalFileSystem = localFileSystem;
        this.myIdeSdks = ideSdks;
        this.mySdkUpdater = sdkUpdater;
    }

    public void reloadSameFile(@NotNull VirtualFile oldApkFile) {
        VirtualFile newApkFile;
        String hint = ApkImportPathProperty.getPath(this.myProject);
        VirtualFile virtualFile = newApkFile = hint == null ? null : this.myLocalFileSystem.refreshAndFindFileByPath(hint);
        if (newApkFile == null) {
            this.myMessagesProvider.showApkFileNotFoundMessage();
            return;
        }
        this.reload(oldApkFile, newApkFile);
    }

    public void reload(@NotNull VirtualFile oldApkFile, @NotNull VirtualFile newApkFile) {
        ApkImportPathProperty.setPath(this.myProject, newApkFile);
        ApkImportPathProperty.setTimestamp(this.myProject, newApkFile);
        ((FileWatcherService)ServiceManager.getService((Project)this.myProject, FileWatcherService.class)).setApkPathToWatch(newApkFile.getPath());
        try {
            this.tryReload(oldApkFile, newApkFile);
        }
        catch (ApkReloadException e) {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                int userSelection = this.myMessagesProvider.showFailedToReloadMessage();
                switch (userSelection) {
                    case 0: {
                        ApkReloader.getLogger().warn((Throwable)e);
                        this.myProjectImporter.importFileAsProject(newApkFile);
                        return;
                    }
                    case 2: {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    @VisibleForTesting
    void tryReload(@NotNull VirtualFile oldApkFile, @NotNull VirtualFile newApkFile) throws ApkReloadException {
        ApkFacet apkFacet = Util.findApkFacet(this.myProject, oldApkFile);
        if (apkFacet == null) {
            throw new ApkReloadException("Failed to find ApkFacet");
        }
        Module module = apkFacet.getModule();
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
        if (androidFacet == null) {
            throw new ApkReloadException("Failed to find AndroidFacet");
        }
        ApkDebuggingUsageTracker.logEvent(apkFacet, AndroidStudioEvent.EventKind.APK_DEBUG_RELOAD_START);
        this.tryReload(module, apkFacet, androidFacet, oldApkFile, newApkFile);
        ApkDebuggingUsageTracker.logEvent(apkFacet, AndroidStudioEvent.EventKind.APK_DEBUG_RELOAD_SUCCESS);
    }

    private void tryReload(@NotNull Module module, @NotNull ApkFacet apkFacet, @NotNull AndroidFacet androidFacet, @NotNull VirtualFile oldApkFile, @NotNull VirtualFile newApkFile) throws ApkReloadException {
        VirtualFile projectDir = oldApkFile.getParent();
        this.myProgressIndicator.setText("Reading project state");
        SoFiles oldSoFiles = SoFiles.fromNativeLibraries(apkFacet, this.myBuildIdReaderFactory);
        String oldSdkApiLevelFromManifest = SdkReader.getSdkApiLevelFromManifest(androidFacet);
        this.myProgressIndicator.setText("Cleaning up current project files");
        this.deleteProjectFiles(oldApkFile);
        this.myProgressIndicator.setText("Copying APK file");
        this.copyApkFile(newApkFile, oldApkFile);
        this.myProgressIndicator.setText("Extracting APK contents");
        this.extractFilesFromApk(newApkFile, projectDir);
        this.myProgressIndicator.setText("Disassembling dex file");
        this.disassembleDexFile(projectDir);
        this.myProgressIndicator.setText("Reading the new AndroidManifest.xml file contents");
        this.extractManifestFileFromApk(projectDir, newApkFile);
        this.myProgressIndicator.setText("Updating package name");
        ApkReloader.updatePackageName(apkFacet, androidFacet);
        this.myProgressIndicator.setText("Updating project SDK");
        this.updateSdkInModule(module, apkFacet, androidFacet, oldSdkApiLevelFromManifest);
        this.myProgressIndicator.setText("Updating native libraries");
        SoFiles newSoFiles = SoFiles.fromProjectDir(projectDir, this.myBuildIdReaderFactory);
        this.updateNativeLibraries(apkFacet, oldSoFiles, newSoFiles);
        this.myProgressIndicator.setText("Updating source folders");
        ApkReloader.updateSourceFolders(apkFacet);
    }

    private void deleteProjectFiles(@NotNull VirtualFile oldApkFile) throws ApkReloadException {
        VirtualFile projectDir = oldApkFile.getParent();
        try {
            WriteAction.runAndWait(() -> {
                VirtualFile manifestFile;
                VirtualFile libDir;
                projectDir.refresh(false, true);
                oldApkFile.delete((Object)this);
                VirtualFile smaliDir = projectDir.findChild("smali");
                if (smaliDir != null) {
                    smaliDir.delete((Object)this);
                }
                if ((libDir = projectDir.findChild("lib")) != null) {
                    libDir.delete((Object)this);
                }
                if ((manifestFile = projectDir.findChild("AndroidManifest.xml")) != null) {
                    manifestFile.delete((Object)this);
                }
                projectDir.refresh(false, true);
            });
        }
        catch (IOException e) {
            throw new ApkReloadException(e);
        }
    }

    private void copyApkFile(@NotNull VirtualFile newApkFile, @NotNull VirtualFile oldApkFile) throws ApkReloadException {
        VirtualFile projectDir = oldApkFile.getParent();
        try {
            WriteAction.runAndWait(() -> VfsUtilCore.copyFile((Object)this, (VirtualFile)newApkFile, (VirtualFile)projectDir, (String)oldApkFile.getName()));
        }
        catch (IOException e) {
            throw new ApkReloadException(e);
        }
    }

    private void extractFilesFromApk(@NotNull VirtualFile apk, @NotNull VirtualFile projectDir) throws ApkReloadException {
        VirtualFile smaliDir = projectDir.findChild("smali");
        if (smaliDir == null) {
            try {
                smaliDir = (VirtualFile)WriteAction.computeAndWait(() -> projectDir.createChildDirectory((Object)this, "smali"));
            }
            catch (IOException e) {
                throw new ApkReloadException(e);
            }
        }
        File apkFile = VfsUtilCore.virtualToIoFile((VirtualFile)apk);
        Pattern dexFilePattern = Pattern.compile("classes\\d*\\.dex");
        try (ZipFile zipFile = new ZipFile(apkFile);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            Splitter pathSplitter = Splitter.on((char)'/');
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                List segments = pathSplitter.omitEmptyStrings().splitToList((CharSequence)name);
                int segmentCount = segments.size();
                if (segmentCount == 0) continue;
                String first = (String)segments.get(0);
                if (segmentCount > 1 && "lib".equals(first) && name.endsWith(".so")) {
                    ApkReloader.extractEntryFromZipFile(entry, projectDir, zipFile);
                    continue;
                }
                if (segmentCount != 1 || !dexFilePattern.matcher(first).matches()) continue;
                ApkReloader.extractEntryFromZipFile(entry, smaliDir, zipFile);
            }
        }
        catch (ZipException e) {
            throw new ApkReloadException(e);
        }
        catch (IOException e) {
            throw new ApkReloadException(e);
        }
        WriteAction.runAndWait(() -> projectDir.refresh(false, true));
    }

    private static void extractEntryFromZipFile(@NotNull ZipEntry entry, @NotNull VirtualFile dir, @NotNull ZipFile zipFile) throws IOException {
        File dirFile = VfsUtilCore.virtualToIoFile((VirtualFile)dir);
        ZipUtil.extractEntry((ZipEntry)entry, (InputStream)zipFile.getInputStream(entry), (File)dirFile, (boolean)true);
    }

    private void disassembleDexFile(@NotNull VirtualFile projectDir) throws ApkReloadException {
        VirtualFile dex;
        VirtualFile smaliDir = projectDir.findChild("smali");
        VirtualFile virtualFile = dex = smaliDir == null ? null : smaliDir.findChild("classes.dex");
        if (dex == null || !dex.exists()) {
            return;
        }
        File dexFile = VfsUtilCore.virtualToIoFile((VirtualFile)dex);
        try {
            VirtualFile outDir = (VirtualFile)WriteAction.computeAndWait(() -> smaliDir.createChildDirectory((Object)this, "out"));
            File outFile = VfsUtilCore.virtualToIoFile((VirtualFile)outDir);
            DexFileDisassembler disassembler = new DexFileDisassembler();
            disassembler.disassemble(dexFile, outFile);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new ApkReloadException(e);
        }
    }

    private void extractManifestFileFromApk(@NotNull VirtualFile projectDir, @NotNull VirtualFile apk) throws ApkReloadException {
        VirtualFile apkRoot = ApkFileSystem.getInstance().getRootByLocal(apk);
        if (apkRoot == null) {
            throw new ApkReloadException("Failed to read APK file");
        }
        VirtualFile manifestFileInApk = apkRoot.findChild("AndroidManifest.xml");
        if (manifestFileInApk == null) {
            throw new ApkReloadException("Failed to find manifest from APK file");
        }
        try {
            WriteAction.runAndWait(() -> {
                VfsUtilCore.copyFile((Object)this, (VirtualFile)manifestFileInApk, (VirtualFile)projectDir);
                projectDir.refresh(false, true);
            });
        }
        catch (IOException e) {
            throw new ApkReloadException(e);
        }
    }

    private void updateNativeLibraries(@NotNull ApkFacet apkFacet, @NotNull SoFiles oldSoFiles, @NotNull SoFiles newSoFiles) throws ApkReloadException {
        ArrayList unchangedLibraries = Lists.newArrayList();
        ArrayList updatedLibraries = Lists.newArrayList();
        ArrayList deletedLibraries = Lists.newArrayList();
        ApkReloader.groupExistingLibraries(((ApkFacetConfiguration)apkFacet.getConfiguration()).NATIVE_LIBRARIES, oldSoFiles, newSoFiles, unchangedLibraries, updatedLibraries, deletedLibraries);
        HashMap addedSoFiles = Maps.newHashMap();
        ApkReloader.findAddedSoFiles(oldSoFiles, newSoFiles, addedSoFiles);
        ApkReloader.getLogger().info("Unchanged libraries: " + unchangedLibraries.size());
        for (NativeLibrary library : unchangedLibraries) {
            ApkReloader.getLogger().info("\tUnchanged: " + library.name);
        }
        ApkReloader.getLogger().info("Updated libraries: " + updatedLibraries.size());
        for (NativeLibrary library : updatedLibraries) {
            ApkReloader.getLogger().info("\tUpdated: " + library.name);
        }
        ApkReloader.getLogger().info("Deleted libraries: " + deletedLibraries.size());
        for (NativeLibrary library : deletedLibraries) {
            ApkReloader.getLogger().info("\tDeleted: " + library.name);
        }
        ApkReloader.getLogger().info("Added so files: " + addedSoFiles.size());
        for (String libraryName : addedSoFiles.keySet()) {
            ApkReloader.getLogger().info("\tAdded: library=" + libraryName + ", numSoFiles=" + ((List)addedSoFiles.get(libraryName)).size());
        }
        this.handleUnchangedLibraries(unchangedLibraries);
        this.handleUpdatedLibraries(updatedLibraries, newSoFiles);
        ApkReloader.handleDeletedLibraries(apkFacet, deletedLibraries);
        ApkReloader.handleAddedSoFiles(apkFacet, addedSoFiles);
    }

    @VisibleForTesting
    static void groupExistingLibraries(@NotNull List<NativeLibrary> libraries, @NotNull SoFiles oldSoFiles, @NotNull SoFiles newSoFiles, @NotNull List<NativeLibrary> unchangedLibraries, @NotNull List<NativeLibrary> updatedLibraries, @NotNull List<NativeLibrary> deletedLibraries) {
        for (NativeLibrary library : libraries) {
            String libraryName = library.name;
            if (ApkReloader.isDeletedLibrary(libraryName, newSoFiles)) {
                deletedLibraries.add(library);
                continue;
            }
            if (ApkReloader.isUnchangedLibrary(libraryName, oldSoFiles, newSoFiles)) {
                unchangedLibraries.add(library);
                continue;
            }
            updatedLibraries.add(library);
        }
    }

    @VisibleForTesting
    static boolean isDeletedLibrary(@NotNull String libraryName, @NotNull SoFiles newSoFiles) {
        int newNumFiles = (int)newSoFiles.myFilePaths.stream().filter(path -> PathUtil.getFileName((String)path).equals(libraryName)).count();
        return newNumFiles == 0;
    }

    @VisibleForTesting
    static boolean isUnchangedLibrary(@NotNull String libraryName, @NotNull SoFiles oldSoFiles, @NotNull SoFiles newSoFiles) {
        int newNumFiles;
        int oldNumFiles = oldSoFiles.myFilePaths.size();
        if (oldNumFiles != (newNumFiles = (int)newSoFiles.myFilePaths.stream().filter(path -> PathUtil.getFileName((String)path).equals(libraryName)).count())) {
            return false;
        }
        for (String path2 : oldSoFiles.myFilePaths) {
            byte[] oldId = (byte[])oldSoFiles.myPathToBuildId.get((Object)path2);
            if (oldId == null) {
                return false;
            }
            byte[] newId = (byte[])newSoFiles.myPathToBuildId.get((Object)path2);
            if (newId != null && Arrays.equals(oldId, newId)) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static void findAddedSoFiles(@NotNull SoFiles oldSoFiles, @NotNull SoFiles newSoFiles, @NotNull Map<String, List<String>> addedSoFiles) {
        ArrayList addedSoFilePaths = Lists.newArrayList(newSoFiles.myFilePaths);
        addedSoFilePaths.removeAll((Collection<?>)oldSoFiles.myFilePaths);
        for (String soFilePath : addedSoFilePaths) {
            String libraryName = PathUtil.getFileName((String)soFilePath);
            ArrayList soFilePathsForLibrary = addedSoFiles.get(libraryName);
            if (soFilePathsForLibrary == null) {
                soFilePathsForLibrary = Lists.newArrayList();
                addedSoFiles.put(libraryName, soFilePathsForLibrary);
            }
            soFilePathsForLibrary.add(soFilePath);
        }
    }

    private void handleUnchangedLibraries(@NotNull List<NativeLibrary> unchangedLibraries) {
        for (NativeLibrary unchangedLibrary : unchangedLibraries) {
            for (Map.Entry entry : unchangedLibrary.sharedObjectFilesByAbi.entrySet()) {
                entry.setValue(this.myLocalFileSystem.refreshAndFindFileByPath(((VirtualFile)entry.getValue()).getPath()));
            }
        }
    }

    private void handleUpdatedLibraries(@NotNull List<NativeLibrary> updatedLibraries, @NotNull SoFiles newSoFiles) throws ApkReloadException {
        for (NativeLibrary updatedLibrary : updatedLibraries) {
            this.handleUpdatedLibrary(updatedLibrary, newSoFiles);
        }
        LibraryUpdates.getInstance(this.myProject).notifyLibrariesChanged(updatedLibraries);
    }

    /*
     * Exception decompiling
     */
    private void handleUpdatedLibrary(@NotNull NativeLibrary updatedLibrary, @NotNull SoFiles newSoFiles) throws ApkReloadException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void handleDeletedLibraries(@NotNull ApkFacet apkFacet, @NotNull List<NativeLibrary> deletedLibraries) {
        ((ApkFacetConfiguration)apkFacet.getConfiguration()).NATIVE_LIBRARIES.removeAll(deletedLibraries);
    }

    private static void handleAddedSoFiles(@NotNull ApkFacet apkFacet, @NotNull Map<String, List<String>> addedSoFiles) {
        List libraries = ((ApkFacetConfiguration)apkFacet.getConfiguration()).NATIVE_LIBRARIES;
        for (Map.Entry<String, List<String>> entry : addedSoFiles.entrySet()) {
            String libraryName = entry.getKey();
            List<String> soFiles = entry.getValue();
            Optional<NativeLibrary> existingLibrary = libraries.stream().filter(library -> libraryName.equals(library.name)).findFirst();
            if (existingLibrary.isPresent()) continue;
            NativeLibrary library2 = new NativeLibrary(libraryName);
            library2.setSharedObjectFilePaths(soFiles);
            libraries.add(library2);
        }
    }

    private void updateSdkInModule(@NotNull Module module, @NotNull ApkFacet apkFacet, @NotNull AndroidFacet androidFacet, @NotNull String oldSdkApiLevelFromManifest) throws ApkReloadException {
        String newSdkApiLevelFromManifest = SdkReader.getSdkApiLevelFromManifest(androidFacet);
        String sdkApiLevelFromModule = SdkReader.getSdkApiLevelFromModule(module);
        if (sdkApiLevelFromModule != null && sdkApiLevelFromModule.equals(oldSdkApiLevelFromManifest) && !oldSdkApiLevelFromManifest.equals(newSdkApiLevelFromManifest)) {
            this.mySdkUpdater.updateSdkInModule(module, apkFacet, newSdkApiLevelFromManifest);
        }
    }

    private static void updateSourceFolders(@NotNull ApkFacet apkFacet) {
        SourceFoldersUpdater updater = new SourceFoldersUpdater();
        updater.updateSourceFoldersSync(apkFacet);
    }

    private static void updatePackageName(@NotNull ApkFacet apkFacet, @NotNull AndroidFacet androidFacet) throws ApkReloadException {
        Manifest manifest = Manifest.getMainManifest((AndroidFacet)androidFacet);
        if (manifest == null) {
            throw new ApkReloadException("Failed to find Android Manifest in the current module");
        }
        ((ApkFacetConfiguration)apkFacet.getConfiguration()).APP_PACKAGE = (String)Util.invokeAndWait(() -> (String)manifest.getPackage().getValue());
    }

    private static Logger getLogger() {
        return Logger.getInstance(ApkReloader.class);
    }

    private static /* synthetic */ boolean lambda$handleUpdatedLibrary$10(NativeLibrary updatedLibrary, String path) {
        return PathUtil.getFileName((String)path).equals(updatedLibrary.name);
    }

    @VisibleForTesting
    static class SoFiles {
        final ImmutableList<String> myFilePaths;
        final ImmutableMap<String, byte[]> myPathToBuildId;

        @VisibleForTesting
        SoFiles(@NotNull List<String> filePaths, @NotNull Map<String, byte[]> pathToBuildId) {
            this.myFilePaths = ImmutableList.copyOf(filePaths);
            this.myPathToBuildId = ImmutableMap.copyOf(pathToBuildId);
        }

        @NotNull
        @VisibleForTesting
        static SoFiles fromNativeLibraries(@NotNull ApkFacet apkFacet, @NotNull Supplier<? extends BuildIdReader> buildIdReaderFactory) {
            BuildIdReader reader = buildIdReaderFactory.get();
            ArrayList soFilePaths = Lists.newArrayList();
            HashMap soFilePathToBuildId = Maps.newHashMap();
            List libraries = ((ApkFacetConfiguration)apkFacet.getConfiguration()).NATIVE_LIBRARIES;
            for (NativeLibrary library : libraries) {
                for (VirtualFile file : library.getSharedObjectFiles()) {
                    soFilePaths.add(file.getPath());
                    byte[] buildId = reader.readBuildId(file);
                    if (buildId.length == 0) continue;
                    soFilePathToBuildId.put(file.getPath(), buildId);
                }
            }
            return new SoFiles(soFilePaths, soFilePathToBuildId);
        }

        @NotNull
        @VisibleForTesting
        static SoFiles fromProjectDir(@NotNull VirtualFile projectDir, @NotNull Supplier<? extends BuildIdReader> buildIdReaderFactory) {
            final BuildIdReader reader = buildIdReaderFactory.get();
            VirtualFile libDirVirtualFile = projectDir.findChild("lib");
            if (libDirVirtualFile == null) {
                return new SoFiles(Collections.emptyList(), Collections.emptyMap());
            }
            final ArrayList filePaths = Lists.newArrayList();
            final HashMap pathToBuildId = Maps.newHashMap();
            VfsUtilCore.visitChildrenRecursively((VirtualFile)libDirVirtualFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    WriteAction.runAndWait(() -> file.refresh(false, false));
                    if (file.exists() && !file.isDirectory() && "so".equals(file.getExtension())) {
                        String filePath = file.getPath();
                        filePaths.add(filePath);
                        byte[] buildId = reader.readBuildId(file);
                        if (buildId.length != 0) {
                            pathToBuildId.put(filePath, buildId);
                        }
                        return false;
                    }
                    return true;
                }
            });
            return new SoFiles(filePaths, pathToBuildId);
        }
    }
}

