/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.editor.notification;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class DropDownAction
extends LinkLabel<Void> {
    @NotNull
    private final Icon myIcon = AllIcons.Ide.Notification.DropTriangle;
    @NotNull
    private final DefaultActionGroup myActionGroup = new DefaultActionGroup();

    DropDownAction(@NotNull String text) {
        super(text, null);
        this.setHorizontalTextPosition(10);
        this.setIconTextGap(0);
        this.setIcon(new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                int lineY = DropDownAction.this.getUI().getBaseline((JComponent)((Object)DropDownAction.this), DropDownAction.this.getWidth(), DropDownAction.this.getHeight()) - this.getIconHeight();
                IconUtil.colorize((Graphics2D)((Graphics2D)g), (Icon)DropDownAction.this.myIcon, (Color)DropDownAction.this.getTextColor()).paintIcon(c, g, x - 1, lineY);
            }

            @Override
            public int getIconWidth() {
                return DropDownAction.this.myIcon.getIconWidth();
            }

            @Override
            public int getIconHeight() {
                return DropDownAction.this.myIcon.getIconHeight();
            }
        });
        this.setListener((aSource, aLinkData) -> this.showPopup(), null);
    }

    @NotNull
    protected Rectangle getTextBounds() {
        Rectangle bounds = super.getTextBounds();
        bounds.x -= this.getIcon().getIconWidth();
        bounds.width += 8;
        return bounds;
    }

    private void showPopup() {
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)this.myActionGroup);
        menu.getComponent().show((Component)((Object)this), JBUI.scale((int)-10), this.getHeight() + JBUI.scale((int)2));
    }

    void addAction(@NotNull AnAction action) {
        this.myActionGroup.add(action);
    }

    @VisibleForTesting
    @NotNull
    AnAction[] getActions() {
        return this.myActionGroup.getChildActionsOrStubs();
    }
}

