/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.editor.notification;

import com.android.tools.idea.apk.ApkImportPathProperty;
import com.android.tools.idea.apk.reload.ApkReloader;
import com.android.tools.idea.apk.reload.Util;
import com.android.tools.idea.flags.StudioFlags;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkReloadNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"apk.reload.file");
    @NotNull
    private final Project myProject;
    @NotNull
    EditorNotifications myEditorNotifications;

    ApkReloadNotificationProvider(@NotNull Project project) {
        this.myProject = project;
        this.myEditorNotifications = EditorNotifications.getInstance((Project)project);
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (!((Boolean)StudioFlags.APK_DEBUG_RELOAD.get()).booleanValue()) {
            return null;
        }
        if (!"apk".equals(file.getExtension()) || !Util.isApkProject(this.myProject)) {
            return null;
        }
        VirtualFile projectBaseDir = this.myProject.getBaseDir();
        if (projectBaseDir == null || !Util.isFileInDir(projectBaseDir, file)) {
            return null;
        }
        String prevImportPath = ApkImportPathProperty.getPath(this.myProject);
        Long prevImportTimestamp = ApkImportPathProperty.getTimestamp(this.myProject);
        if (prevImportPath == null || prevImportTimestamp == null) {
            return null;
        }
        VirtualFile apkFile = LocalFileSystem.getInstance().findFileByPath(prevImportPath);
        if (apkFile == null || apkFile.getTimeStamp() == prevImportTimestamp.longValue()) {
            return null;
        }
        MyEditorNotificationPanel panel = new MyEditorNotificationPanel();
        panel.setText("The APK you imported has changed");
        ReloadApkInEditorAction action = new ReloadApkInEditorAction(file);
        panel.addToLinksPanel((Component)((Object)new ReloadApkHyperlinkLabel(action, panel.getBackground())));
        return panel;
    }

    public class ReloadApkInEditorAction
    extends AnAction
    implements NotificationListener,
    HyperlinkListener {
        @NotNull
        private final VirtualFile myApkFile;

        public ReloadApkInEditorAction(VirtualFile apkFile) {
            this.myApkFile = apkFile;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            this.reloadApk();
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            this.hyperlinkUpdate(event);
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.reloadApk();
            }
        }

        public void reloadApk() {
            ProgressManager.getInstance().run((Task)new Task.Modal(ApkReloadNotificationProvider.this.myProject, "Import New APK", false){

                public void run(@NotNull ProgressIndicator indicator) {
                    assert (this.myProject != null);
                    ApkReloader reloader = new ApkReloader(this.myProject, indicator);
                    reloader.reloadSameFile(ReloadApkInEditorAction.this.myApkFile);
                    ApkReloadNotificationProvider.this.myEditorNotifications.updateNotifications(ReloadApkInEditorAction.this.myApkFile);
                }
            });
        }
    }

    @VisibleForTesting
    static class ReloadApkHyperlinkLabel
    extends HyperlinkLabel {
        ReloadApkHyperlinkLabel(@NotNull ReloadApkInEditorAction action, @NotNull Color background) {
            super("Import new APK", background);
            this.addHyperlinkListener(action);
        }

        protected void fireHyperlinkEvent(@Nullable InputEvent inputEvent) {
            super.fireHyperlinkEvent(inputEvent);
        }
    }

    @VisibleForTesting
    static class MyEditorNotificationPanel
    extends EditorNotificationPanel {
        @NotNull
        private final List<Component> myLinkComponents = new ArrayList<Component>();

        MyEditorNotificationPanel() {
        }

        void addToLinksPanel(@NotNull Component component) {
            this.myLinksPanel.add(component);
            this.myLinkComponents.add(component);
        }

        @VisibleForTesting
        @NotNull
        List<Component> getLinkComponents() {
            return this.myLinkComponents;
        }
    }
}

