/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.editor;

import com.android.tools.idea.apk.symbols.ui.PathMapping;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

class PathMappingNode
extends DefaultMutableTreeNode {
    @NotNull
    private final PathMapping myPathMapping;
    @NotNull
    private final List<String> myRelativePathSegments = new ArrayList<String>();

    PathMappingNode(@NotNull String pathSegment, @NotNull PathMapping pathMapping) {
        this.myRelativePathSegments.add(pathSegment);
        this.myPathMapping = pathMapping;
    }

    @NotNull
    String getPathSegment() {
        return this.myRelativePathSegments.get(this.myRelativePathSegments.size() - 1);
    }

    @NotNull
    List<String> getRelativePathSegments() {
        return this.myRelativePathSegments;
    }

    void update(@NotNull String pathSegment, @NotNull String filePath) {
        this.myRelativePathSegments.add(pathSegment);
        this.myPathMapping.setOriginalPath(filePath);
    }

    @NotNull
    String getFilePath() {
        return this.myPathMapping.getOriginalPath();
    }

    void updateDisplayedText() {
        TreeNode parent = this.getParent();
        if (parent instanceof PathMappingNode) {
            String parentPath = ((PathMappingNode)parent).getFilePath();
            String filePath = this.getFilePath();
            if ((filePath = filePath.substring(parentPath.length())).length() > 1 && (filePath.startsWith("/") || filePath.startsWith("\\"))) {
                filePath = filePath.substring(1);
            }
            this.updateDisplayedText(filePath);
        } else {
            this.updateDisplayedText(this.getFilePath());
        }
    }

    private void updateDisplayedText(@NotNull String text) {
        this.setUserObject(text);
    }

    @NotNull
    PathMapping getPathMapping() {
        return this.myPathMapping;
    }

    void deriveSelectedPathFromParent() {
        TreeNode parent;
        if (this.myPathMapping.getSelectedPath().isEmpty() && (parent = this.getParent()) instanceof PathMappingNode) {
            this.deriveSelectedPathFrom((PathMappingNode)parent);
        }
    }

    private void deriveSelectedPathFrom(@NotNull PathMappingNode parent) {
        String selectedPath = parent.getPathMapping().getSelectedPath();
        if (!selectedPath.isEmpty()) {
            this.deriveSelectedPathFrom(new File(selectedPath));
        }
    }

    private void deriveSelectedPathFrom(@NotNull File path) {
        File myPotentialPath;
        if (path.isDirectory() && (myPotentialPath = new File(path, FileUtil.join((String[])ArrayUtil.toStringArray(this.myRelativePathSegments)))).isDirectory()) {
            this.myPathMapping.setSelectedPath(myPotentialPath.getPath());
        }
    }
}

