/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ApkProjectFolder {
    private static final String DIALOG_TITLE = "APK Import";

    @NotNull
    VirtualFile getOrCreateNewProjectFolder(@NotNull VirtualFile apkFile) throws IOException {
        File userHomePath = new File(SystemProperties.getUserHome());
        assert (userHomePath.isDirectory());
        String projectName = apkFile.getNameWithoutExtension();
        return this.getOrCreateNewProjectFolder(projectName, userHomePath);
    }

    @VisibleForTesting
    @NotNull
    VirtualFile getOrCreateNewProjectFolder(@NotNull String projectName, @NotNull File userHomePath) throws IOException {
        File apkProjectsFolderPath = new File(userHomePath, "ApkProjects");
        FileUtil.ensureExists((File)apkProjectsFolderPath);
        File projectFolderPath = new File(apkProjectsFolderPath, projectName);
        if (projectFolderPath.isDirectory()) {
            String text = String.format("The folder '%1$s' already exists. If you choose to use the existing folder, its contents will be overwritten.", projectName);
            int answer = Messages.showOkCancelDialog((Project)null, (String)text, (String)DIALOG_TITLE, (String)"Use existing folder", (String)"Create new folder", (Icon)Messages.getQuestionIcon());
            if (answer == 0) {
                VirtualFile projectFolder;
                Project[] projects = ProjectManager.getInstance().getOpenProjects();
                if (projects.length > 0) {
                    for (Project project : projects) {
                        if (!FileUtil.pathsEqual((String)projectFolderPath.getPath(), (String)project.getBasePath())) continue;
                        String message = String.format("APK project '%1$s' will be closed and recreated", project.getName());
                        Messages.showWarningDialog((Project)project, (String)message, (String)DIALOG_TITLE);
                        ProjectUtil.closeAndDispose((Project)project);
                        WelcomeFrame.showIfNoProjectOpened();
                        break;
                    }
                }
                if ((projectFolder = VfsUtil.findFileByIoFile((File)projectFolderPath, (boolean)true)) != null) {
                    ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<Void, IOException>(){

                        public Void compute() throws IOException {
                            projectFolder.delete((Object)this);
                            return null;
                        }
                    });
                }
                FileUtil.delete((File)projectFolderPath);
            } else {
                File newPath = FileUtil.findSequentNonexistentFile((File)apkProjectsFolderPath, (String)projectName, (String)"");
                return this.getOrCreateNewProjectFolder(newPath.getName(), userHomePath);
            }
        }
        FileUtil.ensureExists((File)projectFolderPath);
        VirtualFile newProjectFolder = VfsUtil.findFileByIoFile((File)projectFolderPath, (boolean)true);
        assert (newProjectFolder != null);
        return newProjectFolder;
    }
}

