/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkImportPathProperty {
    @NotNull
    private static final String APK_IMPORT_PATH = "ApkProjectPathProperty.apkImportPath";
    @NotNull
    private static final String APK_IMPORT_FILE_TIMESTAMP = "ApkProjectPathProperty.apkImportTimestamp";

    @Nullable
    public static String getPath(@NotNull Project project) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        return propertiesComponent.getValue(APK_IMPORT_PATH);
    }

    public static void setPath(@NotNull Project project, @NotNull VirtualFile file) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        propertiesComponent.setValue(APK_IMPORT_PATH, file.getPath());
    }

    @Nullable
    public static Long getTimestamp(@NotNull Project project) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        String timestamp = propertiesComponent.getValue(APK_IMPORT_FILE_TIMESTAMP);
        if (timestamp == null) {
            return null;
        }
        try {
            return Long.parseLong(timestamp);
        }
        catch (NumberFormatException e) {
            ApkImportPathProperty.getLogger().error("Cannot parse APK file timestamp property", (Throwable)e);
            return null;
        }
    }

    public static void setTimestamp(@NotNull Project project, @NotNull VirtualFile file) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        propertiesComponent.setValue(APK_IMPORT_FILE_TIMESTAMP, Long.toString(file.getTimeStamp()));
    }

    private static Logger getLogger() {
        return Logger.getInstance(ApkImportPathProperty.class);
    }
}

