/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsagesCollectorConsumer;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class FUStateUsagesLogger
implements UsagesCollectorConsumer {
    private static final Logger LOG = Logger.getInstance(FUStateUsagesLogger.class);
    private static final Object LOCK = new Object();

    public static FUStateUsagesLogger create() {
        return new FUStateUsagesLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletableFuture<Void> logProjectStates(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        Object object = LOCK;
        synchronized (object) {
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            for (ProjectUsagesCollector usagesCollector : ProjectUsagesCollector.getExtensions(this)) {
                String groupId = usagesCollector.getGroupId();
                if (!PluginInfoDetectorKt.getPluginInfo(usagesCollector.getClass()).isDevelopedByJetBrains()) {
                    LOG.warn("Skip '" + groupId + "' because its registered in a third-party plugin");
                    continue;
                }
                EventLogGroup group = new EventLogGroup(groupId, usagesCollector.getVersion());
                CancellablePromise<? extends Set<MetricEvent>> metrics = usagesCollector.getMetrics(project, indicator);
                futures.add(FUStateUsagesLogger.logMetricsOrError(project, group, usagesCollector.getData(project), metrics));
            }
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletableFuture<Void> logApplicationStates() {
        Object object = LOCK;
        synchronized (object) {
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            for (ApplicationUsagesCollector usagesCollector : ApplicationUsagesCollector.getExtensions(this)) {
                String groupId = usagesCollector.getGroupId();
                if (!PluginInfoDetectorKt.getPluginInfo(usagesCollector.getClass()).isDevelopedByJetBrains()) {
                    LOG.warn("Skip '" + groupId + "' because its registered in a third-party plugin");
                    continue;
                }
                EventLogGroup group = new EventLogGroup(groupId, usagesCollector.getVersion());
                Promise metrics = Promises.resolvedPromise(usagesCollector.getMetrics());
                futures.add(FUStateUsagesLogger.logMetricsOrError(null, group, usagesCollector.getData(), (Promise<? extends Set<MetricEvent>>)metrics));
            }
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        }
    }

    private static CompletableFuture<Void> logMetricsOrError(@Nullable Project project, @NotNull EventLogGroup group, @Nullable FeatureUsageData context, @NotNull Promise<? extends Set<MetricEvent>> metricsPromise) {
        try {
            return FUStateUsagesLogger.logUsagesAsStateEvents(project, group, context, metricsPromise);
        }
        catch (Throwable th) {
            if (project != null && project.isDisposed()) {
                return CompletableFuture.completedFuture(null);
            }
            FeatureUsageData data = new FeatureUsageData().addProject(project);
            return FeatureUsageLogger.INSTANCE.logState(group, "invocation.failed", data.build());
        }
    }

    @NotNull
    private static CompletableFuture<Void> logUsagesAsStateEvents(@Nullable Project project, @NotNull EventLogGroup group, @Nullable FeatureUsageData context, @NotNull Promise<? extends Set<MetricEvent>> metricsPromise) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        metricsPromise.onSuccess(metrics -> {
            if (project != null && project.isDisposed()) {
                return;
            }
            FeatureUsageLogger logger2 = FeatureUsageLogger.INSTANCE;
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            if (!metrics.isEmpty()) {
                FeatureUsageData groupData = FUStateUsagesLogger.addProject(project, context);
                for (MetricEvent metric : metrics) {
                    FeatureUsageData data = FUStateUsagesLogger.mergeWithEventData(groupData, metric.getData());
                    Map<Object, Object> eventData = data != null ? data.build() : Collections.emptyMap();
                    futures.add(logger2.logState(group, metric.getEventId(), eventData));
                }
            }
            futures.add(logger2.logState(group, "invoked", new FeatureUsageData().addProject(project).build()));
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).whenComplete((result, throwable) -> future.complete(null));
        });
        return future;
    }

    @Nullable
    private static FeatureUsageData addProject(@Nullable Project project, @Nullable FeatureUsageData context) {
        if (project == null && context == null) {
            return null;
        }
        return context != null ? context.addProject(project) : new FeatureUsageData().addProject(project);
    }

    @Nullable
    public static FeatureUsageData mergeWithEventData(@Nullable FeatureUsageData groupData, @Nullable FeatureUsageData data) {
        if (data == null) {
            return groupData;
        }
        FeatureUsageData newData = groupData == null ? new FeatureUsageData() : groupData.copy();
        newData.merge(data, "event_");
        return newData;
    }

    public static void logStateEvent(@NotNull EventLogGroup group, @NotNull String event, @NotNull FeatureUsageData data) {
        FeatureUsageLogger.INSTANCE.logState(group, event, data.build());
        FeatureUsageLogger.INSTANCE.logState(group, "invoked");
    }

    public static void logStateEvents(@NotNull EventLogGroup group, @NotNull Collection<MetricEvent> events) {
        for (MetricEvent event : events) {
            FeatureUsageLogger.INSTANCE.logState(group, event.getEventId(), event.getData().build());
        }
        FeatureUsageLogger.INSTANCE.logState(group, "invoked");
    }
}

