/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.persistence;

import com.intellij.internal.statistic.eventLog.validator.persistence.BaseEventLogWhitelistPersistence;
import com.intellij.internal.statistic.eventLog.validator.persistence.EventLogWhitelistSettingsPersistence;
import com.intellij.internal.statistic.eventLog.validator.persistence.WhitelistPathSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogWhitelistPersistence
extends BaseEventLogWhitelistPersistence {
    private static final String DEPRECATED_EVENTS_SCHEME_FILE = "white-list.json";
    public static final String EVENTS_SCHEME_FILE = "events-scheme.json";
    private static final Logger LOG = Logger.getInstance(EventLogWhitelistPersistence.class);
    @NotNull
    private final String myRecorderId;

    public EventLogWhitelistPersistence(@NotNull String recorderId) {
        this.myRecorderId = recorderId;
    }

    @Override
    @Nullable
    public String getCachedMetadata() {
        try {
            File file = this.getWhitelistFile();
            if (file.exists()) {
                return FileUtil.loadFile((File)file);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @NotNull
    private File getWhitelistFile() throws IOException {
        WhitelistPathSettings settings = EventLogWhitelistSettingsPersistence.getInstance().getPathSettings(this.myRecorderId);
        if (settings != null && settings.isUseCustomPath()) {
            return new File(settings.getCustomPath());
        }
        File file = this.getDefaultFile();
        if (!file.exists()) {
            this.initBuiltinMetadata(file);
        }
        return file;
    }

    public void cacheWhiteList(@NotNull String gsonWhiteListContent, long lastModified) {
        try {
            File file = this.getDefaultFile();
            FileUtil.writeToFile((File)file, (String)gsonWhiteListContent);
            EventLogWhitelistSettingsPersistence.getInstance().setLastModified(this.myRecorderId, lastModified);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void initBuiltinMetadata(File file) throws IOException {
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(this.builtinEventSchemePath());){
            if (stream == null) {
                return;
            }
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IOException("Unable to create " + file.getParentFile().getAbsolutePath());
            }
            Files.copy(stream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private String builtinEventSchemePath() {
        return "resources/event-log-metadata/" + this.myRecorderId + "/" + EVENTS_SCHEME_FILE;
    }

    public long getLastModified() {
        return EventLogWhitelistSettingsPersistence.getInstance().getLastModified(this.myRecorderId);
    }

    @NotNull
    public File getDefaultFile() throws IOException {
        return EventLogWhitelistPersistence.getDefaultMetadataFile(this.myRecorderId, EVENTS_SCHEME_FILE, DEPRECATED_EVENTS_SCHEME_FILE);
    }
}

