/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.EventLogConnectionSettings;
import com.intellij.internal.statistic.service.request.StatsProxyInfo;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.proxy.CommonProxy;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogAppConnectionSettings
implements EventLogConnectionSettings {
    private static final StatsProxyInfo NO_PROXY = new StatsProxyInfo(Proxy.NO_PROXY, null);

    @NotNull
    public String getUserAgent() {
        Application app = ApplicationManager.getApplication();
        if (app != null && !app.isDisposed()) {
            String productName = ApplicationNamesInfo.getInstance().getFullProductName();
            String version = ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode();
            return productName + '/' + version;
        }
        return "IntelliJ";
    }

    @NotNull
    public StatsProxyInfo selectProxy(@NotNull String url) {
        Proxy proxy;
        Application app = ApplicationManager.getApplication();
        if (app != null && !app.isDisposed() && (proxy = EventLogAppConnectionSettings.findProxy(url)) != Proxy.NO_PROXY) {
            return new StatsProxyInfo(proxy, EventLogAppConnectionSettings.getAuthProvider());
        }
        return NO_PROXY;
    }

    @Nullable
    private static StatsProxyInfo.StatsProxyAuthProvider getAuthProvider() {
        if (HttpConfigurable.getInstance().PROXY_AUTHENTICATION) {
            return EventLogAppProxyAuth.INSTANCE;
        }
        return null;
    }

    @NotNull
    private static Proxy findProxy(@NotNull String url) {
        try {
            List proxies = CommonProxy.getInstance().select(new URL(url));
            return !proxies.isEmpty() ? (Proxy)proxies.get(0) : Proxy.NO_PROXY;
        }
        catch (MalformedURLException malformedURLException) {
            return Proxy.NO_PROXY;
        }
    }

    private static class EventLogAppProxyAuth
    implements StatsProxyInfo.StatsProxyAuthProvider {
        private static final EventLogAppProxyAuth INSTANCE = new EventLogAppProxyAuth();

        private EventLogAppProxyAuth() {
        }

        @Nullable
        public String getProxyLogin() {
            return HttpConfigurable.getInstance().getProxyLogin();
        }

        @Nullable
        public String getProxyPassword() {
            return HttpConfigurable.getInstance().getPlainProxyPassword();
        }
    }
}

