/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LangCustomRuleValidator
extends CustomValidationRule {
    @Override
    public boolean acceptRuleId(@Nullable String ruleId) {
        return "lang".equals(ruleId);
    }

    @Override
    @NotNull
    protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        if (LangCustomRuleValidator.isThirdPartyValue(data)) {
            return ValidationResultType.ACCEPTED;
        }
        Language language = Language.findLanguageByID((String)data);
        if (language == null) {
            return ValidationResultType.REJECTED;
        }
        return PluginInfoDetectorKt.getPluginInfo(language.getClass()).isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
    }
}

