/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GotoPropertyDeclarationsProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull DataContext context) {
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(context);
        if (!(editor instanceof ResourceBundleEditor)) {
            return Collections.emptyList();
        }
        ResourceBundleEditor resourceBundleEditor = (ResourceBundleEditor)editor;
        Collection<ResourceBundleEditorViewElement> elements = resourceBundleEditor.getSelectedElements();
        if (elements.size() != 1) {
            return Collections.emptyList();
        }
        IProperty[] properties = ((ResourceBundleEditorViewElement)ContainerUtil.getFirstItem(elements)).getProperties();
        if (properties == null || properties.length != 1 || !(properties[0] instanceof Property)) {
            return Collections.emptyList();
        }
        IProperty property = properties[0];
        String propertyKey = property.getKey();
        PropertiesFile file = PropertiesImplUtil.getPropertiesFile((PsiFile)property.getPsiElement().getContainingFile());
        assert (file != null);
        ResourceBundle resourceBundle = file.getResourceBundle();
        return ContainerUtil.mapNotNull((Collection)resourceBundle.getPropertiesFiles(), (Function)((NullableFunction)f -> {
            IProperty foundProperty = f.findPropertyByKey(propertyKey);
            return foundProperty == null ? null : new GotoRelatedItem(foundProperty.getPsiElement(), "Property Declarations");
        }));
    }
}

