/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.util.ExceptionUtil;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0006H\u0007\u00a2\u0006\u0002\u0010\u0007J\u0019\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ'\u0010\r\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0011\u00a2\u0006\u0002\u0010\u0012J3\u0010\u0013\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u00172\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0011H\u0007\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/util/ProgressIndicatorUtils;", "", "()V", "awaitWithCheckCanceled", "T", "future", "Ljava/util/concurrent/Future;", "(Ljava/util/concurrent/Future;)Ljava/lang/Object;", "checkCancelledEvenWithPCEDisabled", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/openapi/progress/ProgressIndicator;)Lkotlin/Unit;", "runUnderDisposeAwareIndicator", "parent", "Lcom/intellij/openapi/Disposable;", "computable", "Lkotlin/Function0;", "(Lcom/intellij/openapi/Disposable;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "underModalProgress", "project", "Lcom/intellij/openapi/project/Project;", "progressTitle", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kotlin.idea"})
public final class ProgressIndicatorUtils {
    @NotNull
    public static final ProgressIndicatorUtils INSTANCE;

    @JvmStatic
    public static final <T> T underModalProgress(@NotNull Project project2, @Nls @NotNull String progressTitle, @NotNull Function0<? extends T> computable) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)progressTitle, (String)"progressTitle");
        Intrinsics.checkNotNullParameter(computable, (String)"computable");
        return (T)ActionUtil.underModalProgress((Project)project2, (String)progressTitle, (Computable)new Computable<T>(computable){
            final /* synthetic */ Function0 $computable;

            public T compute() {
                return (T)this.$computable.invoke();
            }
            {
                this.$computable = $captured_local_variable$0;
            }
        });
    }

    public final <T> T runUnderDisposeAwareIndicator(@NotNull Disposable parent2, @NotNull Function0<? extends T> computable) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter(computable, (String)"computable");
        return (T)BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)parent2, (Supplier)((Supplier)new Computable<T>(computable){
            final /* synthetic */ Function0 $computable;

            public final T compute() {
                return (T)this.$computable.invoke();
            }
            {
                this.$computable = function0;
            }
        }));
    }

    @JvmStatic
    public static final <T> T awaitWithCheckCanceled(@NotNull Future<T> future) {
        Intrinsics.checkNotNullParameter(future, (String)"future");
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProgressIndicator indicator = progressManager.getProgressIndicator();
        while (true) {
            INSTANCE.checkCancelledEvenWithPCEDisabled(indicator);
            try {
                return future.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            catch (Throwable e) {
                Throwable cause = e.getCause();
                if (cause instanceof CancellationException) {
                    throw (Throwable)new ProcessCanceledException(cause);
                }
                ExceptionUtil.rethrowUnchecked((Throwable)e);
                throw (Throwable)new RuntimeException(e);
            }
            break;
        }
    }

    private final Unit checkCancelledEvenWithPCEDisabled(ProgressIndicator indicator) {
        Unit unit;
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            ProgressIndicator progressIndicator2 = progressIndicator;
            boolean bl = false;
            boolean bl2 = false;
            ProgressIndicator it = progressIndicator2;
            boolean bl3 = false;
            if (it.isCanceled()) {
                it.checkCanceled();
                throw (Throwable)new ProcessCanceledException();
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private ProgressIndicatorUtils() {
    }

    static {
        ProgressIndicatorUtils progressIndicatorUtils;
        INSTANCE = progressIndicatorUtils = new ProgressIndicatorUtils();
    }
}

