/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.intellij.usageView.UsageViewTypeLocation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\t\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B!\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u001dH\u0014J\b\u0010\u001f\u001a\u00020\u0010H\u0014J\b\u0010 \u001a\u00020\u0010H\u0014J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u0010H\u0003J\b\u0010#\u001a\u00020\u0010H\u0014J\n\u0010$\u001a\u0004\u0018\u00010\u0010H\u0014J\b\u0010%\u001a\u00020\u0010H\u0014R\u0016\u0010\u0004\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlineDialog;", "TDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lcom/intellij/refactoring/inline/InlineOptionsDialog;", "declaration", "reference", "Lcom/intellij/psi/PsiReference;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lcom/intellij/psi/PsiReference;Lcom/intellij/openapi/editor/Editor;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "kind", "", "occurrencesNumber", "", "getOccurrencesNumber", "()I", "occurrencesString", "getOccurrencesString", "()Ljava/lang/String;", "refactoringName", "getRefactoringName", "getReference", "()Lcom/intellij/psi/PsiReference;", "allowInlineAll", "", "canInlineThisOnly", "getBorderTitle", "getInlineAllText", "getInlineText", "verb", "getInlineThisText", "getKeepTheDeclarationText", "getNameLabelText", "kotlin.idea"})
public abstract class AbstractKotlinInlineDialog<TDeclaration extends KtNamedDeclaration>
extends InlineOptionsDialog {
    private final int occurrencesNumber;
    private final String kind;
    @NotNull
    private final TDeclaration declaration;
    @Nullable
    private final PsiReference reference;
    @Nullable
    private final Editor editor;

    protected final int getOccurrencesNumber() {
        return this.occurrencesNumber;
    }

    private final String getOccurrencesString() {
        return this.occurrencesNumber >= 0 ? "" + this.occurrencesNumber + " " + StringUtil.pluralize((String)"occurrence", (int)this.occurrencesNumber) : null;
    }

    private final String getRefactoringName() {
        Object[] objectArray = new Object[1];
        String string = StringUtil.capitalizeWords((String)this.kind, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.capitalizeWords(kind, true)");
        objectArray[0] = string;
        return KotlinBundle.message("text.inline.0", objectArray);
    }

    protected boolean canInlineThisOnly() {
        return false;
    }

    protected boolean allowInlineAll() {
        return this.declaration.isWritable();
    }

    @NotNull
    protected String getBorderTitle() {
        return this.getRefactoringName();
    }

    @NotNull
    protected String getNameLabelText() {
        String string;
        block3: {
            block2: {
                string = this.getOccurrencesString();
                if (string == null) break block2;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                string = " - " + it;
                if (string != null) break block3;
            }
            string = "";
        }
        String occurrencesString = string;
        return StringsKt.capitalize((String)this.kind) + ' ' + this.declaration.getNameAsSafeName() + ' ' + occurrencesString;
    }

    /*
     * WARNING - void declaration
     */
    @Nls
    private final String getInlineText(String verb) {
        String string;
        Object[] objectArray;
        String string2;
        block3: {
            block2: {
                void it;
                string2 = "text.inline.all.references.and.verb.0.the.kind.1.occurrences.2";
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = verb;
                objectArray2[1] = this.kind;
                Object[] objectArray3 = objectArray2;
                objectArray = objectArray2;
                int n = 2;
                string = this.getOccurrencesString();
                if (string == null) break block2;
                String string3 = string;
                boolean bl = false;
                boolean bl2 = false;
                String string4 = string3;
                int n2 = n;
                Object[] objectArray4 = objectArray3;
                Object[] objectArray5 = objectArray;
                String string5 = string2;
                boolean bl3 = false;
                String string6 = '(' + (String)it + ')';
                string2 = string5;
                objectArray = objectArray5;
                objectArray3 = objectArray4;
                n = n2;
                string = string6;
                if (string != null) break block3;
            }
            string = "";
        }
        objectArray3[n] = string;
        return KotlinBundle.message(string2, objectArray);
    }

    @NotNull
    protected String getInlineAllText() {
        return this.getInlineText(KotlinBundle.message("text.remove", new Object[0]));
    }

    @Nullable
    protected String getKeepTheDeclarationText() {
        return this.declaration.isWritable() && (this.occurrencesNumber > 1 || !this.myInvokedOnReference) ? this.getInlineText(KotlinBundle.message("text.keep", new Object[0])) : null;
    }

    @NotNull
    protected String getInlineThisText() {
        return KotlinBundle.message("text.inline.this.reference.and.keep.the.0", this.kind);
    }

    @NotNull
    protected final TDeclaration getDeclaration() {
        return this.declaration;
    }

    @Nullable
    protected final PsiReference getReference() {
        return this.reference;
    }

    @Nullable
    protected final Editor getEditor() {
        return this.editor;
    }

    public AbstractKotlinInlineDialog(@NotNull TDeclaration declaration2, @Nullable PsiReference reference2, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter(declaration2, (String)"declaration");
        super(declaration2.getProject(), true, (PsiElement)declaration2);
        this.declaration = declaration2;
        this.reference = reference2;
        this.editor = editor2;
        this.occurrencesNumber = AbstractKotlinInlineDialog.access$initOccurrencesNumber$s759928653((PsiNameIdentifierOwner)this.declaration);
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)((PsiElement)this.declaration), (ElementDescriptionLocation)((ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ElementDescriptionUtil.g\u2026iewTypeLocation.INSTANCE)");
        this.kind = string;
        this.myInvokedOnReference = this.reference != null;
        this.setTitle(this.getRefactoringName());
    }

    public static final /* synthetic */ int access$initOccurrencesNumber$s759928653(PsiNameIdentifierOwner p0) {
        return InlineOptionsDialog.initOccurrencesNumber((PsiNameIdentifierOwner)p0);
    }
}

