/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.ChangeCallableReturnTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeParameterTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeVariableTypeFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u0012\u0010\u0012\u001a\f0\u000e\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\b\u0014H\u0016J#\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0094\u0002J\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "functionLiteralExpression", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtLambdaExpression;Lorg/jetbrains/kotlin/types/KotlinType;)V", "appropriateQuickFix", "Lcom/intellij/codeInsight/intention/IntentionAction;", "functionLiteralReturnTypeRef", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "getFunctionLiteralReturnTypeRef", "()Lorg/jetbrains/kotlin/psi/KtTypeReference;", "typePresentation", "", "typeSourceCode", "createAppropriateQuickFix", "getFamilyName", "getText", "Lcom/intellij/codeInspection/util/IntentionName;", "Lorg/jetbrains/annotations/NotNull;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "Companion", "kotlin.idea"})
public final class ChangeFunctionLiteralReturnTypeFix
extends KotlinQuickFixAction<KtLambdaExpression> {
    private final String typePresentation;
    private final String typeSourceCode;
    private final IntentionAction appropriateQuickFix;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final KtTypeReference getFunctionLiteralReturnTypeRef() {
        KtLambdaExpression ktLambdaExpression = (KtLambdaExpression)this.getElement();
        return ktLambdaExpression != null && (ktLambdaExpression = ktLambdaExpression.getFunctionLiteral()) != null ? ktLambdaExpression.getTypeReference() : null;
    }

    private final IntentionAction createAppropriateQuickFix(KtLambdaExpression functionLiteralExpression, KotlinType type2) {
        KtTypeReference parentFunctionReturnTypeRef;
        KotlinType parentFunctionReturnType;
        KtFunction parentFunction;
        ResolvedCall resolvedCall2;
        KotlinType eventualFunctionLiteralType;
        BindingContext context2;
        block7: {
            KtProperty correspondingProperty;
            block8: {
                context2 = ResolutionUtils.analyze$default((KtElement)((KtElement)functionLiteralExpression), null, (int)1, null);
                KotlinType kotlinType = context2.getType((KtExpression)functionLiteralExpression);
                if (kotlinType == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"context.getType(function\u2026xpression) ?: return null");
                KotlinType functionLiteralType = kotlinType;
                KotlinBuiltIns kotlinBuiltIns = functionLiteralType.getConstructor().getBuiltIns();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinBuiltIns, (String)"functionLiteralType.constructor.builtIns");
                KotlinBuiltIns builtIns = kotlinBuiltIns;
                ClassDescriptor classDescriptor = builtIns.getFunction(functionLiteralType.getArguments().size() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"builtIns.getFunction(fun\u2026lType.arguments.size - 1)");
                ClassDescriptor functionClass = classDescriptor;
                LinkedList<KotlinType> functionClassTypeParameters = new LinkedList<KotlinType>();
                for (TypeProjection typeProjection : functionLiteralType.getArguments()) {
                    functionClassTypeParameters.add(typeProjection.getType());
                }
                functionClassTypeParameters.remove(functionClassTypeParameters.size() - 1);
                functionClassTypeParameters.add(type2);
                KotlinType kotlinType2 = TypeUtils.substituteParameters((ClassDescriptor)functionClass, (List)functionClassTypeParameters);
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"TypeUtils.substitutePara\u2026ctionClassTypeParameters)");
                eventualFunctionLiteralType = kotlinType2;
                correspondingProperty = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)functionLiteralExpression), KtProperty.class);
                if (correspondingProperty == null || correspondingProperty.getDelegate() != null) break block7;
                KtExpression ktExpression = correspondingProperty.getInitializer();
                if (ktExpression == null) break block8;
                KtExpression ktExpression2 = ktExpression;
                boolean bl = false;
                boolean bl2 = false;
                KtExpression it = ktExpression2;
                boolean bl3 = false;
                if (!QuickFixUtil.canEvaluateTo((KtExpression)it, (KtExpression)((KtExpression)functionLiteralExpression))) break block7;
            }
            KtTypeReference correspondingPropertyTypeRef = correspondingProperty.getTypeReference();
            KotlinType propertyType = (KotlinType)context2.get((ReadOnlySlice)BindingContext.TYPE, (Object)correspondingPropertyTypeRef);
            return propertyType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(eventualFunctionLiteralType, propertyType) ? (IntentionAction)new ChangeVariableTypeFix((KtCallableDeclaration)correspondingProperty, eventualFunctionLiteralType) : null;
        }
        if ((resolvedCall2 = CallUtilKt.getParentResolvedCall((KtElement)((KtElement)functionLiteralExpression), (BindingContext)context2, (boolean)true)) != null) {
            Call call = resolvedCall2.getCall();
            Intrinsics.checkNotNullExpressionValue((Object)call, (String)"resolvedCall.call");
            ValueArgument valueArgument = CallUtilKt.getValueArgumentForExpression((Call)call, (KtExpression)((KtExpression)functionLiteralExpression));
            KtParameter correspondingParameter = QuickFixUtil.getParameterDeclarationForValueArgument((ResolvedCall)resolvedCall2, (ValueArgument)valueArgument);
            if (correspondingParameter != null) {
                KtTypeReference correspondingParameterTypeRef = correspondingParameter.getTypeReference();
                KotlinType parameterType = (KotlinType)context2.get((ReadOnlySlice)BindingContext.TYPE, (Object)correspondingParameterTypeRef);
                return parameterType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(eventualFunctionLiteralType, parameterType) ? (IntentionAction)new ChangeParameterTypeFix(correspondingParameter, eventualFunctionLiteralType) : null;
            }
        }
        return (parentFunction = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)functionLiteralExpression), KtFunction.class, (boolean)true)) != null && QuickFixUtil.canFunctionOrGetterReturnExpression((KtDeclaration)((KtDeclaration)parentFunction), (KtExpression)((KtExpression)functionLiteralExpression)) ? (IntentionAction)((parentFunctionReturnType = (KotlinType)context2.get((ReadOnlySlice)BindingContext.TYPE, (Object)(parentFunctionReturnTypeRef = parentFunction.getTypeReference()))) != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(eventualFunctionLiteralType, parentFunctionReturnType) ? new ChangeCallableReturnTypeFix.ForEnclosing(parentFunction, eventualFunctionLiteralType) : null) : null;
    }

    @NotNull
    public String getText() {
        Object object = this.appropriateQuickFix;
        if (object == null || (object = object.getText()) == null) {
            object = KotlinBundle.message("fix.change.return.type.lambda", this.typePresentation);
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"appropriateQuickFix?.tex\u2026ambda\", typePresentation)");
        return object;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("fix.change.return.type.family", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.getFunctionLiteralReturnTypeRef() != null) return true;
        if (this.appropriateQuickFix == null) return false;
        Editor editor3 = editor2;
        Intrinsics.checkNotNull((Object)editor3);
        if (!this.appropriateQuickFix.isAvailable(project2, editor3, (PsiFile)file)) return false;
        return true;
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtTypeReference ktTypeReference = this.getFunctionLiteralReturnTypeRef();
        if (ktTypeReference != null) {
            KtTypeReference ktTypeReference2 = ktTypeReference;
            boolean bl = false;
            boolean bl2 = false;
            KtTypeReference it = ktTypeReference2;
            boolean bl3 = false;
            PsiElement psiElement2 = it.replace((PsiElement)KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)file), (boolean)false, (int)2, null).createType(this.typeSourceCode));
            if (psiElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeReference");
            }
            KtTypeReference newTypeRef = (KtTypeReference)psiElement2;
            ShortenReferences.process$default((ShortenReferences)ShortenReferences.DEFAULT, (KtElement)((KtElement)newTypeRef), null, (int)2, null);
        }
        if (this.appropriateQuickFix != null) {
            Editor editor3 = editor2;
            Intrinsics.checkNotNull((Object)editor3);
            if (this.appropriateQuickFix.isAvailable(project2, editor3, (PsiFile)file)) {
                this.appropriateQuickFix.invoke(project2, editor2, (PsiFile)file);
            }
        }
    }

    public ChangeFunctionLiteralReturnTypeFix(@NotNull KtLambdaExpression functionLiteralExpression, @NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)functionLiteralExpression, (String)"functionLiteralExpression");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        super((PsiElement)functionLiteralExpression);
        this.typePresentation = IdeDescriptorRenderers.SOURCE_CODE_TYPES_WITH_SHORT_NAMES.renderType(type2);
        this.typeSourceCode = IdeDescriptorRenderers.SOURCE_CODE_TYPES.renderType(type2);
        this.appropriateQuickFix = this.createAppropriateQuickFix(functionLiteralExpression, type2);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            KtLambdaExpression ktLambdaExpression = (KtLambdaExpression)QuickFixUtil.getParentElementOfType((Diagnostic)diagnostic, KtLambdaExpression.class);
            if (ktLambdaExpression == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktLambdaExpression, (String)"QuickFixUtil.getParentEl\u2026lass.java) ?: return null");
            KtLambdaExpression functionLiteralExpression = ktLambdaExpression;
            SimpleType simpleType = PlatformKt.getBuiltIns((KtElement)((KtElement)functionLiteralExpression)).getUnitType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"functionLiteralExpression.builtIns.unitType");
            return new ChangeFunctionLiteralReturnTypeFix(functionLiteralExpression, (KotlinType)simpleType);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

