/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.GenerateUtilKt;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspectionKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/VariableDeclarationIntoWhenFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "actionName", "", "subjectExpressionPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "transform", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "(Ljava/lang/String;Lcom/intellij/psi/SmartPsiElementPointer;Lkotlin/jvm/functions/Function1;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.idea"})
final class VariableDeclarationIntoWhenFix
implements LocalQuickFix {
    private final String actionName;
    private final SmartPsiElementPointer<KtExpression> subjectExpressionPointer;
    private final Function1<KtProperty, KtExpression> transform;

    @NotNull
    public String getName() {
        return this.actionName;
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        KtProperty ktProperty;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement2 = descriptor2.getPsiElement();
        if (!(psiElement2 instanceof KtProperty)) {
            psiElement2 = null;
        }
        KtProperty ktProperty2 = (KtProperty)psiElement2;
        if (ktProperty2 == null) {
            return;
        }
        KtProperty property2 = ktProperty2;
        KtExpression ktExpression = (KtExpression)this.subjectExpressionPointer.getElement();
        if (ktExpression == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"subjectExpressionPointer.element ?: return");
        KtExpression subjectExpression = ktExpression;
        KtExpression ktExpression2 = (KtExpression)this.transform.invoke((Object)property2);
        if (ktExpression2 == null || (ktExpression2 = ktExpression2.copy()) == null) {
            return;
        }
        KtExpression newElement = ktExpression2;
        PsiElement lastChild = newElement.getLastChild();
        if (lastChild instanceof PsiComment) {
            ASTNode aSTNode = ((PsiComment)lastChild).getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"lastChild.node");
            if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)KtTokens.EOL_COMMENT)) {
                PsiElement whiteSpaceBeforeComment;
                Object object;
                Object v6;
                PsiElement it;
                block14: {
                    Sequence $this$firstOrNull$iv = PsiUtilsKt.siblings$default((PsiElement)((PsiElement)subjectExpression), (boolean)false, (boolean)false, (int)1, null);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (PsiElement)element$iv;
                        boolean bl = false;
                        ASTNode aSTNode2 = it.getNode();
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"it.node");
                        if (!Intrinsics.areEqual((Object)aSTNode2.getElementType(), (Object)KtTokens.LBRACE)) continue;
                        v6 = element$iv;
                        break block14;
                    }
                    v6 = null;
                }
                PsiElement leftBrace = v6;
                PsiElement psiElement3 = ((PsiComment)lastChild).getPrevSibling();
                if (psiElement3 != null) {
                    PsiElement psiElement4 = psiElement3;
                    boolean bl = false;
                    boolean bl2 = false;
                    it = psiElement4;
                    boolean bl3 = false;
                    object = it instanceof PsiWhiteSpace ? psiElement4 : null;
                } else {
                    object = whiteSpaceBeforeComment = null;
                }
                if (leftBrace != null) {
                    subjectExpression.getParent().addAfter(lastChild, leftBrace);
                    if (whiteSpaceBeforeComment != null) {
                        subjectExpression.getParent().addAfter(whiteSpaceBeforeComment, leftBrace);
                    }
                }
                PsiElement psiElement5 = whiteSpaceBeforeComment;
                if (psiElement5 != null) {
                    psiElement5.delete();
                }
                lastChild.delete();
            }
        }
        PsiElement resultElement = subjectExpression.replace((PsiElement)newElement);
        property2.delete();
        PsiElement psiElement6 = resultElement;
        Intrinsics.checkNotNullExpressionValue((Object)psiElement6, (String)"resultElement");
        Editor editor2 = IntentionBasedInspectionKt.findExistingEditor((PsiElement)psiElement6);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        PsiElement psiElement7 = resultElement;
        if (!(psiElement7 instanceof KtProperty)) {
            psiElement7 = null;
        }
        GenerateUtilKt.moveCaret$default((Editor)editor3, (int)((ktProperty = (KtProperty)psiElement7) != null && (ktProperty = ktProperty.getNameIdentifier()) != null ? PsiUtilsKt.getStartOffset((PsiElement)ktProperty) : PsiUtilsKt.getStartOffset((PsiElement)resultElement)), null, (int)2, null);
    }

    public VariableDeclarationIntoWhenFix(@NotNull String actionName, @NotNull SmartPsiElementPointer<KtExpression> subjectExpressionPointer, @NotNull Function1<? super KtProperty, ? extends KtExpression> transform) {
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        Intrinsics.checkNotNullParameter(subjectExpressionPointer, (String)"subjectExpressionPointer");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        this.actionName = actionName;
        this.subjectExpressionPointer = subjectExpressionPointer;
        this.transform = transform;
    }
}

