/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.KotlinCodeInsightWorkspaceSettings;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.imports.KotlinImportOptimizer;
import org.jetbrains.kotlin.idea.imports.OptimizedImportsBuilder;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.KotlinUnusedImportInspection;
import org.jetbrains.kotlin.idea.references.KtInvokeFunctionReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001b2\u00020\u0001:\u0004\u001b\u001c\u001d\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinUnusedImportInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "optimizeImportsOnTheFly", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "optimizedImports", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "scheduleOptimizeImportsOnTheFly", "data", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$InputData;", "timeToOptimizeImportsOnTheFly", "Companion", "EnableOptimizeImportsOnTheFlyFix", "ImportData", "OptimizeImportsQuickFix", "kotlin.idea"})
public final class KotlinUnusedImportInspection
extends AbstractKotlinInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (!(file instanceof KtFile)) {
            return null;
        }
        ImportData importData = Companion.analyzeImports((KtFile)file);
        if (importData == null) {
            return null;
        }
        ImportData data = importData;
        Iterable $this$map$iv = data.getUnusedImports();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtImportDirective ktImportDirective = (KtImportDirective)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            boolean bl2 = false;
            ArrayList<LocalQuickFixOnPsiElement> fixes = new ArrayList<LocalQuickFixOnPsiElement>();
            fixes.add(new OptimizeImportsQuickFix((KtFile)file));
            Project project2 = ((KtFile)file).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
            if (!KotlinCodeInsightWorkspaceSettings.Companion.getInstance((Project)project2).optimizeImportsOnTheFly) {
                fixes.add(new EnableOptimizeImportsOnTheFlyFix((KtFile)file));
            }
            Collection $this$toTypedArray$iv = fixes;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
            if (localQuickFixArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)it, KotlinBundle.message("unused.import.directive", new Object[0]), isOnTheFly, localQuickFixArray, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            collection.add(problemDescriptor);
        }
        List problems = (List)destination$iv$iv;
        if (isOnTheFly) {
            this.scheduleOptimizeImportsOnTheFly((KtFile)file, data.getOptimizerData());
        }
        Collection $this$toTypedArray$iv = problems;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ProblemDescriptor[] problemDescriptorArray = thisCollection$iv.toArray(new ProblemDescriptor[0]);
        if (problemDescriptorArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return problemDescriptorArray;
    }

    private final void scheduleOptimizeImportsOnTheFly(KtFile file, OptimizedImportsBuilder.InputData data) {
        Project project2 = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
        if (!KotlinCodeInsightWorkspaceSettings.Companion.getInstance((Project)project2).optimizeImportsOnTheFly) {
            return;
        }
        List<ImportPath> list = KotlinImportOptimizer.Companion.prepareOptimizedImports(file, data);
        if (list == null) {
            return;
        }
        List<ImportPath> optimizedImports = list;
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
        Object object = SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)progressManager.getProgressIndicator(), (Function1)scheduleOptimizeImportsOnTheFly.progress.1.INSTANCE));
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator");
        }
        DaemonProgressIndicator progress2 = (DaemonProgressIndicator)object;
        Project project3 = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"file.project");
        Project project4 = project3;
        PsiModificationTracker psiModificationTracker = PsiModificationTracker.SERVICE.getInstance((Project)project4);
        Intrinsics.checkNotNullExpressionValue((Object)psiModificationTracker, (String)"PsiModificationTracker.S\u2026VICE.getInstance(project)");
        long modificationCount = psiModificationTracker.getModificationCount();
        Disposable invokeFixLater2 = new Disposable(this, file, project4, modificationCount, optimizedImports){
            final /* synthetic */ KotlinUnusedImportInspection this$0;
            final /* synthetic */ KtFile $file;
            final /* synthetic */ Project $project;
            final /* synthetic */ long $modificationCount;
            final /* synthetic */ List $optimizedImports;

            public final void dispose() {
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ scheduleOptimizeImportsOnTheFly.invokeFixLater.1 this$0;

                    public final void run() {
                        Editor editor2 = PsiUtilBase.findEditor((PsiElement)((PsiElement)this.this$0.$file));
                        PsiModificationTracker psiModificationTracker = PsiModificationTracker.SERVICE.getInstance((Project)this.this$0.$project);
                        Intrinsics.checkNotNullExpressionValue((Object)psiModificationTracker, (String)"PsiModificationTracker.S\u2026VICE.getInstance(project)");
                        long currentModificationCount = psiModificationTracker.getModificationCount();
                        if (editor2 != null && currentModificationCount == this.this$0.$modificationCount && KotlinUnusedImportInspection.access$timeToOptimizeImportsOnTheFly(this.this$0.this$0, this.this$0.$file, editor2, this.this$0.$project)) {
                            KotlinUnusedImportInspection.access$optimizeImportsOnTheFly(this.this$0.this$0, this.this$0.$file, this.this$0.$optimizedImports, editor2, this.this$0.$project);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = kotlinUnusedImportInspection;
                this.$file = ktFile;
                this.$project = project2;
                this.$modificationCount = l;
                this.$optimizedImports = list;
            }
        };
        if (Disposer.isDisposed((Disposable)((Disposable)progress2))) {
            return;
        }
        Disposer.register((Disposable)((Disposable)progress2), (Disposable)invokeFixLater2);
        if (progress2.isCanceled()) {
            Disposer.dispose((Disposable)invokeFixLater2);
            Disposer.dispose((Disposable)((Disposable)progress2));
            progress2.checkCanceled();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean timeToOptimizeImportsOnTheFly(KtFile file, Editor editor2, Project project2) {
        void hasErrors;
        UndoManager undoManager;
        if (project2.isDisposed() || !file.isValid() || editor2.isDisposed() || !file.isWritable()) {
            return false;
        }
        UndoManager undoManager2 = undoManager = UndoManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)undoManager2, (String)"undoManager");
        if (undoManager2.isUndoInProgress() || undoManager.isRedoInProgress()) {
            return false;
        }
        KtImportList ktImportList = file.getImportList();
        if (ktImportList == null) {
            return false;
        }
        KtImportList importList = ktImportList;
        Object object = SequencesKt.firstOrNull((Sequence)PsiUtilsKt.siblings((PsiElement)((PsiElement)importList), (boolean)false, (boolean)false));
        if (!(object instanceof PsiWhiteSpace)) {
            object = null;
        }
        PsiWhiteSpace leftSpace = (PsiWhiteSpace)object;
        Object object2 = SequencesKt.firstOrNull((Sequence)PsiUtilsKt.siblings((PsiElement)((PsiElement)importList), (boolean)true, (boolean)false));
        if (!(object2 instanceof PsiWhiteSpace)) {
            object2 = null;
        }
        PsiWhiteSpace rightSpace = (PsiWhiteSpace)object2;
        PsiWhiteSpace psiWhiteSpace = leftSpace;
        PsiElement left = psiWhiteSpace != null ? (PsiElement)psiWhiteSpace : (PsiElement)importList;
        PsiWhiteSpace psiWhiteSpace2 = rightSpace;
        PsiElement right = psiWhiteSpace2 != null ? (PsiElement)psiWhiteSpace2 : (PsiElement)importList;
        TextRange textRange = left.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"left.textRange");
        int n = textRange.getStartOffset();
        TextRange textRange2 = right.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"right.textRange");
        TextRange importsRange = new TextRange(n, textRange2.getEndOffset());
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        if (importsRange.containsOffset(caretModel.getOffset())) {
            return false;
        }
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx((Project)project2);
        if (!codeAnalyzer.isHighlightingAvailable((PsiFile)file)) {
            return false;
        }
        if (!codeAnalyzer.isErrorAnalyzingFinished((PsiFile)file)) {
            return false;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        DaemonCodeAnalyzerEx.processHighlights((Document)document2, (Project)project2, (HighlightSeverity)HighlightSeverity.ERROR, (int)0, (int)document2.getTextLength(), (Processor)((Processor)new Processor<HighlightInfo>(importsRange, (Ref.BooleanRef)hasErrors){
            final /* synthetic */ TextRange $importsRange;
            final /* synthetic */ Ref.BooleanRef $hasErrors;

            public final boolean process(HighlightInfo highlightInfo) {
                boolean bl;
                if (!this.$importsRange.containsRange(highlightInfo.startOffset, highlightInfo.endOffset)) {
                    this.$hasErrors.element = true;
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }
            {
                this.$importsRange = textRange;
                this.$hasErrors = booleanRef;
            }
        }));
        if (hasErrors.element) {
            return false;
        }
        return DaemonListeners.canChangeFileSilently((PsiFileSystemItem)((PsiFileSystemItem)file));
    }

    private final void optimizeImportsOnTheFly(KtFile file, List<ImportPath> optimizedImports, Editor editor2, Project project2) {
        PsiDocumentManager.getInstance((Project)file.getProject()).commitAllDocuments();
        DocumentUtil.writeInRunUndoTransparentAction((Runnable)new Runnable(file, optimizedImports, project2, editor2){
            final /* synthetic */ KtFile $file;
            final /* synthetic */ List $optimizedImports;
            final /* synthetic */ Project $project;
            final /* synthetic */ Editor $editor;

            public final void run() {
                KotlinImportOptimizer.Companion.replaceImports(this.$file, this.$optimizedImports);
                PsiDocumentManager.getInstance((Project)this.$project).doPostponedOperationsAndUnblockDocument(this.$editor.getDocument());
            }
            {
                this.$file = ktFile;
                this.$optimizedImports = list;
                this.$project = project2;
                this.$editor = editor2;
            }
        });
    }

    public static final /* synthetic */ boolean access$timeToOptimizeImportsOnTheFly(KotlinUnusedImportInspection $this, KtFile file, Editor editor2, Project project2) {
        return $this.timeToOptimizeImportsOnTheFly(file, editor2, project2);
    }

    public static final /* synthetic */ void access$optimizeImportsOnTheFly(KotlinUnusedImportInspection $this, KtFile file, List optimizedImports, Editor editor2, Project project2) {
        $this.optimizeImportsOnTheFly(file, optimizedImports, editor2, project2);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinUnusedImportInspection$ImportData;", "", "unusedImports", "", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "optimizerData", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$InputData;", "(Ljava/util/List;Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$InputData;)V", "getOptimizerData", "()Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$InputData;", "getUnusedImports", "()Ljava/util/List;", "kotlin.idea"})
    public static final class ImportData {
        @NotNull
        private final List<KtImportDirective> unusedImports;
        @NotNull
        private final OptimizedImportsBuilder.InputData optimizerData;

        @NotNull
        public final List<KtImportDirective> getUnusedImports() {
            return this.unusedImports;
        }

        @NotNull
        public final OptimizedImportsBuilder.InputData getOptimizerData() {
            return this.optimizerData;
        }

        public ImportData(@NotNull List<? extends KtImportDirective> unusedImports, @NotNull OptimizedImportsBuilder.InputData optimizerData) {
            Intrinsics.checkNotNullParameter(unusedImports, (String)"unusedImports");
            Intrinsics.checkNotNullParameter((Object)optimizerData, (String)"optimizerData");
            this.unusedImports = unusedImports;
            this.optimizerData = optimizerData;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\b\u0010\b\u001a\u00020\u0006H\u0016J)\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0096\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinUnusedImportInspection$OptimizeImportsQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "kotlin.idea"})
    private static final class OptimizeImportsQuickFix
    extends LocalQuickFixOnPsiElement {
        @NotNull
        public String getText() {
            return KotlinBundle.message("optimize.imports", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            return string;
        }

        public void invoke(@NotNull Project project2, @NotNull PsiFile file, @NotNull PsiElement startElement2, @NotNull PsiElement endElement2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)startElement2, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement2, (String)"endElement");
            new OptimizeImportsProcessor(project2, file).run();
        }

        public OptimizeImportsQuickFix(@NotNull KtFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super((PsiElement)file);
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016J)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0096\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinUnusedImportInspection$EnableOptimizeImportsOnTheFlyFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "kotlin.idea"})
    private static final class EnableOptimizeImportsOnTheFlyFix
    extends LocalQuickFixOnPsiElement
    implements LowPriorityAction {
        @NotNull
        public String getText() {
            String string = QuickFixBundle.message((String)"enable.optimize.imports.on.the.fly", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"QuickFixBundle.message(\"\u2026mize.imports.on.the.fly\")");
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            return string;
        }

        public void invoke(@NotNull Project project2, @NotNull PsiFile file, @NotNull PsiElement startElement2, @NotNull PsiElement endElement2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)startElement2, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement2, (String)"endElement");
            KotlinCodeInsightWorkspaceSettings.Companion.getInstance((Project)project2).optimizeImportsOnTheFly = true;
            new OptimizeImportsProcessor(project2, file).run();
        }

        public EnableOptimizeImportsOnTheFlyFix(@NotNull KtFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super((PsiElement)file);
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinUnusedImportInspection$Companion;", "", "()V", "analyzeImports", "Lorg/jetbrains/kotlin/idea/inspections/KotlinUnusedImportInspection$ImportData;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.idea"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final ImportData analyzeImports(@NotNull KtFile file) {
            boolean bl;
            void $this$mapNotNullTo$iv$iv;
            Iterable parentFqName;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (file instanceof KtCodeFragment) {
                return null;
            }
            if (!ProjectRootsUtil.isInProjectSource((PsiElement)((PsiElement)file), (boolean)true)) {
                return null;
            }
            if (file.getImportDirectives().isEmpty()) {
                return null;
            }
            OptimizedImportsBuilder.InputData optimizerData = KotlinImportOptimizer.Companion.collectDescriptorsToImport$default(KotlinImportOptimizer.Companion, file, false, 2, null);
            List directives = file.getImportDirectives();
            Set explicitlyImportedFqNames2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)directives), (Function1)analyzeImports.explicitlyImportedFqNames.1.INSTANCE), (Function1)analyzeImports.explicitlyImportedFqNames.2.INSTANCE), (Function1)analyzeImports.explicitlyImportedFqNames.3.INSTANCE));
            Map fqNames = optimizerData.getNamesToImport();
            HashSet<Iterable> parentFqNames = new HashSet<Iterable>();
            for (DeclarationDescriptor descriptor2 : optimizerData.getDescriptorsToImport()) {
                FqName fqName;
                Intrinsics.checkNotNull((Object)ImportsUtils.getImportableFqName((DeclarationDescriptor)descriptor2));
                if (explicitlyImportedFqNames2.contains(fqName)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)fqName.parent(), (String)"fqName.parent()");
                if (parentFqName.isRoot()) continue;
                parentFqNames.add(parentFqName);
            }
            Iterable $this$mapNotNull$iv = optimizerData.getReferences();
            boolean $i$f$mapNotNull = false;
            parentFqName = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                FqName fqName;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object.next();
                boolean bl2 = false;
                OptimizedImportsBuilder.AbstractReference it2 = (OptimizedImportsBuilder.AbstractReference)element$iv$iv;
                boolean bl3 = false;
                KtElement ktElement = it2.getElement();
                if (!(ktElement instanceof KtCallExpression)) {
                    ktElement = null;
                }
                KtCallExpression ktCallExpression = (KtCallExpression)ktElement;
                Object object2 = ktCallExpression != null ? ReferenceUtilsKt.getMainReference((KtReferenceExpression)((KtReferenceExpression)ktCallExpression)) : null;
                if (!(object2 instanceof KtInvokeFunctionReference)) {
                    object2 = null;
                }
                if ((KtInvokeFunctionReference)object2 == null) {
                    fqName = null;
                } else {
                    KtNamedFunction ktNamedFunction;
                    KtInvokeFunctionReference reference2;
                    PsiElement psiElement2 = reference2.resolve();
                    if (!(psiElement2 instanceof KtNamedFunction)) {
                        psiElement2 = null;
                    }
                    fqName = (ktNamedFunction = (KtNamedFunction)psiElement2) != null && (ktNamedFunction = SearchHelpersKt.getDescriptor((KtDeclaration)((KtDeclaration)ktNamedFunction))) != null ? ImportsUtils.getImportableFqName((DeclarationDescriptor)ktNamedFunction) : null;
                }
                if (fqName == null) continue;
                FqName fqName2 = fqName;
                boolean bl4 = false;
                bl = false;
                FqName it$iv$iv = fqName2;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List invokeFunctionCallFqNames = (List)destination$iv$iv;
            HashSet<ImportPath> importPaths = new HashSet<ImportPath>(directives.size());
            ArrayList unusedImports = new ArrayList();
            ResolutionFacade resolutionFacade2 = ResolutionUtils.getResolutionFacade((KtElement)((KtElement)file));
            for (KtImportDirective directive : directives) {
                boolean isUsed;
                boolean bl6;
                ImportPath importPath;
                if (directive.getImportPath() == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)importPath, (String)"directive.importPath ?: continue");
                if (CollectionsKt.contains((Iterable)optimizerData.getUnresolvedNames(), (Object)importPath.getImportedName()) && UtilsKt.targetDescriptors((KtImportDirective)directive, (ResolutionFacade)resolutionFacade2).isEmpty()) {
                    bl6 = true;
                } else if (!importPaths.add(importPath)) {
                    bl6 = false;
                } else if (importPath.isAllUnder()) {
                    object = optimizerData.getUnresolvedNames();
                    boolean bl7 = false;
                    bl6 = !object.isEmpty() || parentFqNames.contains(importPath.getFqName());
                } else {
                    Object it;
                    object = fqNames;
                    FqName fqName = importPath.getFqName();
                    boolean bl8 = false;
                    Object bl2 = object;
                    boolean it2 = false;
                    if (bl2.containsKey(fqName)) {
                        Name name2 = importPath.getImportedName();
                        if (name2 != null) {
                            object = name2;
                            boolean bl9 = false;
                            bl8 = false;
                            it = object;
                            boolean bl10 = false;
                            bl6 = ((Set)MapsKt.getValue((Map)fqNames, (Object)importPath.getFqName())).contains(it);
                        } else {
                            bl6 = false;
                        }
                    } else if (invokeFunctionCallFqNames.contains(importPath.getFqName())) {
                        bl6 = true;
                    } else {
                        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)CollectionsKt.firstOrNull((Iterable)UtilsKt.targetDescriptors((KtImportDirective)directive, (ResolutionFacade)resolutionFacade2));
                        if (declarationDescriptor != null) {
                            object = declarationDescriptor;
                            boolean bl11 = false;
                            bl8 = false;
                            it = object;
                            boolean bl12 = false;
                            Map map2 = fqNames;
                            FqName fqName3 = ImportsUtils.getImportableFqName((DeclarationDescriptor)it);
                            boolean bl13 = false;
                            Map map3 = map2;
                            bl = false;
                            bl6 = map3.containsKey(fqName3);
                        } else {
                            bl6 = false;
                        }
                    }
                }
                if (isUsed = bl6) continue;
                object = unusedImports;
                boolean bl14 = false;
                object.add(directive);
            }
            return new ImportData(unusedImports, optimizerData);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

