/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.idea.caches.KotlinShortNamesCache;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;
import org.jetbrains.kotlin.idea.core.ImportableFqNameClassifierKt;
import org.jetbrains.kotlin.idea.core.KotlinIndicesHelper;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.idea.refactoring.fqName.FqNameUtilKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScopeKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00120\u000bH\u0002J.\u0010\u0015\u001a\u00020\u00122\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00120\u000b2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00120\u000bJ$\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00120\u000bH\u0002J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J\f\u0010\u001f\u001a\u00020\r*\u00020\u0014H\u0002R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/completion/AllClassesCompletion;", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "kotlinIndicesHelper", "Lorg/jetbrains/kotlin/idea/core/KotlinIndicesHelper;", "prefixMatcher", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "kindFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "", "includeTypeAliases", "includeJavaClassesNotToBeUsed", "(Lcom/intellij/codeInsight/completion/CompletionParameters;Lorg/jetbrains/kotlin/idea/core/KotlinIndicesHelper;Lcom/intellij/codeInsight/completion/PrefixMatcher;Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;Lkotlin/jvm/functions/Function1;ZZ)V", "addAdaptedJavaCompletion", "", "collector", "Lcom/intellij/psi/PsiClass;", "collect", "classifierDescriptorCollector", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;", "javaClassCollector", "collectClassesFromScope", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isNotToBeUsed", "javaClass", "isSyntheticKotlinClass", "kotlin.idea"})
public final class AllClassesCompletion {
    private final CompletionParameters parameters;
    private final KotlinIndicesHelper kotlinIndicesHelper;
    private final PrefixMatcher prefixMatcher;
    private final ResolutionFacade resolutionFacade;
    private final Function1<ClassKind, Boolean> kindFilter;
    private final boolean includeTypeAliases;
    private final boolean includeJavaClassesNotToBeUsed;

    public final void collect(@NotNull Function1<? super ClassifierDescriptorWithTypeParameters, Unit> classifierDescriptorCollector2, @NotNull Function1<? super PsiClass, Unit> javaClassCollector2) {
        ClassDescriptor it;
        Intrinsics.checkNotNullParameter(classifierDescriptorCollector2, (String)"classifierDescriptorCollector");
        Intrinsics.checkNotNullParameter(javaClassCollector2, (String)"javaClassCollector");
        for (PackageViewDescriptor builtInPackage : this.resolutionFacade.getModuleDescriptor().getBuiltIns().getBuiltInPackagesImportedByDefault()) {
            this.collectClassesFromScope(builtInPackage.getMemberScope(), (Function1<? super ClassDescriptor, Unit>)((Function1)new Function1<ClassDescriptor, Unit>(classifierDescriptorCollector2){
                final /* synthetic */ Function1 $classifierDescriptorCollector;

                public final void invoke(@NotNull ClassDescriptor it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (it.getContainingDeclaration() instanceof ClassDescriptor) {
                        this.$classifierDescriptorCollector.invoke((Object)it);
                    }
                }
                {
                    this.$classifierDescriptorCollector = function1;
                    super(1);
                }
            }));
        }
        Iterable $this$forEach$iv = KotlinIndicesHelper.getKotlinClasses$default((KotlinIndicesHelper)this.kotlinIndicesHelper, (Function1)((Function1)new Function1<String, Boolean>(this){
            final /* synthetic */ AllClassesCompletion this$0;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AllClassesCompletion.access$getPrefixMatcher$p(this.this$0).prefixMatches(it);
            }
            {
                this.this$0 = allClassesCompletion;
                super(1);
            }
        }), null, this.kindFilter, (int)2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ClassDescriptor)element$iv;
            boolean bl = false;
            classifierDescriptorCollector2.invoke((Object)it);
        }
        if (this.includeTypeAliases) {
            $this$forEach$iv = this.kotlinIndicesHelper.getTopLevelTypeAliases(CompletionUtilsKt.asStringNameFilter(this.prefixMatcher));
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (TypeAliasDescriptor)element$iv;
                boolean bl = false;
                classifierDescriptorCollector2.invoke((Object)it);
            }
        }
        PsiFile psiFile = this.parameters.getOriginalFile();
        if (psiFile == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        if (JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetector.getPlatform((KtFile)((KtFile)psiFile)))) {
            this.addAdaptedJavaCompletion(javaClassCollector2);
        }
    }

    private final void collectClassesFromScope(MemberScope scope2, Function1<? super ClassDescriptor, Unit> collector2) {
        for (DeclarationDescriptor descriptor2 : MemberScopeKt.getDescriptorsFiltered$default((MemberScope)scope2, (DescriptorKindFilter)DescriptorKindFilter.CLASSIFIERS, null, (int)2, null)) {
            if (!(descriptor2 instanceof ClassDescriptor)) continue;
            ClassKind classKind = ((ClassDescriptor)descriptor2).getKind();
            Intrinsics.checkNotNullExpressionValue((Object)classKind, (String)"descriptor.kind");
            if (((Boolean)this.kindFilter.invoke((Object)classKind)).booleanValue() && this.prefixMatcher.prefixMatches(((ClassDescriptor)descriptor2).getName().asString())) {
                collector2.invoke((Object)descriptor2);
            }
            MemberScope memberScope = ((ClassDescriptor)descriptor2).getUnsubstitutedInnerClassesScope();
            Intrinsics.checkNotNullExpressionValue((Object)memberScope, (String)"descriptor.unsubstitutedInnerClassesScope");
            this.collectClassesFromScope(memberScope, collector2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void addAdaptedJavaCompletion(Function1<? super PsiClass, Unit> collector2) {
        Object object;
        KotlinShortNamesCache shortNamesCache;
        Object object2;
        Object object3;
        block4: {
            Editor editor2 = this.parameters.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"parameters.editor");
            Object[] objectArray = PsiShortNamesCache.EP_NAME.getExtensions((AreaInstance)editor2.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"PsiShortNamesCache.EP_NA\u2026arameters.editor.project)");
            Object[] $this$firstOrNull$iv = objectArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiShortNamesCache it = (PsiShortNamesCache)element$iv;
                boolean bl = false;
                if (!(it instanceof KotlinShortNamesCache)) continue;
                object3 = element$iv;
                break block4;
            }
            object3 = null;
        }
        if ((object2 = (shortNamesCache = (KotlinShortNamesCache)object3)) != null && (object2 = object2.getDisableSearch()) != null) {
            ((ThreadLocal)object2).set(true);
        }
        try {
            AllClassesGetter.processJavaClasses((CompletionParameters)this.parameters, (PrefixMatcher)this.prefixMatcher, (boolean)true, (Consumer)((Consumer)new Consumer<PsiClass>(this, collector2){
                final /* synthetic */ AllClassesCompletion this$0;
                final /* synthetic */ Function1 $collector;

                public final void consume(PsiClass psiClass2) {
                    PsiClass psiClass3 = psiClass2;
                    Intrinsics.checkNotNull((Object)psiClass3);
                    if (!(psiClass3 instanceof KtLightClass)) {
                        ClassKind kind;
                        if (AllClassesCompletion.access$isSyntheticKotlinClass(this.this$0, psiClass2)) {
                            return;
                        }
                        ClassKind classKind = psiClass2.isAnnotationType() ? ClassKind.ANNOTATION_CLASS : (psiClass2.isInterface() ? ClassKind.INTERFACE : (kind = psiClass2.isEnum() ? ClassKind.ENUM_CLASS : ClassKind.CLASS));
                        if (((Boolean)AllClassesCompletion.access$getKindFilter$p(this.this$0).invoke((Object)kind)).booleanValue() && !AllClassesCompletion.access$isNotToBeUsed(this.this$0, psiClass2)) {
                            this.$collector.invoke((Object)psiClass2);
                        }
                    }
                }
                {
                    this.this$0 = allClassesCompletion;
                    this.$collector = function1;
                }
            }));
            object = shortNamesCache;
            if (object == null || (object = object.getDisableSearch()) == null) return;
        }
        catch (Throwable throwable) {
            Object object4 = shortNamesCache;
            if (object4 == null || (object4 = object4.getDisableSearch()) == null) throw throwable;
            ((ThreadLocal)object4).set(false);
            throw throwable;
        }
        ((ThreadLocal)object).set(false);
    }

    private final boolean isSyntheticKotlinClass(PsiClass $this$isSyntheticKotlinClass) {
        PsiAnnotation metadata;
        String string = $this$isSyntheticKotlinClass.getName();
        Intrinsics.checkNotNull((Object)string);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name!!");
        if (!StringsKt.contains$default((CharSequence)string, (char)'$', (boolean)false, (int)2, null)) {
            return false;
        }
        PsiModifierList psiModifierList = $this$isSyntheticKotlinClass.getModifierList();
        PsiAnnotation psiAnnotation = metadata = psiModifierList != null ? psiModifierList.findAnnotation(JvmAnnotationNames.METADATA_FQ_NAME.asString()) : null;
        Object object = psiAnnotation != null ? psiAnnotation.findAttributeValue("k") : null;
        if (!(object instanceof PsiLiteral)) {
            object = null;
        }
        PsiLiteral psiLiteral = (PsiLiteral)object;
        return Intrinsics.areEqual((Object)(psiLiteral != null ? psiLiteral.getValue() : null), (Object)KotlinClassHeader.Kind.SYNTHETIC_CLASS.getId());
    }

    private final boolean isNotToBeUsed(PsiClass javaClass) {
        if (this.includeJavaClassesNotToBeUsed) {
            return false;
        }
        FqName fqName = FqNameUtilKt.getKotlinFqName((PsiElement)((PsiElement)javaClass));
        return fqName != null && ImportableFqNameClassifierKt.isJavaClassNotToBeUsedInKotlin((FqName)fqName);
    }

    public AllClassesCompletion(@NotNull CompletionParameters parameters2, @NotNull KotlinIndicesHelper kotlinIndicesHelper, @NotNull PrefixMatcher prefixMatcher, @NotNull ResolutionFacade resolutionFacade2, @NotNull Function1<? super ClassKind, Boolean> kindFilter, boolean includeTypeAliases, boolean includeJavaClassesNotToBeUsed) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)kotlinIndicesHelper, (String)"kotlinIndicesHelper");
        Intrinsics.checkNotNullParameter((Object)prefixMatcher, (String)"prefixMatcher");
        Intrinsics.checkNotNullParameter((Object)resolutionFacade2, (String)"resolutionFacade");
        Intrinsics.checkNotNullParameter(kindFilter, (String)"kindFilter");
        this.parameters = parameters2;
        this.kotlinIndicesHelper = kotlinIndicesHelper;
        this.prefixMatcher = prefixMatcher;
        this.resolutionFacade = resolutionFacade2;
        this.kindFilter = kindFilter;
        this.includeTypeAliases = includeTypeAliases;
        this.includeJavaClassesNotToBeUsed = includeJavaClassesNotToBeUsed;
    }

    public static final /* synthetic */ PrefixMatcher access$getPrefixMatcher$p(AllClassesCompletion $this) {
        return $this.prefixMatcher;
    }

    public static final /* synthetic */ boolean access$isSyntheticKotlinClass(AllClassesCompletion $this, PsiClass $this$access_u24isSyntheticKotlinClass) {
        return $this.isSyntheticKotlinClass($this$access_u24isSyntheticKotlinClass);
    }

    public static final /* synthetic */ boolean access$isNotToBeUsed(AllClassesCompletion $this, PsiClass javaClass) {
        return $this.isNotToBeUsed(javaClass);
    }

    public static final /* synthetic */ Function1 access$getKindFilter$p(AllClassesCompletion $this) {
        return $this.kindFilter;
    }
}

