/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.hints;

import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiElement;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.hints.HintType;
import org.jetbrains.kotlin.idea.codeInsight.hints.HintsCompatKt;
import org.jetbrains.kotlin.idea.codeInsight.hints.KotlinAbstractHintsProvider;
import org.jetbrains.kotlin.idea.codeInsight.hints.KotlinLambdasHintsProvider$WhenMappings;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001e\u001fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\b\u0010\r\u001a\u00020\u0002H\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J&\u0010\u0016\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u001a\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/hints/KotlinLambdasHintsProvider;", "Lorg/jetbrains/kotlin/idea/codeInsight/hints/KotlinAbstractHintsProvider;", "Lorg/jetbrains/kotlin/idea/codeInsight/hints/KotlinLambdasHintsProvider$Settings;", "()V", "name", "", "getName", "()Ljava/lang/String;", "previewText", "getPreviewText", "createConfigurable", "Lcom/intellij/codeInsight/hints/ImmediateConfigurable;", "settings", "createSettings", "handleAfterLineEndHintsRemoval", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "resolved", "Lorg/jetbrains/kotlin/idea/codeInsight/hints/HintType;", "element", "Lcom/intellij/psi/PsiElement;", "handlePresentations", "presentations", "", "Lorg/jetbrains/kotlin/idea/codeInsight/hints/KotlinAbstractHintsProvider$PresentationAndSettings;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "isElementSupported", "", "LambdaHintsRenderer", "Settings", "kotlin.idea"})
public final class KotlinLambdasHintsProvider
extends KotlinAbstractHintsProvider<Settings> {
    @NotNull
    private final String name = KotlinBundle.message("hints.settings.lambdas", new Object[0]);
    @Nullable
    private final String previewText;

    @NotNull
    public String getName() {
        return this.name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isElementSupported(@Nullable HintType resolved, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        HintType hintType = resolved;
        if (hintType == null) return false;
        switch (KotlinLambdasHintsProvider$WhenMappings.$EnumSwitchMapping$0[hintType.ordinal()]) {
            case 1: {
                boolean bl = settings.getReturnExpressions();
                return bl;
            }
            case 2: {
                boolean bl = settings.getImplicitReceiversAndParams();
                return bl;
            }
            default: {
                return false;
            }
        }
    }

    @Override
    protected void handlePresentations(@NotNull List<KotlinAbstractHintsProvider.PresentationAndSettings> presentations, @NotNull Editor editor2, @NotNull InlayHintsSink sink) {
        Intrinsics.checkNotNullParameter(presentations, (String)"presentations");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        boolean $i$f$invokeLater = false;
        ApplicationManager.getApplication().invokeLater(new Runnable(presentations, editor2){
            final /* synthetic */ List $presentations$inlined;
            final /* synthetic */ Editor $editor$inlined;
            {
                this.$presentations$inlined = list;
                this.$editor$inlined = editor2;
            }

            /*
             * WARNING - void declaration
             */
            public final void run() {
                boolean bl = false;
                Iterable $this$forEach$iv = this.$presentations$inlined;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    void $this$forEach$iv2;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    KotlinAbstractHintsProvider.PresentationAndSettings p = (KotlinAbstractHintsProvider.PresentationAndSettings)element$iv;
                    boolean bl2 = false;
                    int logicalLine = this.$editor$inlined.offsetToLogicalPosition((int)p.getOffset()).line;
                    List list = this.$editor$inlined.getInlayModel().getAfterLineEndElementsForLogicalLine(logicalLine);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"editor.inlayModel.getAft\u2026rLogicalLine(logicalLine)");
                    Iterable iterable = list;
                    boolean $i$f$filter = false;
                    Iterator<T> iterator = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        Inlay it = (Inlay)element$iv$iv;
                        boolean bl3 = false;
                        Inlay inlay = it;
                        Intrinsics.checkNotNullExpressionValue((Object)inlay, (String)"it");
                        if (!(inlay.getRenderer() instanceof LambdaHintsRenderer)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        Inlay it = (Inlay)element$iv2;
                        boolean bl4 = false;
                        it.dispose();
                    }
                    this.$editor$inlined.getInlayModel().addAfterLineEndElement(p.getOffset(), p.getRelatesToPrecedingText(), (EditorCustomElementRenderer)new LambdaHintsRenderer(p.getPresentation()));
                }
            }
        });
    }

    @Override
    protected void handleAfterLineEndHintsRemoval(@NotNull Editor editor2, @NotNull HintType resolved, @NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)resolved), (String)"resolved");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        boolean $i$f$invokeLater = false;
        ApplicationManager.getApplication().invokeLater(new Runnable(resolved, element3, editor2){
            final /* synthetic */ HintType $resolved$inlined;
            final /* synthetic */ PsiElement $element$inlined;
            final /* synthetic */ Editor $editor$inlined;
            {
                this.$resolved$inlined = hintType;
                this.$element$inlined = psiElement2;
                this.$editor$inlined = editor2;
            }

            /*
             * WARNING - void declaration
             */
            public final void run() {
                block11: {
                    void $this$forEach$iv;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    Integer offset;
                    Integer n;
                    boolean bl = false;
                    switch (KotlinLambdasHintsProvider$WhenMappings.$EnumSwitchMapping$1[this.$resolved$inlined.ordinal()]) {
                        case 1: {
                            KtLambdaExpression lambdaExpression2;
                            KtLambdaExpression ktLambdaExpression;
                            PsiElement psiElement2 = this.$element$inlined;
                            if (!(psiElement2 instanceof KtFunctionLiteral)) {
                                psiElement2 = null;
                            }
                            KtFunctionLiteral ktFunctionLiteral = (KtFunctionLiteral)psiElement2;
                            Object object = ktFunctionLiteral != null ? ktFunctionLiteral.getParent() : null;
                            if (!(object instanceof KtLambdaExpression)) {
                                object = null;
                            }
                            if ((ktLambdaExpression = (lambdaExpression2 = (KtLambdaExpression)object)) != null && (ktLambdaExpression = ktLambdaExpression.getLeftCurlyBrace()) != null && (ktLambdaExpression = ktLambdaExpression.getTextRange()) != null) {
                                n = ktLambdaExpression.getEndOffset();
                                break;
                            }
                            n = null;
                            break;
                        }
                        case 2: {
                            PsiElement psiElement3 = this.$element$inlined;
                            if (!(psiElement3 instanceof KtExpression)) {
                                psiElement3 = null;
                            }
                            KtExpression ktExpression = (KtExpression)psiElement3;
                            if (ktExpression != null) {
                                n = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktExpression));
                                break;
                            }
                            n = null;
                            break;
                        }
                        default: {
                            n = null;
                        }
                    }
                    Integer n2 = offset = n;
                    if (n2 == null) break block11;
                    Integer n3 = n2;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    int it = ((Number)n3).intValue();
                    boolean bl4 = false;
                    int logicalLine = this.$editor$inlined.offsetToLogicalPosition((int)offset.intValue()).line;
                    List list = this.$editor$inlined.getInlayModel().getAfterLineEndElementsForLogicalLine(logicalLine);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"editor.inlayModel.getAft\u2026rLogicalLine(logicalLine)");
                    Iterable iterable = list;
                    boolean $i$f$filter = false;
                    Iterator<T> iterator = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        Inlay it2 = (Inlay)element$iv$iv;
                        boolean bl5 = false;
                        Inlay inlay = it2;
                        Intrinsics.checkNotNullExpressionValue((Object)inlay, (String)"it");
                        if (!(inlay.getRenderer() instanceof LambdaHintsRenderer)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Inlay it3 = (Inlay)element$iv;
                        boolean bl6 = false;
                        it3.dispose();
                    }
                }
            }
        });
    }

    @NotNull
    public ImmediateConfigurable createConfigurable(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return HintsCompatKt.createLambdaHintsImmediateConfigurable(settings);
    }

    @NotNull
    public Settings createSettings() {
        return new Settings(false, false, 3, null);
    }

    @Override
    @Nullable
    public String getPreviewText() {
        return this.previewText;
    }

    public KotlinLambdasHintsProvider() {
        this.previewText = "val lambda = { i: Int ->\n    i + 10\n    i + 20\n}\n\nfun someFun() {    \n    GlobalScope.launch {\n        // someSuspendingFun()\n    }\n}";
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/hints/KotlinLambdasHintsProvider$Settings;", "", "returnExpressions", "", "implicitReceiversAndParams", "(ZZ)V", "getImplicitReceiversAndParams", "()Z", "setImplicitReceiversAndParams", "(Z)V", "getReturnExpressions", "setReturnExpressions", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "kotlin.idea"})
    public static final class Settings {
        private boolean returnExpressions;
        private boolean implicitReceiversAndParams;

        public final boolean getReturnExpressions() {
            return this.returnExpressions;
        }

        public final void setReturnExpressions(boolean bl) {
            this.returnExpressions = bl;
        }

        public final boolean getImplicitReceiversAndParams() {
            return this.implicitReceiversAndParams;
        }

        public final void setImplicitReceiversAndParams(boolean bl) {
            this.implicitReceiversAndParams = bl;
        }

        public Settings(boolean returnExpressions, boolean implicitReceiversAndParams) {
            this.returnExpressions = returnExpressions;
            this.implicitReceiversAndParams = implicitReceiversAndParams;
        }

        public /* synthetic */ Settings(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            if ((n & 2) != 0) {
                bl2 = true;
            }
            this(bl, bl2);
        }

        public Settings() {
            this(false, false, 3, null);
        }

        public final boolean component1() {
            return this.returnExpressions;
        }

        public final boolean component2() {
            return this.implicitReceiversAndParams;
        }

        @NotNull
        public final Settings copy(boolean returnExpressions, boolean implicitReceiversAndParams) {
            return new Settings(returnExpressions, implicitReceiversAndParams);
        }

        public static /* synthetic */ Settings copy$default(Settings settings, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = settings.returnExpressions;
            }
            if ((n & 2) != 0) {
                bl2 = settings.implicitReceiversAndParams;
            }
            return settings.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "Settings(returnExpressions=" + this.returnExpressions + ", implicitReceiversAndParams=" + this.implicitReceiversAndParams + ")";
        }

        public int hashCode() {
            int n = this.returnExpressions ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int n2 = n * 31;
            int n3 = this.implicitReceiversAndParams ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            return n2 + n3;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Settings)) break block3;
                    Settings settings = (Settings)object;
                    if (this.returnExpressions != settings.returnExpressions || this.implicitReceiversAndParams != settings.implicitReceiversAndParams) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J,\u0010\r\u001a\u00020\u000e2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/hints/KotlinLambdasHintsProvider$LambdaHintsRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "presentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "(Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;)V", "delegate", "Lcom/intellij/codeInsight/hints/presentation/PresentationRenderer;", "calcWidthInPixels", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "getContextMenuGroupId", "", "paint", "", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "toString", "kotlin.idea"})
    private static final class LambdaHintsRenderer
    implements EditorCustomElementRenderer {
        private final PresentationRenderer delegate;

        public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            this.delegate.paint(inlay, g, targetRegion, textAttributes);
        }

        public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            return this.delegate.calcWidthInPixels(inlay);
        }

        @NotNull
        public String getContextMenuGroupId(@NotNull Inlay<?> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            return "DummyActionGroup";
        }

        @NotNull
        public String toString() {
            return this.delegate.toString();
        }

        public LambdaHintsRenderer(@NotNull InlayPresentation presentation) {
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            this.delegate = new PresentationRenderer(presentation);
        }
    }
}

