/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.ProjectTopics;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.KotlinPluginCompatibilityVerifier;
import org.jetbrains.kotlin.idea.PluginStartupService;
import org.jetbrains.kotlin.idea.StartupCompatKt;
import org.jetbrains.kotlin.idea.configuration.ui.notifications.NewCodeStyleNotificationKt;
import org.jetbrains.kotlin.idea.reporter.KotlinReportSubmitter;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.resolve.jvm.KotlinJavaPsiFacade;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.konan.diagnostics.ErrorsNative;

public class PluginStartupActivity
implements StartupActivity {
    private static final Logger LOG = Logger.getInstance(PluginStartupActivity.class);

    public void runActivity(final @NotNull Project project2) {
        if (project2 == null) {
            PluginStartupActivity.$$$reportNull$$$0(0);
        }
        StartupCompatKt.runActivity(project2);
        PluginStartupService.Companion.getInstance(project2).register(project2);
        project2.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                KotlinJavaPsiFacade.getInstance((Project)project2).clearPackageCaches();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/idea/PluginStartupActivity$1", "rootsChanged"));
            }
        });
        PluginStartupActivity.initializeDiagnostics();
        try {
            UpdateChecker.INSTANCE.getExcludedFromUpdateCheckPlugins().add("org.jetbrains.kotlin");
        }
        catch (Throwable throwable) {
            LOG.debug("Excluding Kotlin plugin updates using old API", throwable);
            UpdateChecker.getDisabledToUpdate().add(PluginId.getId((String)"org.jetbrains.kotlin"));
        }
        KotlinPluginCompatibilityVerifier.checkCompatibility();
        KotlinReportSubmitter.Companion.setupReportingFromRelease();
        NewCodeStyleNotificationKt.notifyKotlinStyleUpdateIfNeeded(project2);
    }

    private static void initializeDiagnostics() {
        PluginStartupActivity.consumeFactory(Errors.DEPRECATION);
        PluginStartupActivity.consumeFactory(ErrorsJvm.ACCIDENTAL_OVERRIDE);
        PluginStartupActivity.consumeFactory(ErrorsJs.CALL_FROM_UMD_MUST_BE_JS_MODULE_AND_JS_NON_MODULE);
        PluginStartupActivity.consumeFactory(ErrorsNative.INCOMPATIBLE_THROWS_INHERITED);
    }

    private static void consumeFactory(DiagnosticFactory<?> factory2) {
        factory2.getClass();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/PluginStartupActivity", "runActivity"));
    }
}

