/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleSMTestProxy;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public class BeforeSuiteEvent
extends AbstractTestEvent {
    public BeforeSuiteEvent(GradleTestsExecutionConsole executionConsole) {
        super(executionConsole);
    }

    @Override
    public void process(@NotNull TestEventXmlView eventXml) throws TestEventXmlView.XmlParserException {
        String testId = eventXml.getTestId();
        String parentTestId = eventXml.getTestParentId();
        String name = eventXml.getTestName();
        String fqClassName = eventXml.getTestClassName();
        if (StringUtil.isEmpty((String)parentTestId)) {
            this.registerTestProxy(testId, (SMTestProxy)this.getResultsViewer().getTestsRootNode());
        } else {
            SMTestProxy parentTest = this.findTestProxy(parentTestId);
            if (this.isHiddenTestNode(name, parentTest)) {
                this.registerTestProxy(testId, parentTest);
            } else {
                SMTestProxy testProxy;
                boolean combineTestsOfTheSameSuite = !this.showInternalTestNodes();
                String sameSuiteId = name + fqClassName;
                if (combineTestsOfTheSameSuite && (testProxy = this.findTestProxy(sameSuiteId)) instanceof GradleSMTestProxy && Objects.equals(testProxy.getParent(), parentTest)) {
                    this.registerTestProxy(testId, testProxy);
                    if (!testProxy.isInProgress()) {
                        testProxy.setStarted();
                    }
                    return;
                }
                String locationUrl = this.findLocationUrl(null, fqClassName);
                GradleSMTestProxy testProxy2 = new GradleSMTestProxy(name, true, locationUrl, null);
                testProxy2.setLocator(this.getExecutionConsole().getUrlProvider());
                testProxy2.setParentId(parentTestId);
                testProxy2.setStarted();
                this.registerTestProxy(testId, testProxy2);
                if (combineTestsOfTheSameSuite) {
                    this.registerTestProxy(sameSuiteId, testProxy2);
                }
            }
        }
    }

    @Override
    @NotNull
    protected String findLocationUrl(@Nullable String name, @NotNull String fqClassName) {
        return name == null ? "java:suite://" + fqClassName : "java:suite://" + StringUtil.getQualifiedName((String)fqClassName, (String)name);
    }

    private boolean isHiddenTestNode(String name, SMTestProxy parentTest) {
        return parentTest != null && !this.showInternalTestNodes() && StringUtil.startsWith((CharSequence)name, (CharSequence)"Gradle Test Executor");
    }
}

