/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.TestData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestTasksProvider;
import org.jetbrains.plugins.gradle.execution.test.runner.TestGradleConfigurationProducerUtilKt;
import org.jetbrains.plugins.gradle.execution.test.runner.TestTasksChooser;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.TestRunner;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;
import org.jetbrains.plugins.gradle.util.TasksToRun;

public abstract class GradleTestRunConfigurationProducer
extends RunConfigurationProducer<ExternalSystemRunConfiguration> {
    private static final List<String> TEST_SOURCE_SET_TASKS = Collections.singletonList("test");
    protected static final Logger LOG = Logger.getInstance(GradleTestRunConfigurationProducer.class);
    private TestTasksChooser testTasksChooser = new TestTasksChooser();

    @Deprecated
    protected GradleTestRunConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    protected GradleTestRunConfigurationProducer() {
        super(true);
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        TestRunner testRunner = GradleTestRunConfigurationProducer.getTestRunner(self.getSourceElement());
        return testRunner == TestRunner.CHOOSE_PER_TEST || testRunner == TestRunner.GRADLE;
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        return GradleTestRunConfigurationProducer.getTestRunner(self.getSourceElement()) == TestRunner.GRADLE;
    }

    protected boolean setupConfigurationFromContext(@NotNull ExternalSystemRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        if (!GradleConstants.SYSTEM_ID.equals((Object)configuration.getSettings().getExternalSystemId())) {
            return false;
        }
        if (sourceElement.isNull()) {
            return false;
        }
        TestRunner testRunner = GradleTestRunConfigurationProducer.getTestRunner((PsiElement)sourceElement.get());
        if (testRunner == TestRunner.PLATFORM) {
            return false;
        }
        if (configuration instanceof GradleRunConfiguration) {
            GradleRunConfiguration gradleRunConfiguration = (GradleRunConfiguration)configuration;
            gradleRunConfiguration.setScriptDebugEnabled(false);
        }
        boolean result = this.doSetupConfigurationFromContext(configuration, context, sourceElement);
        this.restoreDefaultScriptParametersIfNeeded((RunConfiguration)configuration, context);
        return result;
    }

    protected Runnable addCheckForTemplateParams(@NotNull ConfigurationFromContext configuration, @NotNull ConfigurationContext context, @NotNull Runnable startRunnable) {
        return () -> {
            this.restoreDefaultScriptParametersIfNeeded(configuration.getConfiguration(), context);
            startRunnable.run();
        };
    }

    protected void restoreDefaultScriptParametersIfNeeded(@NotNull RunConfiguration configuration, @NotNull ConfigurationContext context) {
        RunnerAndConfigurationSettings template = context.getRunManager().getConfigurationTemplate(this.getConfigurationFactory());
        RunConfiguration original = template.getConfiguration();
        if (original instanceof ExternalSystemRunConfiguration && configuration instanceof ExternalSystemRunConfiguration) {
            ExternalSystemRunConfiguration originalRC = (ExternalSystemRunConfiguration)original;
            ExternalSystemRunConfiguration configurationRC = (ExternalSystemRunConfiguration)configuration;
            String currentParams = configurationRC.getSettings().getScriptParameters();
            String defaultParams = originalRC.getSettings().getScriptParameters();
            if (!StringUtil.isEmptyOrSpaces((String)defaultParams)) {
                if (!StringUtil.isEmptyOrSpaces((String)currentParams)) {
                    configurationRC.getSettings().setScriptParameters(currentParams + " " + defaultParams);
                } else {
                    configurationRC.getSettings().setScriptParameters(defaultParams);
                }
            }
        }
    }

    protected abstract boolean doSetupConfigurationFromContext(ExternalSystemRunConfiguration var1, ConfigurationContext var2, Ref<PsiElement> var3);

    public boolean isConfigurationFromContext(@NotNull ExternalSystemRunConfiguration configuration, @NotNull ConfigurationContext context) {
        if (!GradleConstants.SYSTEM_ID.equals((Object)configuration.getSettings().getExternalSystemId())) {
            return false;
        }
        String projectPath = configuration.getSettings().getExternalProjectPath();
        TestRunner testRunner = GradleTestRunConfigurationProducer.getTestRunner(context.getProject(), projectPath);
        if (testRunner == TestRunner.PLATFORM) {
            return false;
        }
        return this.doIsConfigurationFromContext(configuration, context);
    }

    protected abstract boolean doIsConfigurationFromContext(ExternalSystemRunConfiguration var1, ConfigurationContext var2);

    @Nullable
    protected String resolveProjectPath(@NotNull Module module) {
        return GradleRunnerUtil.resolveProjectPath(module);
    }

    protected TestTasksChooser getTestTasksChooser() {
        return this.testTasksChooser;
    }

    public void setTestTasksChooser(TestTasksChooser testTasksChooser) {
        this.testTasksChooser = testTasksChooser;
    }

    public static boolean hasTasksInConfiguration(VirtualFile source, Project project, ExternalSystemTaskExecutionSettings settings) {
        List<TasksToRun> tasksToRun = GradleTestRunConfigurationProducer.findAllTestsTaskToRun(source, project);
        List escapedTasks = ContainerUtil.map(tasksToRun, tasks -> ContainerUtil.map((Collection)tasks, it -> TestGradleConfigurationProducerUtilKt.escapeIfNeeded(it)));
        List taskNames = settings.getTaskNames();
        if (escapedTasks.stream().anyMatch(taskNames::containsAll)) {
            return true;
        }
        String scriptParameters = settings.getScriptParameters();
        if (StringUtil.isEmpty((String)scriptParameters)) {
            return false;
        }
        List escapedJoinedTasks = ContainerUtil.map((Collection)escapedTasks, it -> StringUtil.join((Collection)it, (String)" "));
        return escapedJoinedTasks.stream().anyMatch(scriptParameters::contains);
    }

    @NotNull
    public static TasksToRun findTestsTaskToRun(@NotNull VirtualFile source, @NotNull Project project) {
        List<TasksToRun> tasksToRun = GradleTestRunConfigurationProducer.findAllTestsTaskToRun(source, project);
        if (tasksToRun.isEmpty()) {
            return TasksToRun.EMPTY;
        }
        return tasksToRun.get(0);
    }

    @NotNull
    public static List<TasksToRun> findAllTestsTaskToRun(@NotNull VirtualFile source, @NotNull Project project) {
        String sourcePath = source.getPath();
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        Module module = projectFileIndex.getModuleForFile(source);
        if (module == null) {
            return Collections.emptyList();
        }
        ArrayList<TasksToRun> testTasks = new ArrayList<TasksToRun>();
        for (GradleTestTasksProvider provider : (GradleTestTasksProvider[])GradleTestTasksProvider.EP_NAME.getExtensions()) {
            List<String> tasks = provider.getTasks(module, source);
            if (ContainerUtil.isEmpty(tasks)) continue;
            String testName = StringUtil.join(tasks, (String)" ");
            testTasks.add(new TasksToRun.Impl(testName, tasks));
        }
        DataNode moduleDataNode = GradleUtil.findGradleModuleData((Module)module);
        if (moduleDataNode == null) {
            return testTasks;
        }
        Collection testsData = ExternalSystemApiUtil.findAll((DataNode)moduleDataNode, (Key)ProjectKeys.TEST);
        for (DataNode testDataNode : testsData) {
            TestData testData = (TestData)testDataNode.getData();
            Set sourceFolders = testData.getSourceFolders();
            for (String sourceFolder : sourceFolders) {
                if (!FileUtil.isAncestor((String)sourceFolder, (String)sourcePath, (boolean)false)) continue;
                String testName = testData.getTestName();
                String testTaskName = testData.getTestTaskName();
                SmartList tasks = new SmartList((Object)testTaskName);
                testTasks.add(new TasksToRun.Impl(testName, (List<String>)tasks));
            }
        }
        return testTasks;
    }

    @Deprecated
    @NotNull
    public static List<String> getTasksToRun(@NotNull Module module) {
        String taskPrefix;
        for (GradleTestTasksProvider provider : (GradleTestTasksProvider[])GradleTestTasksProvider.EP_NAME.getExtensions()) {
            List<String> tasks = provider.getTasks(module);
            if (ContainerUtil.isEmpty(tasks)) continue;
            return tasks;
        }
        String externalProjectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        if (externalProjectId == null) {
            return ContainerUtil.emptyList();
        }
        String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (projectPath == null) {
            return ContainerUtil.emptyList();
        }
        ExternalProjectInfo externalProjectInfo = ExternalSystemUtil.getExternalProjectInfo((Project)module.getProject(), (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)projectPath);
        if (externalProjectInfo == null) {
            return ContainerUtil.emptyList();
        }
        String gradlePath = GradleProjectResolverUtil.getGradlePath((Module)module);
        if (gradlePath == null) {
            return ContainerUtil.emptyList();
        }
        String string = taskPrefix = StringUtil.endsWithChar((CharSequence)gradlePath, (char)':') ? gradlePath : gradlePath + ':';
        if (StringUtil.endsWith((CharSequence)externalProjectId, (CharSequence)":test") || StringUtil.endsWith((CharSequence)externalProjectId, (CharSequence)":main")) {
            return ContainerUtil.map(TEST_SOURCE_SET_TASKS, task -> taskPrefix + task);
        }
        DataNode moduleNode = GradleProjectResolverUtil.findModule((DataNode)externalProjectInfo.getExternalProjectStructure(), (String)projectPath);
        if (moduleNode == null) {
            return ContainerUtil.emptyList();
        }
        String sourceSetId = StringUtil.substringAfter((String)externalProjectId, (String)(((ModuleData)moduleNode.getData()).getExternalName() + ':'));
        DataNode taskNode = sourceSetId == null ? ExternalSystemApiUtil.find((DataNode)moduleNode, (Key)ProjectKeys.TASK, node -> ((TaskData)node.getData()).isTest() && StringUtil.equals((CharSequence)"test", (CharSequence)((TaskData)node.getData()).getName()) || StringUtil.equals((CharSequence)(taskPrefix + "test"), (CharSequence)((TaskData)node.getData()).getName())) : ExternalSystemApiUtil.find((DataNode)moduleNode, (Key)ProjectKeys.TASK, node -> ((TaskData)node.getData()).isTest() && StringUtil.startsWith((CharSequence)((TaskData)node.getData()).getName(), (CharSequence)sourceSetId));
        if (taskNode == null) {
            return ContainerUtil.emptyList();
        }
        String taskName = StringUtil.trimStart((String)((TaskData)taskNode.getData()).getName(), (String)taskPrefix);
        List<String> tasks = Collections.singletonList(taskName);
        return ContainerUtil.map(tasks, task -> taskPrefix + task);
    }

    private static TestRunner getTestRunner(@NotNull Project project, @NotNull String projectPath) {
        return GradleProjectSettings.getTestRunner((Project)project, (String)projectPath);
    }

    private static TestRunner getTestRunner(@NotNull PsiElement sourceElement) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)sourceElement);
        if (module == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Cannot find module for %s", sourceElement.toString()), new Throwable());
            }
            return TestRunner.PLATFORM;
        }
        return GradleProjectSettings.getTestRunner((Module)module);
    }
}

