/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.AllInPackageGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestGradleConfigurationProducerUtilKt;
import org.jetbrains.plugins.gradle.execution.test.runner.TestTasksChooser;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleExecutionSettingsUtil;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public final class AllInDirectoryGradleConfigurationProducer
extends GradleTestRunConfigurationProducer {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return GradleExternalTaskConfigurationType.getInstance().getFactory();
    }

    @Override
    protected boolean doSetupConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        ConfigurationData configurationData = this.extractConfigurationData(context);
        if (configurationData == null) {
            return false;
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)configurationData.module)) {
            return false;
        }
        sourceElement.set((Object)configurationData.sourceElement);
        ExternalSystemTaskExecutionSettings settings = configuration.getSettings();
        Function1 createFilter = e -> GradleExecutionSettingsUtil.createTestWildcardFilter(false);
        if (!TestGradleConfigurationProducerUtilKt.applyTestConfiguration(settings, context.getModule(), configurationData.sources, it -> it, createFilter)) {
            return false;
        }
        configuration.setName(AllInDirectoryGradleConfigurationProducer.suggestName(configurationData.module));
        return true;
    }

    @Override
    protected boolean doIsConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context) {
        ConfigurationData configurationData = this.extractConfigurationData(context);
        if (configurationData == null) {
            return false;
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)configurationData.module)) {
            return false;
        }
        String projectPath = configuration.getSettings().getExternalProjectPath();
        if (!StringUtil.equals((CharSequence)configurationData.projectPath, (CharSequence)projectPath)) {
            return false;
        }
        if (configurationData.sources.isEmpty()) {
            return false;
        }
        for (VirtualFile source : configurationData.sources) {
            if (AllInDirectoryGradleConfigurationProducer.hasTasksInConfiguration(source, context.getProject(), configuration.getSettings())) continue;
            return false;
        }
        String scriptParameters = configuration.getSettings().getScriptParameters() + ' ';
        return scriptParameters.contains(GradleExecutionSettingsUtil.createTestWildcardFilter(true));
    }

    public void onFirstRun(@NotNull ConfigurationFromContext fromContext, @NotNull ConfigurationContext context, @NotNull Runnable performRunnable) {
        Runnable runnableWithCheck = this.addCheckForTemplateParams(fromContext, context, performRunnable);
        ConfigurationData configurationData = this.extractConfigurationData(context);
        if (configurationData == null) {
            LOG.warn("Cannot extract configuration data from context, uses raw run configuration");
            runnableWithCheck.run();
            return;
        }
        String locationName = String.format("'%s'", configurationData.module.getName());
        DataContext dataContext = TestTasksChooser.contextWithLocationName(context.getDataContext(), locationName);
        this.getTestTasksChooser().chooseTestTasks(context.getProject(), dataContext, configurationData.sources, tasks -> {
            ExternalSystemRunConfiguration configuration = (ExternalSystemRunConfiguration)fromContext.getConfiguration();
            ExternalSystemTaskExecutionSettings settings = configuration.getSettings();
            Function1 createFilter = e -> GradleExecutionSettingsUtil.createTestWildcardFilter(false);
            if (!TestGradleConfigurationProducerUtilKt.applyTestConfiguration(settings, context.getModule(), tasks, configurationData.sources, it -> it, createFilter)) {
                LOG.warn("Cannot apply package test configuration, uses raw run configuration");
                runnableWithCheck.run();
                return;
            }
            configuration.setName(AllInDirectoryGradleConfigurationProducer.suggestName(configurationData.module));
            runnableWithCheck.run();
        });
    }

    @Nullable
    private ConfigurationData extractConfigurationData(ConfigurationContext context) {
        Module module = context.getModule();
        if (module == null) {
            return null;
        }
        String projectPath = this.resolveProjectPath(module);
        if (projectPath == null) {
            return null;
        }
        PsiElement contextLocation = context.getPsiLocation();
        if (contextLocation == null) {
            return null;
        }
        if (AllInPackageGradleConfigurationProducer.extractPackage(contextLocation) != null) {
            return null;
        }
        if (!(contextLocation instanceof PsiFileSystemItem)) {
            return null;
        }
        PsiFileSystemItem directory = (PsiFileSystemItem)contextLocation;
        if (!directory.isDirectory()) {
            return null;
        }
        List<VirtualFile> sources = AllInDirectoryGradleConfigurationProducer.findTestSourcesUnderDirectory(module, directory.getVirtualFile());
        return new ConfigurationData(module, (PsiElement)directory, sources, projectPath);
    }

    private static List<VirtualFile> findTestSourcesUnderDirectory(@NotNull Module module, @NotNull VirtualFile directory) {
        DataNode moduleDataNode = GradleUtil.findGradleModuleData((Module)module);
        if (moduleDataNode == null) {
            return Collections.emptyList();
        }
        String rootPath = directory.getPath();
        return ExternalSystemApiUtil.findAll((DataNode)moduleDataNode, (Key)ProjectKeys.TEST).stream().map(DataNode::getData).flatMap(it -> it.getSourceFolders().stream()).filter(it -> FileUtil.isAncestor((String)rootPath, (String)it, (boolean)false)).map(it -> VfsUtil.findFile((Path)Paths.get(it, new String[0]), (boolean)false)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    private static String suggestName(@NotNull Module module) {
        return ExecutionBundle.message((String)"test.in.scope.presentable.text", (Object[])new Object[]{module.getName()});
    }

    private static class ConfigurationData {
        @NotNull
        public final Module module;
        @NotNull
        public final PsiElement sourceElement;
        @NotNull
        public final List<VirtualFile> sources;
        @NotNull
        public final String projectPath;

        private ConfigurationData(@NotNull Module module, @NotNull PsiElement sourceElement, @NotNull List<VirtualFile> sources, @NotNull String projectPath) {
            this.module = module;
            this.sourceElement = sourceElement;
            this.sources = sources;
            this.projectPath = projectPath;
        }
    }
}

