/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.config;

import com.google.api.services.mobilesdk_pa.v1.model.FirebaseClientSummary;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.services.firebase.config.AndroidClient;
import com.google.services.firebase.mobilesdk.OnlineProject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirebaseOnlineConfig {
    private final Map<AndroidClient, OnlineProject> myClientToProjectMap;
    private final Set<OnlineProject> myProjects;

    FirebaseOnlineConfig(@NotNull Collection<OnlineProject> userAccessibleProjects) {
        this.myProjects = ImmutableSet.copyOf(userAccessibleProjects);
        ImmutableMap.Builder clientMapBuilder = new ImmutableMap.Builder();
        HashSet seenClients = new HashSet();
        this.myProjects.forEach(arg_0 -> FirebaseOnlineConfig.lambda$new$3((Set)seenClients, clientMapBuilder, arg_0));
        this.myClientToProjectMap = clientMapBuilder.build();
    }

    @NotNull
    public Map<AndroidClient, OnlineProject> getClientToProjectMap() {
        return this.myClientToProjectMap;
    }

    @Nullable
    public OnlineProject getProject(@NotNull String projectNumber) {
        for (OnlineProject project : this.myProjects) {
            if (project == null || !projectNumber.equals(project.getProjectNumber())) continue;
            return project;
        }
        return null;
    }

    private static Logger getLog() {
        return Logger.getInstance(FirebaseOnlineConfig.class);
    }

    private static /* synthetic */ void lambda$new$3(Set seenClients, ImmutableMap.Builder clientMapBuilder, OnlineProject onlineProject) {
        onlineProject.getAndroidFirebaseClientSummaries().stream().filter(Objects::nonNull).map(FirebaseClientSummary::getAndroidClientSummary).filter(Objects::nonNull).filter(androidClientSummary -> androidClientSummary.getCertificateHash() != null).forEach(androidClientSummary -> {
            String packageName = androidClientSummary.getPackageName();
            androidClientSummary.getCertificateHash().stream().filter(Objects::nonNull).forEach(sha1 -> {
                AndroidClient client = AndroidClient.createClient(packageName, sha1, false);
                if (seenClients.contains(client)) {
                    FirebaseOnlineConfig.getLog().warn("Client (" + client.toString() + ") found on multiple Firebase projects, ignoring.");
                } else if (client != null) {
                    FirebaseOnlineConfig.getLog().info("Client (" + client.toString() + ") registered with project " + onlineProject.getDisplayName() + "(" + onlineProject.getProjectNumber() + ")");
                    seenClients.add(client);
                    clientMapBuilder.put((Object)client, (Object)onlineProject);
                } else {
                    FirebaseOnlineConfig.getLog().info("Ignoring package and sha1: " + packageName + ":" + sha1);
                }
            });
        });
    }
}

