/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.action.connect;

import com.android.tools.idea.assistant.AssistActionHandler;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.view.UIUtils;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.services.firebase.FirebaseAnalyticsProvider;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.action.connect.ConnectProjectCallbackHandler;
import com.google.services.firebase.action.connect.FirebaseConnectStateManager;
import com.google.services.firebase.config.AndroidClient;
import com.google.services.firebase.config.FirebaseConfig;
import com.google.services.firebase.config.FirebaseLocalConfig;
import com.google.services.firebase.consolereceiver.CancellableReceiver;
import com.google.services.firebase.consolereceiver.ReceiverResult;
import com.google.services.firebase.view.FirebaseUiUtils;
import com.google.services.firebase.view.SelectModuleDialog;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FirebaseConnectAction
implements AssistActionHandler {
    private static final Logger LOGGER = Logger.getInstance(FirebaseConnectAction.class);
    private static final String CONSOLE_CONNECT_BASE_URL = "https://console.firebase.google.com/u/0/androidstudio/connectapp";
    private static final String SETUP_DOC_URL = "https://firebase.google.com/docs/android/setup";
    private static final AndroidClient EMPTY_ANDROID_CLIENT = AndroidClient.createClient("", "", false);
    protected static final String ACTION_KEY = "firebase.connect";

    public void handleAction(@NotNull ActionData actionData, @NotNull Project project) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_CONNECT_REQUESTED).withProject(project).log();
        Module androidModule = this.getAndroidModuleToConnect(project);
        if (androidModule == null) {
            return;
        }
        try {
            FirebaseUiUtils.checkGradleState(androidModule);
        }
        catch (FirebaseUiUtils.GradleStateException exception) {
            Messages.showWarningDialog((Project)androidModule.getProject(), (String)FirebaseBundle.message("firebaseService.userError.gradleSyncNeeded", new Object[0]), (String)FirebaseBundle.message("firebase.service.dialog.title", new Object[0]));
            return;
        }
        if (AndroidModuleModel.get((Module)androidModule).getApplicationId().equals("uninitialized.application.id")) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (new CompilationDialogWrapper().showAndGet()) {
                    ImmutableList modules = ProjectStructure.getInstance((Project)androidModule.getProject()).getLeafModules();
                    GradleBuildInvoker.getInstance((Project)androidModule.getProject()).assemble(modules.toArray(Module.EMPTY_ARRAY), TestCompileType.ALL);
                }
            });
            return;
        }
        new PrepareConnectDialogTask(androidModule).queue();
    }

    @NotNull
    public String getId() {
        return ACTION_KEY;
    }

    @Nullable
    private Module getAndroidModuleToConnect(Project project) {
        Module selectedModule;
        List<Module> eligibleModules = FirebaseConnectAction.filterEligibleModules(GradleProjectInfo.getInstance((Project)project).getAndroidModules());
        if (eligibleModules.isEmpty()) {
            FirebaseUiUtils.showTrackedErrorBalloon(project, null, "firebaseConnectAction.userError.couldNotFindAndroidModule", new Object[0]);
            return null;
        }
        if (eligibleModules.size() == 1) {
            selectedModule = eligibleModules.get(0);
            LOGGER.debug("Found one Firebase project:" + selectedModule.getName());
        } else {
            SelectModuleDialog moduleDialog = new SelectModuleDialog(project, eligibleModules);
            if (moduleDialog.showAndGet()) {
                selectedModule = moduleDialog.getSelectedModule();
                LOGGER.debug("Selected project: " + selectedModule.getName() + " to connect to Firebase");
            } else {
                return null;
            }
        }
        return selectedModule;
    }

    private static List<Module> filterEligibleModules(Collection<? extends Module> modules) {
        return modules.stream().filter(input -> {
            AndroidFacet androidFacet = AndroidFacet.getInstance((Module)input);
            return androidFacet != null && ((AndroidFacetConfiguration)androidFacet.getConfiguration()).isAppProject();
        }).collect(Collectors.toList());
    }

    private static final class ConnectDialogTask
    extends Task.Modal {
        private final Module androidModule;
        private final String packageName;

        public ConnectDialogTask(@NotNull Module androidModule, @NotNull String packageName) {
            super(androidModule.getProject(), FirebaseBundle.message("ui.connect.dialog.action.connect.start", new Object[0]), true);
            this.androidModule = androidModule;
            this.packageName = packageName;
        }

        public void run(@NotNull ProgressIndicator progressIndicator) {
            try (CancellableReceiver server = new CancellableReceiver(ConnectProjectCallbackHandler.getFactory(this.androidModule));){
                server.start();
                BrowserUtil.browse((String)this.generateConsoleConnectUrl(server.getPort(), this.packageName, null));
                ReceiverResult result = server.waitForRequest(() -> ((ProgressIndicator)progressIndicator).isCanceled());
                if (result.status == ReceiverResult.Status.SUCCESS) {
                    FirebaseUiUtils.showInfoBalloonWithLink(this.androidModule.getProject(), result.resultMessage, new OpenUrlHyperlink(FirebaseConnectAction.SETUP_DOC_URL, FirebaseBundle.message("firebase.service.notification.connect.process.complete.learnMore", new Object[0])));
                    FirebaseConnectStateManager.setCompletableState(this.androidModule, false);
                } else {
                    FirebaseUiUtils.showErrorBalloon(this.androidModule.getProject(), result.resultMessage, result.exception);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Exception while running FirebaseConnect local server.", (Throwable)e);
            }
        }

        private String generateConsoleConnectUrl(int localPort, String packageName, @Nullable String accountEmail) {
            String params = this.mapAsUrlParameters((ImmutableMap<String, String>)ImmutableMap.of((Object)"forceCheckTos", (Object)"true", (Object)"localPort", (Object)Integer.toString(localPort), (Object)"packageName", (Object)packageName, (Object)"projectDisplayName", (Object)this.androidModule.getProject().getName()));
            if (accountEmail != null && !accountEmail.isEmpty()) {
                params = params + String.format("&accountEmail=%s", accountEmail);
            }
            return String.format("%s?%s", FirebaseConnectAction.CONSOLE_CONNECT_BASE_URL, params);
        }

        private String mapAsUrlParameters(ImmutableMap<String, String> map) {
            return map.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
        }
    }

    private static final class PrepareConnectDialogTask
    extends Task.Backgroundable {
        private final Module androidModule;

        public PrepareConnectDialogTask(@NotNull Module androidModule) {
            super(androidModule.getProject(), FirebaseBundle.message("ui.connect.dialog.action.preconnect.start", new Object[0]), true);
            this.androidModule = androidModule;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            FirebaseConfig firebaseConfig;
            indicator.setIndeterminate(true);
            try {
                firebaseConfig = new FirebaseConfig(this.androidModule, Collections.emptyList());
            }
            catch (FirebaseLocalConfig.InvalidLocalConfigException configException) {
                FirebaseUiUtils.showErrorBalloon(this.androidModule.getProject(), configException.getMessage(), (Throwable)((Object)configException));
                return;
            }
            if (indicator.isCanceled()) {
                return;
            }
            if (firebaseConfig.getRegisterableAndroidClients().isEmpty()) {
                FirebaseUiUtils.showErrorBalloon(this.androidModule.getProject(), FirebaseBundle.message("ui.connect.dialog.error.no.clients", new Object[0]), null);
                return;
            }
            String packageName = firebaseConfig.getRegisterableAndroidClients().stream().findFirst().orElse(EMPTY_ANDROID_CLIENT).getPackageName();
            if (packageName.isEmpty()) {
                FirebaseUiUtils.showErrorBalloon(this.androidModule.getProject(), "AndroidClientFound does not contain a package name", null);
                return;
            }
            if (firebaseConfig.isLocalConfigPresent()) {
                PrepareConnectDialogTask.showAlreadyConnectedDialog(packageName, firebaseConfig.getLocalFirebaseConfigProjectId(), this.androidModule);
                return;
            }
            new ConnectDialogTask(this.androidModule, packageName).queue();
        }

        private static void showAlreadyConnectedDialog(@NotNull String packageName, @NotNull String projectDisplayName, @NotNull Module androidApplicationModule) {
            String EXTRA_CSS = "body { padding-bottom: 10px; background-color: " + UIUtils.getCssColor((Color)UIUtils.getAsStandardBackgroundColor()) + "; width: 500px; }";
            ApplicationManager.getApplication().invokeLater(() -> {
                JTextPane dialogBody = new JTextPane();
                UIUtils.setHtml((JEditorPane)dialogBody, (String)FirebaseBundle.message("connect.reconnect.dialog.matchFoundWithName", projectDisplayName), (String)EXTRA_CSS);
                DialogBuilder dialogBuilder = new DialogBuilder(androidApplicationModule.getProject());
                dialogBuilder.setTitle(FirebaseBundle.message("connect.reconnect.dialog.title", new Object[0]));
                dialogBuilder.setCenterPanel((JComponent)dialogBody);
                dialogBuilder.removeAllActions();
                dialogBuilder.addOkAction();
                dialogBuilder.addCancelAction();
                if (dialogBuilder.show() == 0) {
                    new ConnectDialogTask(androidApplicationModule, packageName).queue();
                }
            });
        }
    }

    public static class CompilationDialogWrapper
    extends DialogWrapper {
        public CompilationDialogWrapper() {
            super(true);
            this.init();
            this.setTitle(FirebaseBundle.message("connect.gradlebuild.dialog.title", new Object[0]));
            this.setOKButtonText(FirebaseBundle.message("connect.gradlebuild.dialog.button.OKLabel", new Object[0]));
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel dialogPanel = new JPanel(new BorderLayout());
            JLabel label = new JLabel(FirebaseBundle.message("connect.gradlebluid.dialog.message", new Object[0]));
            label.setPreferredSize(new Dimension(80, 50));
            dialogPanel.add((Component)label, "Center");
            return dialogPanel;
        }
    }
}

