/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitBinaryHandler;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitFileUtils {
    private static final Logger LOG = Logger.getInstance(GitFileUtils.class);

    private GitFileUtils() {
    }

    @Deprecated
    public static void delete(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files, String ... additionalOptions) throws VcsException {
        GitFileUtils.deletePaths(project, root, files, additionalOptions);
    }

    public static void deletePaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files, String ... additionalOptions) throws VcsException {
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitFileUtils.doDelete(project, root, paths, additionalOptions);
        }
    }

    public static void deleteFiles(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> files, String ... additionalOptions) throws VcsException {
        for (List paths : VcsFileUtil.chunkFiles((VirtualFile)root, files)) {
            GitFileUtils.doDelete(project, root, paths, additionalOptions);
        }
    }

    public static void deleteFiles(@NotNull Project project, @NotNull VirtualFile root, VirtualFile ... files) throws VcsException {
        GitFileUtils.deleteFiles(project, root, Arrays.asList(files), new String[0]);
    }

    private static void doDelete(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> paths, String ... additionalOptions) throws VcsException {
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.RM);
        handler.addParameters(additionalOptions);
        handler.endOptions();
        handler.addParameters(paths);
        Git.getInstance().runCommand(handler).throwOnError(new int[0]);
    }

    public static void deleteFilesFromCache(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> files) throws VcsException {
        GitFileUtils.deleteFiles(project, root, files, "--cached");
        GitFileUtils.updateUntrackedFilesHolderOnFileRemove(project, root, files);
    }

    public static void addFiles(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> files) throws VcsException {
        for (List paths : VcsFileUtil.chunkFiles((VirtualFile)root, files)) {
            GitFileUtils.addPathsImpl(project, root, paths, false, true);
        }
        GitFileUtils.updateUntrackedFilesHolderOnFileAdd(project, root, files);
    }

    public static void addFilesForce(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> files) throws VcsException {
        for (List paths : VcsFileUtil.chunkFiles((VirtualFile)root, files)) {
            GitFileUtils.addPathsImpl(project, root, paths, true, false);
        }
        GitFileUtils.updateUntrackedFilesHolderOnFileAdd(project, root, files);
    }

    private static void updateUntrackedFilesHolderOnFileAdd(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> addedFiles) {
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root.getPresentableUrl());
            return;
        }
        repository.getUntrackedFilesHolder().remove(ContainerUtil.map(addedFiles, VcsUtil::getFilePath));
    }

    private static void updateIgnoredFilesHolderOnFileAdd(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<VirtualFile> addedFiles) {
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root.getPresentableUrl());
            return;
        }
        repository.getIgnoredFilesHolder().removeIgnoredFiles((Collection)ContainerUtil.mapNotNull(addedFiles, VcsUtil::getFilePath));
    }

    private static void updateUntrackedFilesHolderOnFileRemove(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> removedFiles) {
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root.getPresentableUrl());
            return;
        }
        repository.getUntrackedFilesHolder().add(ContainerUtil.map(removedFiles, VcsUtil::getFilePath));
    }

    private static void updateUntrackedFilesHolderOnFileReset(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> resetFiles) {
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root.getPresentableUrl());
            return;
        }
        repository.getUntrackedFilesHolder().markPossiblyUntracked(resetFiles);
    }

    public static void addFiles(@NotNull Project project, @NotNull VirtualFile root, VirtualFile ... files) throws VcsException {
        GitFileUtils.addFiles(project, root, Arrays.asList(files));
    }

    public static void addPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> paths) throws VcsException {
        GitFileUtils.addPaths(project, root, paths, false);
    }

    public static void addPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files, boolean force) throws VcsException {
        GitFileUtils.addPaths(project, root, files, force, !force);
    }

    public static void addPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files, boolean force, boolean filterOutIgnored) throws VcsException {
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitFileUtils.addPathsImpl(project, root, paths, force, filterOutIgnored);
        }
        GitFileUtils.updateUntrackedFilesHolderOnFileAdd(project, root, GitFileUtils.getVirtualFilesFromFilePaths(files));
        if (force) {
            GitFileUtils.updateIgnoredFilesHolderOnFileAdd(project, root, GitFileUtils.getVirtualFilesFromFilePaths(files));
        }
    }

    public static void addPathsForce(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files) throws VcsException {
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitFileUtils.addPathsImpl(project, root, paths, true, false);
        }
        GitFileUtils.updateUntrackedFilesHolderOnFileAdd(project, root, GitFileUtils.getVirtualFilesFromFilePaths(files));
        GitFileUtils.updateIgnoredFilesHolderOnFileAdd(project, root, GitFileUtils.getVirtualFilesFromFilePaths(files));
    }

    @NotNull
    private static Collection<VirtualFile> getVirtualFilesFromFilePaths(@NotNull Collection<? extends FilePath> paths) {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(paths.size());
        for (FilePath filePath : paths) {
            VirtualFile file = filePath.getVirtualFile();
            if (file == null) continue;
            files.add(file);
        }
        return files;
    }

    private static void addPathsImpl(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> paths, boolean force, boolean filterOutIgnored) throws VcsException {
        if (filterOutIgnored && (paths = GitFileUtils.excludeIgnoredFiles(project, root, paths)).isEmpty()) {
            return;
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.ADD);
        handler.addParameters("--ignore-errors", "-A");
        if (force) {
            handler.addParameters("-f");
        }
        handler.endOptions();
        handler.addParameters(paths);
        Git.getInstance().runCommand(handler).throwOnError(new int[0]);
    }

    @NotNull
    private static List<String> excludeIgnoredFiles(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> paths) throws VcsException {
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.LS_FILES);
        handler.setSilent(true);
        handler.addParameters("--ignored", "--others", "--exclude-standard");
        handler.endOptions();
        handler.addParameters(paths);
        String output = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
        ArrayList<String> nonIgnoredFiles = new ArrayList<String>(paths.size());
        HashSet<String> ignoredPaths = new HashSet<String>(Arrays.asList(StringUtil.splitByLines((String)output)));
        for (String pathToCheck : paths) {
            if (ignoredPaths.contains(pathToCheck)) continue;
            nonIgnoredFiles.add(pathToCheck);
        }
        return nonIgnoredFiles;
    }

    public static void resetPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files) throws VcsException {
        for (List filesChunk : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.RESET);
            handler.endOptions();
            handler.addParameters(filesChunk);
            Git.getInstance().runCommand(handler).throwOnError(new int[0]);
        }
        GitFileUtils.updateUntrackedFilesHolderOnFileReset(project, root, files);
    }

    public static void revertUnstagedPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.CHECKOUT);
            handler.endOptions();
            handler.addParameters(paths);
            Git.getInstance().runCommand(handler).throwOnError(new int[0]);
        }
    }

    public static byte @NotNull [] getFileContent(@NotNull Project project, @NotNull VirtualFile root, @NotNull String revisionOrBranch, @NotNull String relativePath) throws VcsException {
        GitBinaryHandler h2 = new GitBinaryHandler(project, root, GitCommand.CAT_FILE);
        h2.setSilent(true);
        GitFileUtils.addTextConvParameters(project, h2, true);
        h2.addParameters(revisionOrBranch + ":" + relativePath);
        return h2.run();
    }

    public static void addTextConvParameters(@NotNull Project project, @NotNull GitBinaryHandler h2, boolean addp) {
        GitFileUtils.addTextConvParameters(GitExecutableManager.getInstance().tryGetVersion(project), h2, addp);
    }

    public static void addTextConvParameters(@Nullable GitVersion version, @NotNull GitBinaryHandler h2, boolean addp) {
        if (GitVersionSpecialty.CAT_FILE_SUPPORTS_TEXTCONV.existsIn(version = (GitVersion)ObjectUtils.chooseNotNull((Object)version, (Object)GitVersion.NULL)) && Registry.is((String)"git.read.content.with.textconv")) {
            h2.addParameters("--textconv");
        } else if (GitVersionSpecialty.CAT_FILE_SUPPORTS_FILTERS.existsIn(version) && Registry.is((String)"git.read.content.with.filters")) {
            h2.addParameters("--filters");
        } else if (addp) {
            h2.addParameters("-p");
        }
    }
}

