/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitLocalBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchPair;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVersionSpecialty;
import git4idea.config.UpdateMethod;
import git4idea.merge.MergeChangeCollector;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitMergeUpdater;
import git4idea.update.GitRebaseUpdater;
import git4idea.update.GitUpdateResult;
import org.jetbrains.annotations.NotNull;

public abstract class GitUpdater {
    private static final Logger LOG = Logger.getInstance(GitUpdater.class);
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final Git myGit;
    @NotNull
    protected final VirtualFile myRoot;
    @NotNull
    protected final GitRepository myRepository;
    @NotNull
    protected final ProgressIndicator myProgressIndicator;
    @NotNull
    protected final UpdatedFiles myUpdatedFiles;
    @NotNull
    protected final AbstractVcsHelper myVcsHelper;
    @NotNull
    protected final GitRepositoryManager myRepositoryManager;
    protected final GitVcs myVcs;
    protected GitRevisionNumber myBefore;

    protected GitUpdater(@NotNull Project project, @NotNull Git git, @NotNull GitRepository repository, @NotNull ProgressIndicator progressIndicator, @NotNull UpdatedFiles updatedFiles) {
        this.myProject = project;
        this.myGit = git;
        this.myRoot = repository.getRoot();
        this.myRepository = repository;
        this.myProgressIndicator = progressIndicator;
        this.myUpdatedFiles = updatedFiles;
        this.myVcsHelper = AbstractVcsHelper.getInstance((Project)project);
        this.myVcs = GitVcs.getInstance(project);
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
    }

    @NotNull
    public static GitUpdater getUpdater(@NotNull Project project, @NotNull Git git, @NotNull GitBranchPair trackedBranches, @NotNull GitRepository repository, @NotNull ProgressIndicator progressIndicator, @NotNull UpdatedFiles updatedFiles, @NotNull UpdateMethod updateMethod) {
        if (updateMethod == UpdateMethod.BRANCH_DEFAULT) {
            updateMethod = GitUpdater.resolveUpdateMethod(repository);
        }
        return updateMethod == UpdateMethod.REBASE ? new GitRebaseUpdater(project, git, repository, trackedBranches, progressIndicator, updatedFiles) : new GitMergeUpdater(project, git, repository, trackedBranches, progressIndicator, updatedFiles);
    }

    @NotNull
    public static UpdateMethod resolveUpdateMethod(@NotNull GitRepository repository) {
        Project project = repository.getProject();
        GitLocalBranch branch = repository.getCurrentBranch();
        if (branch != null) {
            String branchName = branch.getName();
            try {
                String rebaseValue = GitConfigUtil.getValue(project, repository.getRoot(), "branch." + branchName + ".rebase");
                if (rebaseValue != null) {
                    if (GitUpdater.isRebaseValue(rebaseValue)) {
                        return UpdateMethod.REBASE;
                    }
                    if (GitConfigUtil.getBooleanValue(rebaseValue) == Boolean.FALSE) {
                        return UpdateMethod.MERGE;
                    }
                    LOG.warn("Unknown value for branch." + branchName + ".rebase: " + rebaseValue);
                }
            }
            catch (VcsException e) {
                LOG.warn("Couldn't get git config branch." + branchName + ".rebase");
            }
        }
        if (GitVersionSpecialty.KNOWS_PULL_REBASE.existsIn(project)) {
            try {
                String pullRebaseValue = GitConfigUtil.getValue(project, repository.getRoot(), "pull.rebase");
                if (pullRebaseValue != null && GitUpdater.isRebaseValue(pullRebaseValue)) {
                    return UpdateMethod.REBASE;
                }
            }
            catch (VcsException e) {
                LOG.warn("Couldn't get git config pull.rebase");
            }
        }
        return UpdateMethod.MERGE;
    }

    private static boolean isRebaseValue(@NotNull String configValue) {
        return GitConfigUtil.getBooleanValue(configValue) == Boolean.TRUE || configValue.equalsIgnoreCase("interactive") || configValue.equalsIgnoreCase("preserve");
    }

    @NotNull
    public GitUpdateResult update() throws VcsException {
        this.markStart(this.myRepository);
        try {
            GitUpdateResult result2 = this.doUpdate();
            this.myRepository.update();
            GitUpdateResult gitUpdateResult = result2;
            return gitUpdateResult;
        }
        finally {
            this.markEnd(this.myRepository);
        }
    }

    public abstract boolean isSaveNeeded();

    public boolean isUpdateNeeded(@NotNull GitBranchPair branchPair) throws VcsException {
        String remoteBranch = branchPair.getTarget().getName();
        if (!this.hasRemoteChanges(remoteBranch)) {
            LOG.info("isUpdateNeeded: No remote changes, update is not needed");
            return false;
        }
        return true;
    }

    @NotNull
    protected abstract GitUpdateResult doUpdate();

    protected void markStart(GitRepository repository) throws VcsException {
        this.myBefore = GitRevisionNumber.resolve(this.myProject, repository.getRoot(), "HEAD");
    }

    protected void markEnd(GitRepository repository) throws VcsException {
        new MergeChangeCollector(this.myProject, repository, this.myBefore).collect(this.myUpdatedFiles);
    }

    protected boolean hasRemoteChanges(@NotNull String remoteBranch) throws VcsException {
        GitLineHandler handler = new GitLineHandler(this.myProject, this.myRoot, GitCommand.REV_LIST);
        handler.setSilent(true);
        handler.addParameters("-1");
        handler.addParameters("HEAD.." + remoteBranch);
        String output = this.myGit.runCommand(handler).getOutputOrThrow(new int[0]);
        return output != null && !output.isEmpty();
    }
}

